/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;

public class JRGzipVirtualizer
extends JRAbstractLRUVirtualizer {
    private final Map zippedData = Collections.synchronizedMap(new HashMap());

    public JRGzipVirtualizer(int n2) {
        super(n2);
    }

    public void dispose(String string) {
        this.zippedData.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageOut(JRVirtualizable jRVirtualizable) throws IOException {
        if (!this.zippedData.containsKey(jRVirtualizable.getUID())) {
            DeflaterOutputStream deflaterOutputStream = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(3000);
                deflaterOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                this.writeData(jRVirtualizable, deflaterOutputStream);
                ((GZIPOutputStream)deflaterOutputStream).finish();
                deflaterOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.zippedData.put(jRVirtualizable.getUID(), byArray);
            }
            finally {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.close();
                }
            }
        } else if (!this.isReadOnly(jRVirtualizable)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + jRVirtualizable.getUID() + "\" already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageIn(JRVirtualizable jRVirtualizable) throws IOException {
        GZIPInputStream gZIPInputStream = null;
        try {
            byte[] byArray = (byte[])this.zippedData.get(jRVirtualizable.getUID());
            if (byArray == null) {
                throw new NullPointerException("No data found for object with UID " + jRVirtualizable.getUID());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            this.readData(jRVirtualizable, gZIPInputStream);
        }
        finally {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
        }
        if (!this.isReadOnly(jRVirtualizable)) {
            this.zippedData.remove(jRVirtualizable.getUID());
        }
    }

    public void cleanup() {
        this.zippedData.clear();
        this.reset();
    }
}

