/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private boolean isLeftToRight = true;
    private JRTextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String textTruncateSuffix;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributesMap = new HashMap();
    public final JRReportFont reportFont;

    public JRFillTextElement(JRBaseFiller jRBaseFiller, JRTextElement jRTextElement, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRTextElement, jRFillObjectFactory);
        this.reportFont = jRFillObjectFactory.getReportFont(jRTextElement.getReportFont());
    }

    public JRFillTextElement(JRFillTextElement jRFillTextElement, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillTextElement, jRFillCloneFactory);
        this.reportFont = jRFillTextElement.reportFont;
    }

    private void createTextMeasurer() {
        this.textMeasurer = JRTextMeasurerUtil.createTextMeasurer(this);
    }

    public void ensureTextMeasurer() {
        if (this.textMeasurer == null) {
            this.createTextMeasurer();
        }
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getTextAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public void setTextAlignment(byte by2) {
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    public void setHorizontalAlignment(byte by2) {
    }

    public void setHorizontalAlignment(Byte by2) {
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    public void setVerticalAlignment(byte by2) {
    }

    public void setVerticalAlignment(Byte by2) {
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    public void setRotation(byte by2) {
    }

    public void setRotation(Byte by2) {
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    public void setLineSpacing(byte by2) {
    }

    public void setLineSpacing(Byte by2) {
    }

    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return ((JRTextElement)this.parent).isOwnStyledText();
    }

    public void setStyledText(boolean bl2) {
    }

    public void setStyledText(Boolean bl2) {
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return ((JRBoxContainer)((Object)this.parent)).getLineBox();
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getPen());
    }

    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.getLineBox().getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    public void setPadding(int n2) {
        this.getLineBox().setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.getLineBox().setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getTopPen());
    }

    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.getLineBox().getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.getLineBox().setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.getLineBox().setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.getLineBox().getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.getLineBox().setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.getLineBox().setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.getLineBox().getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.getLineBox().setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.getLineBox().setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getRightPen());
    }

    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.getLineBox().getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.getLineBox().setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.getLineBox().setRightPadding(n2);
    }

    public JRFont getFont() {
        return this;
    }

    public Map getStyledTextAttributes() {
        JRStyle jRStyle = this.getStyle();
        HashMap<TextAttribute, Color> hashMap = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(jRStyle);
        if (hashMap == null) {
            hashMap = new HashMap<TextAttribute, Color>();
            JRFontUtil.setAttributes(hashMap, this);
            hashMap.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                hashMap.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(jRStyle, hashMap);
        }
        return hashMap;
    }

    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    public void setLineSpacingFactor(float f2) {
        this.lineSpacingFactor = f2;
    }

    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    public void setLeadingOffset(float f2) {
        this.leadingOffset = f2;
    }

    public byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(float f2) {
        this.textHeight = f2;
    }

    public int getTextStart() {
        return this.textStart;
    }

    public void setTextStart(int n2) {
        this.textStart = n2;
    }

    public int getTextEnd() {
        return this.textEnd;
    }

    public void setTextEnd(int n2) {
        this.textEnd = n2;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String string) {
        this.rawText = string;
        this.styledText = null;
    }

    public void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    public void rewind() {
        this.textStart = 0;
        this.textEnd = 0;
    }

    public JRStyledText getStyledText() {
        String string;
        if (this.styledText == null && (string = this.getRawText()) != null) {
            this.styledText = this.filler.getStyledTextParser().getStyledText(this.getStyledTextAttributes(), string, this.isStyledText());
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return null;
        }
        return jRStyledText.getText();
    }

    public void chopTextElement(int n2) {
        this.ensureTextMeasurer();
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return;
        }
        if (this.getTextEnd() == jRStyledText.getText().length()) {
            return;
        }
        JRMeasuredText jRMeasuredText = this.textMeasurer.measure(jRStyledText, this.getTextEnd(), n2, this.canOverflow());
        this.isLeftToRight = jRMeasuredText.isLeftToRight();
        this.setTextHeight(jRMeasuredText.getTextHeight());
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight() + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(jRMeasuredText.getTextOffset());
        this.setTextTruncateSuffix(jRMeasuredText.getTextSuffix());
        this.setLineSpacingFactor(jRMeasuredText.getLineSpacingFactor());
        this.setLeadingOffset(jRMeasuredText.getLeadingOffset());
    }

    public abstract boolean canOverflow();

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont jRReportFont) {
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    public void setFontName(String string) {
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    public void setBold(boolean bl2) {
    }

    public void setBold(Boolean bl2) {
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    public void setItalic(boolean bl2) {
    }

    public void setItalic(Boolean bl2) {
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    public void setUnderline(boolean bl2) {
    }

    public void setUnderline(Boolean bl2) {
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    public void setStrikeThrough(boolean bl2) {
    }

    public void setStrikeThrough(Boolean bl2) {
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    public void setFontSize(int n2) {
    }

    public void setFontSize(Integer n2) {
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int n2) {
    }

    public void setSize(Integer n2) {
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    public void setPdfFontName(String string) {
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    public void setPdfEncoding(String string) {
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    public void setPdfEmbedded(boolean bl2) {
        this.setPdfEmbedded(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean bl2) {
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public void setHeight(int n2) {
        super.setHeight(n2);
        this.createTextMeasurer();
    }

    public void setWidth(int n2) {
        super.setWidth(n2);
        this.createTextMeasurer();
    }

    public void setPrintText(JRPrintText jRPrintText) {
        boolean bl2;
        int n2 = this.getTextStart();
        int n3 = this.getTextEnd();
        JRStyledText jRStyledText = this.getStyledText();
        String string = jRStyledText.getText();
        boolean bl3 = bl2 = !this.canOverflow() && JRProperties.getBooleanProperty(this, "net.sf.jasperreports.print.keep.full.text", false);
        if (bl2) {
            if (n2 != 0) {
                throw new JRRuntimeException("Text start index != 0 on keep all text.");
            }
            if (this.isStyledText()) {
                String string2 = this.filler.getStyledTextParser().write(jRStyledText);
                jRPrintText.setText(string2);
            } else {
                jRPrintText.setText(string);
            }
            if (n3 < string.length()) {
                jRPrintText.setTextTruncateIndex(new Integer(n3));
            }
        } else {
            String string3 = this.isStyledText() ? this.filler.getStyledTextParser().write(jRStyledText, n2, n3) : string.substring(n2, n3);
            jRPrintText.setText(string3);
        }
        jRPrintText.setTextTruncateSuffix(this.getTextTruncateSuffix());
    }

    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    public void setTextTruncateSuffix(String string) {
        this.textTruncateSuffix = string;
    }
}

