/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRFillBand;

public class JREvaluationTime
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final JREvaluationTime EVALUATION_TIME_REPORT = new JREvaluationTime(2, null, null);
    public static final JREvaluationTime EVALUATION_TIME_PAGE = new JREvaluationTime(3, null, null);
    public static final JREvaluationTime EVALUATION_TIME_COLUMN = new JREvaluationTime(4, null, null);
    public static final JREvaluationTime EVALUATION_TIME_NOW = new JREvaluationTime(1, null, null);
    private final byte type;
    private final String groupName;
    private final int bandId;
    private final int hash;

    public static JREvaluationTime getGroupEvaluationTime(String string) {
        return new JREvaluationTime(5, string, null);
    }

    public static JREvaluationTime getBandEvaluationTime(JRFillBand jRFillBand) {
        return new JREvaluationTime(6, null, jRFillBand);
    }

    public static JREvaluationTime getEvaluationTime(byte by2, JRGroup jRGroup, JRFillBand jRFillBand) {
        JREvaluationTime jREvaluationTime;
        switch (by2) {
            case 2: {
                jREvaluationTime = EVALUATION_TIME_REPORT;
                break;
            }
            case 3: {
                jREvaluationTime = EVALUATION_TIME_PAGE;
                break;
            }
            case 4: {
                jREvaluationTime = EVALUATION_TIME_COLUMN;
                break;
            }
            case 5: {
                jREvaluationTime = JREvaluationTime.getGroupEvaluationTime(jRGroup.getName());
                break;
            }
            case 6: {
                jREvaluationTime = JREvaluationTime.getBandEvaluationTime(jRFillBand);
                break;
            }
            default: {
                jREvaluationTime = null;
            }
        }
        return jREvaluationTime;
    }

    private JREvaluationTime(byte by2, String string, JRFillBand jRFillBand) {
        this.type = by2;
        this.groupName = string;
        this.bandId = jRFillBand == null ? 0 : jRFillBand.getId();
        this.hash = this.computeHash();
    }

    private int computeHash() {
        int n2 = this.type;
        n2 = 31 * n2 + (this.groupName == null ? 0 : this.groupName.hashCode());
        n2 = 31 * n2 + this.bandId;
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (object == this) {
            return true;
        }
        JREvaluationTime jREvaluationTime = (JREvaluationTime)object;
        boolean bl3 = bl2 = jREvaluationTime.type == this.type;
        if (bl2) {
            switch (this.type) {
                case 5: {
                    bl2 = this.groupName.equals(jREvaluationTime.groupName);
                    break;
                }
                case 6: {
                    bl2 = this.bandId == jREvaluationTime.bandId;
                }
            }
        }
        return bl2;
    }

    public int hashCode() {
        return this.hash;
    }
}

