/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;

public class JRClonePool {
    private final JRFillCloneable original;
    private final LinkedList availableClones;
    private final boolean trackLockedClones;
    private final Set lockedClones;

    public JRClonePool(JRFillCloneable jRFillCloneable, boolean bl2, boolean bl3) {
        this.original = jRFillCloneable;
        this.availableClones = new LinkedList();
        this.trackLockedClones = bl2;
        this.lockedClones = bl2 ? new HashSet() : null;
        if (bl3) {
            this.availableClones.add(jRFillCloneable);
        }
    }

    public Object getClone() {
        JRFillCloneable jRFillCloneable;
        if (this.availableClones.isEmpty()) {
            JRFillCloneFactory jRFillCloneFactory = new JRFillCloneFactory();
            jRFillCloneable = this.original.createClone(jRFillCloneFactory);
        } else {
            jRFillCloneable = (JRFillCloneable)this.availableClones.removeFirst();
        }
        if (this.trackLockedClones) {
            this.lockedClones.add(jRFillCloneable);
        }
        return jRFillCloneable;
    }

    public void releaseClone(Object object) {
        if (this.trackLockedClones && !this.lockedClones.remove(object)) {
            throw new JRRuntimeException("Cannot release clone.");
        }
        this.availableClones.addLast(object);
    }
}

