/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRByteIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

public class JRByteCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRByteCountIncrementer mainInstance = new JRByteCountIncrementer();

    private JRByteCountIncrementer() {
    }

    public static JRByteCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRByteIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Byte((byte)(number.byteValue() + 1));
    }

    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRByteIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Byte((byte)(number.byteValue() + number2.byteValue()));
    }

    public Object initialValue() {
        return JRByteIncrementerFactory.ZERO;
    }
}

