/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;

public class AsynchronousFillHandle {
    public final JasperReport jasperReport;
    public final Map parameters;
    public final JRDataSource dataSource;
    public final Connection conn;
    public final JRBaseFiller filler;
    public final List listeners;
    public Thread fillThread;
    public boolean started = false;
    public boolean running = false;
    public boolean cancelled = false;
    public final Object lock;
    public Integer priority = null;
    public String threadName;

    public AsynchronousFillHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource) throws JRException {
        this(jasperReport, map, jRDataSource, null);
    }

    public AsynchronousFillHandle(JasperReport jasperReport, Map map, Connection connection) throws JRException {
        this(jasperReport, map, null, connection);
    }

    public AsynchronousFillHandle(JasperReport jasperReport, Map map) throws JRException {
        this(jasperReport, map, null, null);
    }

    public AsynchronousFillHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource, Connection connection) throws JRException {
        this.jasperReport = jasperReport;
        this.parameters = map;
        this.dataSource = jRDataSource;
        this.conn = connection;
        this.filler = JRFiller.createFiller(jasperReport);
        this.listeners = new ArrayList();
        this.lock = this;
    }

    public void addListener(AsynchronousFilllListener asynchronousFilllListener) {
        this.listeners.add(asynchronousFilllListener);
    }

    public boolean removeListener(AsynchronousFilllListener asynchronousFilllListener) {
        return this.listeners.remove(asynchronousFilllListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFill() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Fill already started.");
            }
            this.started = true;
        }
        object = new ReportFiller(this);
        this.fillThread = this.threadName == null ? new Thread((Runnable)object) : new Thread((Runnable)object, this.threadName);
        if (this.priority != null) {
            this.fillThread.setPriority(this.priority);
        }
        this.fillThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancellFill() throws JRException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                throw new IllegalStateException("Fill not running.");
            }
            this.filler.cancelFill();
            this.cancelled = true;
        }
    }

    public void notifyFinish(JasperPrint jasperPrint) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportFinished(jasperPrint);
        }
    }

    public void notifyCancel() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportCancelled();
        }
    }

    public void notifyError(Throwable throwable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportFillError(throwable);
        }
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map, jRDataSource);
        return asynchronousFillHandle;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map, Connection connection) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map, connection);
        return asynchronousFillHandle;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map);
        return asynchronousFillHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.priority = new Integer(n2);
            if (this.fillThread != null) {
                this.fillThread.setPriority(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadName(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.threadName = string;
            if (this.fillThread != null) {
                this.fillThread.setName(string);
            }
        }
    }

    protected class ReportFiller
    implements Runnable {
        private final AsynchronousFillHandle this$0;

        public ReportFiller(AsynchronousFillHandle asynchronousFillHandle) {
            this.this$0 = asynchronousFillHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.this$0.lock;
            synchronized (object) {
                this.this$0.running = true;
            }
            try {
                object = this.this$0.conn != null ? this.this$0.filler.fill(this.this$0.parameters, this.this$0.conn) : (this.this$0.dataSource != null ? this.this$0.filler.fill(this.this$0.parameters, this.this$0.dataSource) : this.this$0.filler.fill(this.this$0.parameters));
                this.this$0.notifyFinish((JasperPrint)object);
            }
            catch (Exception exception) {
                Object object2 = this.this$0.lock;
                synchronized (object2) {
                    if (this.this$0.cancelled) {
                        this.this$0.notifyCancel();
                    } else {
                        this.this$0.notifyError(exception);
                    }
                }
            }
            finally {
                Object object3 = this.this$0.lock;
                synchronized (object3) {
                    this.this$0.running = false;
                }
            }
        }
    }
}

