/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZipEntry;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JROdtFrameExporter
extends JRAbstractExporter {
    public static final String VERSION = "1.0";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    public static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    public Writer tempBodyWriter = null;
    public Writer tempStyleWriter = null;
    public JRExportProgressMonitor progressMonitor = null;
    public Map rendererToImagePathMap = null;
    public Map imageMaps;
    public List imagesToProcess = null;
    public int reportIndex = 0;
    public int pageIndex = 0;
    public int tableIndex = 0;
    public String encoding = null;
    public boolean isWrapBreakWord = false;
    public Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    private StyleCache styleCache = null;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = "UTF-8";
                }
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.exportReportToOasisZip(outputStream);
                        break block21;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), iOException);
                    }
                }
                File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (file == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        file = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToOasisZip(outputStream);
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public void exportReportToOasisZip(OutputStream outputStream) throws JRException, IOException {
        Object object;
        FileBufferedOasisZip fileBufferedOasisZip = new FileBufferedOasisZip();
        FileBufferedOasisZipEntry fileBufferedOasisZipEntry = new FileBufferedOasisZipEntry(null);
        FileBufferedOasisZipEntry fileBufferedOasisZipEntry2 = new FileBufferedOasisZipEntry(null);
        this.tempBodyWriter = fileBufferedOasisZipEntry.getWriter();
        this.tempStyleWriter = fileBufferedOasisZipEntry2.getWriter();
        this.styleCache = new StyleCache(this.tempStyleWriter, this.fontMap);
        Writer writer = fileBufferedOasisZip.getStylesEntry().getWriter();
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, writer);
        styleBuilder.build();
        writer.close();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            object = this.jasperPrint.getPages();
            if (object != null && object.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = object.size() - 1;
                }
                JRPrintPage jRPrintPage = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    jRPrintPage = (JRPrintPage)object.get(this.pageIndex);
                    this.exportPage(jRPrintPage);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        object = new ContentBuilder(fileBufferedOasisZip.getContentEntry(), fileBufferedOasisZipEntry2, fileBufferedOasisZipEntry, this.styleCache.getFontFaces());
        ((ContentBuilder)object).build();
        fileBufferedOasisZip.zipEntries(outputStream);
        fileBufferedOasisZip.dispose();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public void exportElements(Collection collection) throws IOException, JRException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) continue;
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            }
        }
    }

    public void exportLine(JRPrintLine jRPrintLine) throws IOException {
        this.tempBodyWriter.write("\n<draw:line text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x2=\"" + Utility.translatePixelsToInches(jRPrintLine.getX() + jRPrintLine.getWidth()) + "in\"" + " svg:y2=\"" + Utility.translatePixelsToInches(jRPrintLine.getY() + jRPrintLine.getHeight()) + "in\"" + " svg:x1=\"" + Utility.translatePixelsToInches(jRPrintLine.getX()) + "in\"" + " svg:y1=\"" + Utility.translatePixelsToInches(jRPrintLine.getY()) + "in\">" + " draw:style-name=\"" + this.styleCache.getGraphicStyle(jRPrintLine) + "\"" + "</draw:line>");
    }

    public void exportRectangle(JRPrintRectangle jRPrintRectangle) throws IOException {
        this.tempBodyWriter.write("<draw:rect text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(jRPrintRectangle.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(jRPrintRectangle.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(jRPrintRectangle.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(jRPrintRectangle.getHeight()) + "in\"" + "></draw:rect>");
    }

    public void exportEllipse(JRPrintEllipse jRPrintEllipse) throws IOException {
        this.tempBodyWriter.write("<draw:ellipse text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getHeight()) + "in\"" + "></draw:ellipse>");
    }

    public void exportText(JRPrintText jRPrintText) throws IOException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        int n2 = 0;
        if (jRStyledText != null) {
            n2 = jRStyledText.length();
        }
        this.tempBodyWriter.write("<draw:frame text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " draw:style-name=\"" + this.styleCache.getFrameStyle(jRPrintText) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(jRPrintText.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(jRPrintText.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(jRPrintText.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(jRPrintText.getHeight()) + "in\"" + "><draw:text-box>");
        this.tempBodyWriter.write("<text:p");
        this.tempBodyWriter.write(" text:style-name=\"" + this.styleCache.getParagraphStyle(jRPrintText) + "\"");
        this.tempBodyWriter.write(">");
        if (n2 > 0) {
            this.exportStyledText(jRStyledText);
        }
        this.tempBodyWriter.write("</text:p>\n");
        this.tempBodyWriter.write("</draw:text-box></draw:frame>");
    }

    public void exportStyledText(JRStyledText jRStyledText) throws IOException {
        String string = jRStyledText.getText();
        int n2 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n2 < jRStyledText.length() && (n2 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            this.exportStyledTextRun(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n2));
            attributedCharacterIterator.setIndex(n2);
        }
    }

    public void exportStyledTextRun(Map map, String string) throws IOException {
        String string2 = this.styleCache.getTextSpanStyle(map, string);
        this.tempBodyWriter.write("<text:span");
        this.tempBodyWriter.write(" text:style-name=\"" + string2 + "\"");
        this.tempBodyWriter.write(">");
        if (string != null) {
            this.tempBodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(string)));
        }
        this.tempBodyWriter.write("</text:span>");
    }
}

