/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterNature;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZipEntry;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JROdtExporter
extends JRAbstractExporter {
    private static final String ODT_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.odt.exclude.origin.";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String HORIZONTAL_ALIGN_LEFT = "start";
    public static final String HORIZONTAL_ALIGN_RIGHT = "end";
    public static final String HORIZONTAL_ALIGN_CENTER = "center";
    public static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    public static final String VERTICAL_ALIGN_TOP = "top";
    public static final String VERTICAL_ALIGN_MIDDLE = "middle";
    public static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    public static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    public Writer tempBodyWriter = null;
    public Writer tempStyleWriter = null;
    public JRExportProgressMonitor progressMonitor = null;
    public Map rendererToImagePathMap = null;
    public Map imageMaps;
    public List imagesToProcess = null;
    public int reportIndex = 0;
    public int pageIndex = 0;
    public int tableIndex = 0;
    public String encoding = null;
    public boolean isWrapBreakWord = false;
    public Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    private StyleCache styleCache = null;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;
    public ExporterNature nature = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), ODT_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = this.getStringParameter(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.encoding = this.encoding == null ? JRProperties.getProperty("net.sf.jasperreports.export.character.encoding") : this.encoding;
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                this.nature = new JROdtExporterNature(this.filter);
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.exportReportToOasisZip(outputStream);
                        break block21;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), iOException);
                    }
                }
                File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (file == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        file = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToOasisZip(outputStream);
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public static JRPrintImage getImage(List list, String string) {
        return JROdtExporter.getImage(list, JROdtExporter.getPrintElementIndex(string));
    }

    public static JRPrintImage getImage(List list, JRPrintElementIndex jRPrintElementIndex) {
        JasperPrint jasperPrint = (JasperPrint)list.get(jRPrintElementIndex.getReportIndex());
        JRPrintPage jRPrintPage = (JRPrintPage)jasperPrint.getPages().get(jRPrintElementIndex.getPageIndex());
        Integer[] integerArray = jRPrintElementIndex.getAddressArray();
        Object e2 = jRPrintPage.getElements().get(integerArray[0]);
        for (int i2 = 1; i2 < integerArray.length; ++i2) {
            JRPrintFrame jRPrintFrame = (JRPrintFrame)e2;
            e2 = jRPrintFrame.getElements().get(integerArray[i2]);
        }
        return (JRPrintImage)e2;
    }

    public void exportReportToOasisZip(OutputStream outputStream) throws JRException, IOException {
        Object object;
        Object object2;
        FileBufferedOasisZip fileBufferedOasisZip = new FileBufferedOasisZip();
        FileBufferedOasisZipEntry fileBufferedOasisZipEntry = new FileBufferedOasisZipEntry(null);
        FileBufferedOasisZipEntry fileBufferedOasisZipEntry2 = new FileBufferedOasisZipEntry(null);
        this.tempBodyWriter = fileBufferedOasisZipEntry.getWriter();
        this.tempStyleWriter = fileBufferedOasisZipEntry2.getWriter();
        this.styleCache = new StyleCache(this.tempStyleWriter, this.fontMap);
        Writer writer = fileBufferedOasisZip.getStylesEntry().getWriter();
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, writer);
        styleBuilder.build();
        writer.close();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            object2 = this.jasperPrint.getPages();
            if (object2 != null && object2.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = object2.size() - 1;
                }
                object = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    object = (JRPrintPage)object2.get(this.pageIndex);
                    this.exportPage((JRPrintPage)object);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        object2 = new ContentBuilder(fileBufferedOasisZip.getContentEntry(), fileBufferedOasisZipEntry2, fileBufferedOasisZipEntry, this.styleCache.getFontFaces());
        ((ContentBuilder)object2).build();
        fileBufferedOasisZipEntry2.dispose();
        fileBufferedOasisZipEntry.dispose();
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            object = this.imagesToProcess.iterator();
            while (object.hasNext()) {
                JRPrintElementIndex jRPrintElementIndex = (JRPrintElementIndex)object.next();
                JRPrintImage jRPrintImage = JROdtExporter.getImage(this.jasperPrintList, jRPrintElementIndex);
                JRRenderable jRRenderable = jRPrintImage.getRenderer();
                if (jRRenderable.getType() == 1) {
                    jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), 1 == jRPrintImage.getMode() ? jRPrintImage.getBackcolor() : null);
                }
                fileBufferedOasisZip.addEntry(new FileBufferedOasisZipEntry("Pictures/" + JROdtExporter.getImageName(jRPrintElementIndex), jRRenderable.getImageData()));
            }
        }
        fileBufferedOasisZip.zipEntries(outputStream);
        fileBufferedOasisZip.dispose();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        JRGridLayout jRGridLayout = new JRGridLayout(this.nature, jRPrintPage.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(jRGridLayout, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public void exportGrid(JRGridLayout jRGridLayout, JRPrintElementIndex jRPrintElementIndex) throws IOException, JRException {
        CutsInfo cutsInfo = jRGridLayout.getXCuts();
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        TableBuilder tableBuilder = jRPrintElementIndex == null ? new TableBuilder(this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter) : new TableBuilder(jRPrintElementIndex.toString(), this.tempBodyWriter, this.tempStyleWriter);
        tableBuilder.buildTableStyle();
        tableBuilder.buildTableHeader();
        for (int i2 = 1; i2 < cutsInfo.size(); ++i2) {
            tableBuilder.buildColumnStyle(i2 - 1, cutsInfo.getCut(i2) - cutsInfo.getCut(i2 - 1));
            tableBuilder.buildColumnHeader(i2 - 1);
            tableBuilder.buildColumnFooter();
        }
        JRPrintElement jRPrintElement = null;
        for (int i3 = 0; i3 < jRExporterGridCellArray.length; ++i3) {
            int n2 = 0;
            int n3 = 0;
            int n4 = jRGridLayout.getRowHeight(i3);
            tableBuilder.buildRowStyle(i3, n4);
            tableBuilder.buildRowHeader(i3);
            for (int i4 = 0; i4 < jRExporterGridCellArray[0].length; ++i4) {
                JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray[i3][i4];
                if (jRExporterGridCell == JRExporterGridCell.OCCUPIED_CELL) {
                    if (n2 > 0) {
                        this.writeEmptyCell(jRExporterGridCell, n2, n3, n4);
                        n2 = 0;
                        n3 = 0;
                    }
                    this.writeOccupiedCells(1);
                    continue;
                }
                if (jRExporterGridCell.getWrapper() != null) {
                    if (n2 > 0) {
                        this.writeEmptyCell(jRExporterGridCell, n2, n3, n4);
                        n2 = 0;
                        n3 = 0;
                    }
                    if ((jRPrintElement = jRExporterGridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableBuilder, (JRPrintLine)jRPrintElement, jRExporterGridCell);
                        continue;
                    }
                    if (jRPrintElement instanceof JRPrintRectangle) {
                        this.exportRectangle(tableBuilder, (JRPrintRectangle)jRPrintElement, jRExporterGridCell);
                        continue;
                    }
                    if (jRPrintElement instanceof JRPrintEllipse) {
                        this.exportEllipse(tableBuilder, (JRPrintEllipse)jRPrintElement, jRExporterGridCell);
                        continue;
                    }
                    if (jRPrintElement instanceof JRPrintImage) {
                        this.exportImage(tableBuilder, (JRPrintImage)jRPrintElement, jRExporterGridCell);
                        continue;
                    }
                    if (jRPrintElement instanceof JRPrintText) {
                        this.exportText(tableBuilder, (JRPrintText)jRPrintElement, jRExporterGridCell);
                        continue;
                    }
                    if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                    this.exportFrame(tableBuilder, (JRPrintFrame)jRPrintElement, jRExporterGridCell);
                    continue;
                }
                ++n2;
                n3 += jRExporterGridCell.getWidth();
            }
            if (n2 > 0) {
                this.writeEmptyCell(null, n2, n3, n4);
            }
            tableBuilder.buildRowFooter();
        }
        tableBuilder.buildTableFooter();
    }

    private void writeEmptyCell(JRExporterGridCell jRExporterGridCell, int n2, int n3, int n4) throws IOException {
        this.tempBodyWriter.write("<table:table-cell");
        this.tempBodyWriter.write(" table:style-name=\"empty-cell\"");
        if (n2 > 1) {
            this.tempBodyWriter.write(" table:number-columns-spanned=\"" + n2 + "\"");
        }
        this.tempBodyWriter.write("/>\n");
        this.writeOccupiedCells(n2 - 1);
    }

    private void writeOccupiedCells(int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tempBodyWriter.write("<table:covered-table-cell/>\n");
        }
    }

    public void exportLine(TableBuilder tableBuilder, JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell) throws IOException {
        double d2;
        double d3;
        double d4;
        double d5;
        tableBuilder.buildCellHeader(null, jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        if (jRPrintLine.getDirection() == 1) {
            d5 = Utility.translatePixelsToInches(0.0);
            d4 = Utility.translatePixelsToInches(0.0);
            d3 = Utility.translatePixelsToInches(jRPrintLine.getWidth() - 1);
            d2 = Utility.translatePixelsToInches(jRPrintLine.getHeight() - 1);
        } else {
            d5 = Utility.translatePixelsToInches(0.0);
            d4 = Utility.translatePixelsToInches(jRPrintLine.getHeight() - 1);
            d3 = Utility.translatePixelsToInches(jRPrintLine.getWidth() - 1);
            d2 = Utility.translatePixelsToInches(0.0);
        }
        this.tempBodyWriter.write("<text:p ><draw:line text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(jRPrintLine) + "\" " + "svg:x1=\"" + d5 + "in\" " + "svg:y1=\"" + d4 + "in\" " + "svg:x2=\"" + d3 + "in\" " + "svg:y2=\"" + d2 + "in\">" + "<text:p/></draw:line>" + "</text:p>");
        tableBuilder.buildCellFooter();
    }

    public void exportRectangle(TableBuilder tableBuilder, JRPrintRectangle jRPrintRectangle, JRExporterGridCell jRExporterGridCell) throws IOException {
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(jRPrintRectangle), jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        tableBuilder.buildCellFooter();
    }

    public void exportEllipse(TableBuilder tableBuilder, JRPrintEllipse jRPrintEllipse, JRExporterGridCell jRExporterGridCell) throws IOException {
        tableBuilder.buildCellHeader(null, jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p ><draw:ellipse text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(jRPrintEllipse) + "\" " + "svg:width=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getWidth()) + "in\" " + "svg:height=\"" + Utility.translatePixelsToInches(jRPrintEllipse.getHeight()) + "in\" " + "svg:x=\"0in\" " + "svg:y=\"0in\">" + "<text:p/></draw:ellipse></text:p>");
        tableBuilder.buildCellFooter();
    }

    public void exportText(TableBuilder tableBuilder, JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell) throws IOException {
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(jRPrintText), jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        int n2 = 0;
        if (jRStyledText != null) {
            n2 = jRStyledText.length();
        }
        this.tempBodyWriter.write("<text:p");
        this.tempBodyWriter.write(" text:style-name=\"" + this.styleCache.getParagraphStyle(jRPrintText) + "\"");
        this.tempBodyWriter.write(">");
        if (n2 > 0) {
            this.exportStyledText(jRStyledText);
        }
        this.tempBodyWriter.write("</text:p>\n");
        tableBuilder.buildCellFooter();
    }

    public void exportStyledText(JRStyledText jRStyledText) throws IOException {
        String string = jRStyledText.getText();
        int n2 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n2 < jRStyledText.length() && (n2 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            this.exportStyledTextRun(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n2));
            attributedCharacterIterator.setIndex(n2);
        }
    }

    public void exportStyledTextRun(Map map, String string) throws IOException {
        String string2 = this.styleCache.getTextSpanStyle(map, string);
        this.tempBodyWriter.write("<text:span");
        this.tempBodyWriter.write(" text:style-name=\"" + string2 + "\"");
        this.tempBodyWriter.write(">");
        if (string != null) {
            this.tempBodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(string)));
        }
        this.tempBodyWriter.write("</text:span>");
    }

    public void exportImage(TableBuilder tableBuilder, JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell) throws JRException, IOException {
        int n2 = jRPrintImage.getLineBox().getTopPadding();
        int n3 = jRPrintImage.getLineBox().getLeftPadding();
        int n4 = jRPrintImage.getLineBox().getBottomPadding();
        int n5 = jRPrintImage.getLineBox().getRightPadding();
        int n6 = jRPrintImage.getWidth() - n3 - n5;
        n6 = n6 < 0 ? 0 : n6;
        int n7 = jRPrintImage.getHeight() - n2 - n4;
        n7 = n7 < 0 ? 0 : n7;
        int n8 = n6;
        int n9 = n7;
        int n10 = 0;
        int n11 = 0;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(jRPrintImage), jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && n6 > 0 && n7 > 0) {
            if (jRRenderable.getType() == 0 && !jRPrintImage.isLazy()) {
                jRRenderable = JRImageRenderer.getOnErrorRendererForImageData(jRRenderable, jRPrintImage.getOnErrorType());
            }
        } else {
            jRRenderable = null;
        }
        if (jRRenderable != null) {
            float f2 = this.getXAlignFactor(jRPrintImage);
            float f3 = this.getYAlignFactor(jRPrintImage);
            switch (jRPrintImage.getScaleImage()) {
                case 2: {
                    n8 = n6;
                    n9 = n7;
                    n10 = 0;
                    n11 = 0;
                    break;
                }
                default: {
                    double d2 = n6;
                    double d3 = n7;
                    if (!jRPrintImage.isLazy()) {
                        Dimension2D dimension2D;
                        JRRenderable jRRenderable2 = JRImageRenderer.getOnErrorRendererForDimension(jRRenderable, jRPrintImage.getOnErrorType());
                        Dimension2D dimension2D2 = dimension2D = jRRenderable2 == null ? null : jRRenderable2.getDimension();
                        if (jRRenderable2 == jRRenderable && dimension2D != null) {
                            d2 = dimension2D.getWidth();
                            d3 = dimension2D.getHeight();
                        }
                    }
                    if (n7 > 0) {
                        double d4 = d2 / d3;
                        if (d4 > (double)n6 / (double)n7) {
                            n8 = n6;
                            n9 = (int)((double)n8 / d4);
                        } else {
                            n9 = n7;
                            n8 = (int)(d4 * (double)n9);
                        }
                    }
                    n10 = (int)(f2 * (float)(n6 - n8));
                    n11 = (int)(f3 * (float)(n7 - n9));
                }
            }
            this.tempBodyWriter.write("<text:p ><draw:frame text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(jRPrintImage) + "\" " + "svg:x=\"" + Utility.translatePixelsToInches(n3 + n10) + "in\" " + "svg:y=\"" + Utility.translatePixelsToInches(n2 + n11) + "in\" " + "svg:width=\"" + Utility.translatePixelsToInches(n8) + "in\" " + "svg:height=\"" + Utility.translatePixelsToInches(n9) + "in\">");
            this.tempBodyWriter.write("<draw:image ");
            this.tempBodyWriter.write(" xlink:href=\"" + this.getImagePath(jRRenderable, jRPrintImage.isLazy(), jRExporterGridCell) + "\"");
            this.tempBodyWriter.write(" xlink:type=\"simple\"");
            this.tempBodyWriter.write(" xlink:show=\"embed\"");
            this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
            this.tempBodyWriter.write("/>\n");
            this.tempBodyWriter.write("</draw:frame></text:p>");
        }
        tableBuilder.buildCellFooter();
    }

    public String getImagePath(JRRenderable jRRenderable, boolean bl2, JRExporterGridCell jRExporterGridCell) throws IOException {
        String string = null;
        if (jRRenderable != null) {
            if (jRRenderable.getType() == 0 && this.rendererToImagePathMap.containsKey(jRRenderable.getId())) {
                string = (String)this.rendererToImagePathMap.get(jRRenderable.getId());
            } else {
                if (bl2) {
                    string = ((JRImageRenderer)jRRenderable).getImageLocation();
                } else {
                    JRPrintElementIndex jRPrintElementIndex = this.getElementIndex(jRExporterGridCell);
                    this.imagesToProcess.add(jRPrintElementIndex);
                    String string2 = JROdtExporter.getImageName(jRPrintElementIndex);
                    string = "Pictures/" + string2;
                }
                this.rendererToImagePathMap.put(jRRenderable.getId(), string);
            }
        }
        return string;
    }

    public JRPrintElementIndex getElementIndex(JRExporterGridCell jRExporterGridCell) {
        JRPrintElementIndex jRPrintElementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, jRExporterGridCell.getWrapper().getAddress());
        return jRPrintElementIndex;
    }

    public static String getImageName(JRPrintElementIndex jRPrintElementIndex) {
        return IMAGE_NAME_PREFIX + jRPrintElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String string) {
        if (!string.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + string);
        }
        return JRPrintElementIndex.parsePrintElementIndex(string.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(TableBuilder tableBuilder, JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell) throws IOException, JRException {
        boolean bl2;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(jRPrintFrame), jRExporterGridCell.getColSpan(), jRExporterGridCell.getRowSpan());
        boolean bl3 = bl2 = jRPrintFrame.getMode() == 1 && (this.backcolor == null || jRPrintFrame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (bl2) {
            this.setBackcolor(jRPrintFrame.getBackcolor());
        }
        try {
            JRGridLayout jRGridLayout = jRExporterGridCell.getLayout();
            JRPrintElementIndex jRPrintElementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, jRExporterGridCell.getWrapper().getAddress());
            this.exportGrid(jRGridLayout, jRPrintElementIndex);
        }
        finally {
            if (bl2) {
                this.restoreBackcolor();
            }
        }
        tableBuilder.buildCellFooter();
    }

    public void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    public void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    private float getXAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    private float getYAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }
}

