/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public abstract class BorderStyle
extends Style {
    private static final String[] border = new String[]{"top", "left", "bottom", "right"};
    public static final int TOP_BORDER = 0;
    public static final int LEFT_BORDER = 1;
    public static final int BOTTOM_BORDER = 2;
    public static final int RIGHT_BORDER = 3;
    public JRPrintElement element = null;
    private String[] borderColor = new String[4];
    private String[] borderWidth = new String[4];
    private String[] borderStyle = new String[4];
    private String[] borderPadding = new String[4];

    public BorderStyle(Writer writer, JRPrintElement jRPrintElement) {
        super(writer);
        this.element = jRPrintElement;
    }

    public void setBox(JRLineBox jRLineBox) throws IOException {
        this.appendBorder(jRLineBox.getTopPen(), 0);
        this.borderPadding[0] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(jRLineBox.getTopPadding().intValue()));
        this.appendBorder(jRLineBox.getLeftPen(), 1);
        this.borderPadding[1] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(jRLineBox.getLeftPadding().intValue()));
        this.appendBorder(jRLineBox.getBottomPen(), 2);
        this.borderPadding[2] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(jRLineBox.getBottomPadding().intValue()));
        this.appendBorder(jRLineBox.getRightPen(), 3);
        this.borderPadding[3] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(jRLineBox.getRightPadding().intValue()));
    }

    public void setPen(JRPen jRPen) throws IOException {
        if (this.borderWidth[0] == null && this.borderWidth[1] == null && this.borderWidth[2] == null && this.borderWidth[3] == null) {
            this.appendBorder(jRPen, 0);
            this.appendBorder(jRPen, 1);
            this.appendBorder(jRPen, 2);
            this.appendBorder(jRPen, 3);
        }
    }

    public String getId() {
        return this.borderWidth[0] + "|" + this.borderColor[0] + "|" + this.borderStyle[0] + "|" + this.borderPadding[0] + "|" + this.borderWidth[1] + "|" + this.borderColor[1] + "|" + this.borderStyle[1] + "|" + this.borderPadding[1] + "|" + this.borderWidth[2] + "|" + this.borderColor[2] + "|" + this.borderStyle[2] + "|" + this.borderPadding[2] + "|" + this.borderWidth[3] + "|" + this.borderColor[3] + "|" + this.borderStyle[3] + "|" + this.borderPadding[3];
    }

    public void writeBorder(int n2) throws IOException {
        if (this.borderWidth[n2] != null) {
            this.styleWriter.write(" fo:border-");
            this.styleWriter.write(border[n2]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderWidth[n2]);
            this.styleWriter.write("in ");
            this.styleWriter.write(this.borderStyle[n2]);
            this.styleWriter.write(" #");
            this.styleWriter.write(this.borderColor[n2]);
            this.styleWriter.write("\"");
        }
        if (this.borderPadding[n2] != null) {
            this.styleWriter.write(" fo:padding-");
            this.styleWriter.write(border[n2]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderPadding[n2]);
            this.styleWriter.write("\"");
        }
    }

    private void appendBorder(JRPen jRPen, int n2) throws IOException {
        double d2 = jRPen.getLineWidth().doubleValue();
        String string = null;
        if (d2 > 0.0) {
            switch (jRPen.getLineStyle()) {
                case 1: {
                    string = "dashed";
                    break;
                }
                default: {
                    string = "solid";
                }
            }
            this.borderWidth[n2] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(d2));
        } else {
            string = "none";
        }
        this.borderStyle[n2] = string;
        this.borderColor[n2] = JRColorUtil.getColorHexa(jRPen.getLineColor());
    }
}

