/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;

public class FrameDrawer
extends ElementDrawer {
    private static final int ELEMENT_RECTANGLE_PADDING = 3;
    private ExporterFilter filter = null;
    private Graphics2D grx = null;
    private LinkedList elementOffsetStack = new LinkedList();
    private int elementOffsetX = 0;
    private int elementOffsetY = 0;
    private boolean isClip = false;
    private LineDrawer lineDrawer = null;
    private RectangleDrawer rectangleDrawer = null;
    private EllipseDrawer ellipseDrawer = null;
    private ImageDrawer imageDrawer = null;
    private TextDrawer textDrawer = null;

    public FrameDrawer(ExporterFilter exporterFilter, TextRenderer textRenderer) {
        this.filter = exporterFilter;
        this.lineDrawer = new LineDrawer();
        this.rectangleDrawer = new RectangleDrawer();
        this.ellipseDrawer = new EllipseDrawer();
        this.imageDrawer = new ImageDrawer();
        this.textDrawer = new TextDrawer(textRenderer);
    }

    public void setClip(boolean bl2) {
        this.isClip = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics2D, JRPrintElement jRPrintElement, int n2, int n3) throws JRException {
        this.grx = graphics2D;
        JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
        Shape shape = null;
        if (this.isClip) {
            shape = graphics2D.getClip();
            graphics2D.clip(new Rectangle(jRPrintFrame.getX() + n2, jRPrintFrame.getY() + n3, jRPrintFrame.getWidth(), jRPrintFrame.getHeight()));
        }
        if (jRPrintFrame.getMode() == 1) {
            graphics2D.setColor(jRPrintFrame.getBackcolor());
            graphics2D.fillRect(jRPrintFrame.getX() + n2, jRPrintFrame.getY() + n3, jRPrintFrame.getWidth(), jRPrintFrame.getHeight());
        }
        graphics2D.setColor(jRPrintFrame.getForecolor());
        this.setFrameElementsOffset(jRPrintFrame, n2, n3);
        try {
            this.draw(jRPrintFrame.getElements());
        }
        finally {
            if (this.isClip) {
                graphics2D.setClip(shape);
            }
            this.restoreElementOffsets();
        }
        this.drawBox(graphics2D, jRPrintFrame.getLineBox(), jRPrintFrame, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics2D, Collection collection, int n2, int n3) throws JRException {
        this.grx = graphics2D;
        this.setElementOffsets(n2, n3);
        try {
            this.draw(collection);
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private void draw(Collection collection) throws JRException {
        if (collection != null && collection.size() > 0) {
            Shape shape = this.grx.getClip();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (this.filter != null && !this.filter.isToExport(jRPrintElement) || !shape.intersects(jRPrintElement.getX() + this.getOffsetX() - 3, jRPrintElement.getY() + this.getOffsetY() - 3, jRPrintElement.getWidth() + 6, jRPrintElement.getHeight() + 6)) continue;
                if (jRPrintElement instanceof JRPrintLine) {
                    this.lineDrawer.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.rectangleDrawer.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.ellipseDrawer.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.imageDrawer.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.textDrawer.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.draw(this.grx, jRPrintElement, this.getOffsetX(), this.getOffsetY());
            }
        }
    }

    private void setFrameElementsOffset(JRPrintFrame jRPrintFrame, int n2, int n3) {
        this.setElementOffsets(n2 + jRPrintFrame.getX() + jRPrintFrame.getLineBox().getLeftPadding(), n3 + jRPrintFrame.getY() + jRPrintFrame.getLineBox().getTopPadding());
    }

    private void setElementOffsets(int n2, int n3) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = n2;
        this.elementOffsetY = n3;
    }

    private void restoreElementOffsets() {
        int[] nArray = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = nArray[0];
        this.elementOffsetY = nArray[1];
    }

    private int getOffsetX() {
        return this.elementOffsetX;
    }

    private int getOffsetY() {
        return this.elementOffsetY;
    }
}

