/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextRenderer {
    public static final FontRenderContext LINE_BREAK_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private Graphics2D grx = null;
    private int x = 0;
    private int y = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private float formatWidth = 0.0f;
    private float verticalOffset = 0.0f;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private float drawPosY = 0.0f;
    private float drawPosX = 0.0f;
    private boolean isMaxHeightReached = false;
    private byte horizontalAlignment = 0;
    private int fontSize = 0;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private boolean isMinimizePrinterJobSize = true;

    public static TextRenderer getInstance() {
        return new TextRenderer(JRProperties.getBooleanProperty("net.sf.jasperreports.export.graphics2d.min.job.size"));
    }

    public TextRenderer(boolean bl2) {
        this.isMinimizePrinterJobSize = bl2;
    }

    public void render(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float f2, byte by2, byte by3, float f3, float f4, int n10, boolean bl2, JRStyledText jRStyledText, String string) {
        if (f2 == 0.0f) {
            return;
        }
        this.initialize(graphics2D, n2, n3, n4, n5, n6, n7, n8, n9, f2, by2, by3, f3, f4, n10, bl2);
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        int n11 = 0;
        int n12 = 0;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens() && !this.isMaxHeightReached) {
            String string3 = stringTokenizer.nextToken();
            if ("\n".equals(string3)) {
                this.renderParagraph(attributedCharacterIterator, n12, string2);
                n12 = n11;
                string2 = null;
            } else {
                n12 = n11;
                string2 = string3;
            }
            n11 += string3.length();
        }
        if (!this.isMaxHeightReached && n12 < string.length()) {
            this.renderParagraph(attributedCharacterIterator, n12, string2);
        }
    }

    private void initialize(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float f2, byte by2, byte by3, float f3, float f4, int n10, boolean bl2) {
        this.grx = graphics2D;
        this.horizontalAlignment = by2;
        this.verticalOffset = 0.0f;
        switch (by3) {
            case 1: {
                this.verticalOffset = 0.0f;
                break;
            }
            case 2: {
                this.verticalOffset = ((float)(n5 - n6 - n8) - f2) / 2.0f;
                break;
            }
            case 3: {
                this.verticalOffset = (float)(n5 - n6 - n8) - f2;
                break;
            }
            default: {
                this.verticalOffset = 0.0f;
            }
        }
        this.lineSpacingFactor = f3;
        this.leadingOffset = f4;
        this.x = n2;
        this.y = n3;
        this.topPadding = n6;
        this.leftPadding = n7;
        this.formatWidth = n4 - n7 - n9;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.textHeight = f2;
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
        this.fontSize = n10;
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(bl2);
    }

    private void renderParagraph(AttributedCharacterIterator attributedCharacterIterator, int n2, String string) {
        AttributedCharacterIterator attributedCharacterIterator2 = null;
        attributedCharacterIterator2 = string == null ? new AttributedString(" ", new AttributedString(attributedCharacterIterator, n2, n2 + 1).getIterator().getAttributes()).getIterator() : new AttributedString(attributedCharacterIterator, n2, n2 + string.length()).getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator2, LINE_BREAK_FONT_RENDER_CONTEXT);
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator2.getEndIndex() && !this.isMaxHeightReached) {
            float f2;
            int n3 = lineBreakMeasurer.getPosition();
            TextLayout textLayout = lineBreakMeasurer.nextLayout(this.formatWidth);
            if (this.isMinimizePrinterJobSize) {
                AttributedString attributedString = new AttributedString(attributedCharacterIterator2, n3, n3 + textLayout.getCharacterCount());
                textLayout = new TextLayout(attributedString.getIterator(), this.grx.getFontRenderContext());
            }
            if (this.drawPosY + (f2 = this.lineSpacingFactor * (float)this.maxFontSizeFinder.findMaxFontSize(new AttributedString(attributedCharacterIterator2, n3, n3 + textLayout.getCharacterCount()).getIterator(), this.fontSize)) <= this.textHeight) {
                this.drawPosY += f2;
                switch (this.horizontalAlignment) {
                    case 4: {
                        this.drawPosX = textLayout.isLeftToRight() ? 0.0f : this.formatWidth - textLayout.getAdvance();
                        if (lineBreakMeasurer.getPosition() >= attributedCharacterIterator2.getEndIndex()) break;
                        textLayout = textLayout.getJustifiedLayout(this.formatWidth);
                        break;
                    }
                    case 3: {
                        this.drawPosX = this.formatWidth - textLayout.getAdvance();
                        break;
                    }
                    case 2: {
                        this.drawPosX = (this.formatWidth - textLayout.getAdvance()) / 2.0f;
                        break;
                    }
                    default: {
                        this.drawPosX = 0.0f;
                    }
                }
                this.draw(textLayout);
                continue;
            }
            this.isMaxHeightReached = true;
        }
    }

    public void draw(TextLayout textLayout) {
        textLayout.draw(this.grx, this.drawPosX + (float)this.x + (float)this.leftPadding, this.drawPosY + (float)this.y + (float)this.topPadding + this.verticalOffset + this.leadingOffset);
    }
}

