/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRRtfExporter
extends JRAbstractExporter {
    private static final String RTF_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.rtf.exclude.origin.";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public JRExportProgressMonitor progressMonitor = null;
    public Writer writer = null;
    public File destFile = null;
    public int reportIndex = 0;
    private StringBuffer colorBuffer = null;
    private StringBuffer fontBuffer = null;
    public List colors = null;
    public List fonts = null;
    private int zorder = 1;
    private Map fontMap = null;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block15: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), RTF_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.fonts = new ArrayList();
                this.fontBuffer = new StringBuffer();
                this.colors = new ArrayList();
                this.colors.add(null);
                this.colorBuffer = new StringBuffer(";");
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                StringBuffer stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (stringBuffer != null) {
                    StringBuffer stringBuffer2 = this.exportReportToBuffer();
                    stringBuffer.append(stringBuffer2.toString());
                    break block15;
                }
                Writer writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (writer != null) {
                    try {
                        this.writer = writer;
                        this.exportReportToStream();
                        break block15;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.writer = new OutputStreamWriter(outputStream);
                        this.exportReportToStream();
                        break block15;
                    }
                    catch (Exception exception) {
                        throw new JRException("Error writing to output stream : " + this.jasperPrint.getName(), exception);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        this.destFile = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter");
                    }
                }
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public StringBuffer exportReportToBuffer() throws JRException {
        StringWriter stringWriter = new StringWriter();
        this.writer = stringWriter;
        try {
            this.exportReportToStream();
        }
        catch (IOException iOException) {
            throw new JRException("Error while exporting report to the buffer");
        }
        return stringWriter.getBuffer();
    }

    public void exportReportToStream() throws JRException, IOException {
        this.writer.write("{\\rtf1\\ansi\\deff0\n");
        this.createColorAndFontEntries();
        this.writer.write("{\\fonttbl ");
        this.writer.write(this.fontBuffer.toString());
        this.writer.write("}\n");
        this.writer.write("{\\colortbl ");
        this.writer.write(this.colorBuffer.toString());
        this.writer.write("}\n");
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                JRPrintPage jRPrintPage = null;
                this.writer.write("{\\info{\\nofpages");
                this.writer.write(String.valueOf(list.size()));
                this.writer.write("}}\n");
                this.writer.write("\\viewkind1\\paperw");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageWidth())));
                this.writer.write("\\paperh");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageHeight())));
                this.writer.write("\\marglsxn0\\margrsxn0\\margtsxn0\\margbsxn0");
                if (this.jasperPrint.getOrientation() == 2) {
                    this.writer.write("\\lndscpsxn");
                }
                for (int i2 = this.startPageIndex; i2 <= this.endPageIndex; ++i2) {
                    this.writer.write("\n");
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread intrerrupted");
                    }
                    jRPrintPage = (JRPrintPage)list.get(i2);
                    this.writeAnchor(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (i2 + 1));
                    boolean bl2 = false;
                    if (i2 == this.endPageIndex && this.reportIndex == this.jasperPrintList.size() - 1) {
                        bl2 = true;
                    }
                    this.exportPage(jRPrintPage, bl2);
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("}\n");
        this.writer.flush();
    }

    public void exportReportToFile() throws JRException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            this.writer = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            this.exportReportToStream();
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to the file : " + this.destFile, iOException);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void createColorAndFontEntries() throws JRException {
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.getFontIndex(new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                for (int i2 = this.startPageIndex; i2 <= this.endPageIndex; ++i2) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted");
                    }
                    JRPrintPage jRPrintPage = (JRPrintPage)list.get(i2);
                    JRPrintElement jRPrintElement = null;
                    List list2 = jRPrintPage.getElements();
                    if (list2 == null || list2.size() <= 0) continue;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        jRPrintElement = (JRPrintElement)iterator.next();
                        this.getColorIndex(jRPrintElement.getForecolor());
                        this.getColorIndex(jRPrintElement.getBackcolor());
                        if (!(jRPrintElement instanceof JRPrintText)) continue;
                        JRPrintText jRPrintText = (JRPrintText)jRPrintElement;
                        this.getColorIndex(jRPrintText.getLineBox().getPen().getLineColor());
                        this.getColorIndex(jRPrintText.getLineBox().getTopPen().getLineColor());
                        this.getColorIndex(jRPrintText.getLineBox().getBottomPen().getLineColor());
                        this.getColorIndex(jRPrintText.getLineBox().getLeftPen().getLineColor());
                        this.getColorIndex(jRPrintText.getLineBox().getRightPen().getLineColor());
                        int n2 = 0;
                        JRStyledText jRStyledText = this.getStyledText((JRPrintText)jRPrintElement);
                        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
                        while (n2 < jRStyledText.length() && (n2 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
                            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                            this.getFontIndex(new JRBaseFont(map));
                            this.getColorIndex((Color)map.get(TextAttribute.FOREGROUND));
                            this.getColorIndex((Color)map.get(TextAttribute.BACKGROUND));
                            attributedCharacterIterator.setIndex(n2);
                        }
                        this.getFontIndex((JRPrintText)jRPrintElement);
                    }
                }
            }
            ++this.reportIndex;
        }
    }

    private int getColorIndex(Color color) {
        int n2 = this.colors.indexOf(color);
        if (n2 < 0) {
            n2 = this.colors.size();
            this.colors.add(color);
            this.colorBuffer.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
        }
        return n2;
    }

    private int getFontIndex(JRFont jRFont) {
        int n2;
        String string = jRFont.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(string)) {
            string = (String)this.fontMap.get(string);
        }
        if ((n2 = this.fonts.indexOf(string)) < 0) {
            n2 = this.fonts.size();
            this.fonts.add(string);
            this.fontBuffer.append("{\\f").append(n2).append("\\fnil ").append(string).append(";}");
        }
        return n2;
    }

    private int emu(float f2) {
        return (int)(f2 * 12700.0f);
    }

    private int twip(float f2) {
        return (int)(f2 * 20.0f);
    }

    public void exportPage(JRPrintPage jRPrintPage, boolean bl2) throws JRException, IOException {
        this.exportElements(jRPrintPage.getElements());
        if (!bl2) {
            this.writer.write("\\page\n");
        }
    }

    private void startElement(JRPrintElement jRPrintElement) throws IOException {
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(jRPrintElement.getX() + this.getOffsetX())));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth())));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(jRPrintElement.getY() + this.getOffsetY())));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(jRPrintElement.getY() + this.getOffsetY() + jRPrintElement.getHeight())));
        Color color = jRPrintElement.getBackcolor();
        if (jRPrintElement.getMode() == 1) {
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 1}}");
            this.writer.write("{\\sp{\\sn fillColor}{\\sv ");
            this.writer.write(String.valueOf(this.getColorRGB(color)));
            this.writer.write("}}");
        } else {
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 0}}");
        }
        this.writer.write("{\\shpinst");
    }

    private int getColorRGB(Color color) {
        return color.getRed() + 256 * color.getGreen() + 65536 * color.getBlue();
    }

    private void finishElement() throws IOException {
        this.writer.write("}}\n");
    }

    private void exportPen(JRPen jRPen) throws IOException {
        this.writer.write("{\\sp{\\sn lineColor}{\\sv ");
        this.writer.write(String.valueOf(this.getColorRGB(jRPen.getLineColor())));
        this.writer.write("}}");
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 == 0.0f) {
            this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        }
        if (jRPen.getLineStyle() == 1) {
            this.writer.write("{\\sp{\\sn lineDashing}{\\sv 6}}");
        }
        this.writer.write("{\\sp{\\sn lineWidth}{\\sv ");
        this.writer.write(String.valueOf(this.emu(f2)));
        this.writer.write("}}");
    }

    private void exportPen(Color color) throws IOException {
        this.writer.write("{\\sp{\\sn lineColor}{\\sv ");
        this.writer.write(String.valueOf(this.getColorRGB(color)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.writer.write("{\\sp{\\sn lineWidth}{\\sv 0}}");
    }

    public void exportLine(JRPrintLine jRPrintLine) throws IOException {
        int n2 = jRPrintLine.getX() + this.getOffsetX();
        int n3 = jRPrintLine.getY() + this.getOffsetY();
        int n4 = jRPrintLine.getHeight();
        int n5 = jRPrintLine.getWidth();
        if (n5 <= 1 || n4 <= 1) {
            if (n5 > 1) {
                n4 = 0;
            } else {
                n5 = 0;
            }
        }
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(n2)));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(n2 + n5)));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(n3)));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(n3 + n4)));
        this.writer.write("{\\shpinst");
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(jRPrintLine.getLinePen());
        if (jRPrintLine.getDirection() == 1) {
            this.writer.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
        } else {
            this.writer.write("{\\sp{\\sn fFlipV}{\\sv 1}}");
        }
        this.writer.write("}}\n");
    }

    private void exportBorder(JRPen jRPen, float f2, float f3, float f4, float f5) throws IOException {
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(f2)));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(f2 + f4)));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(f3)));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(f3 + f5)));
        this.writer.write("{\\shpinst");
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(jRPen);
        this.writer.write("}}\n");
    }

    public void exportRectangle(JRPrintRectangle jRPrintRectangle) throws IOException {
        this.startElement(jRPrintRectangle);
        if (jRPrintRectangle.getRadius() == 0) {
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 1}}");
        } else {
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 2}}");
        }
        this.exportPen(jRPrintRectangle.getLinePen());
        this.finishElement();
    }

    public void exportEllipse(JRPrintEllipse jRPrintEllipse) throws IOException {
        this.startElement(jRPrintEllipse);
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 3}}");
        this.exportPen(jRPrintEllipse.getLinePen());
        this.finishElement();
    }

    public void exportText(JRPrintText jRPrintText) throws IOException, JRException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText == null) {
            return;
        }
        int n2 = jRPrintText.getWidth();
        int n3 = jRPrintText.getHeight();
        int n4 = (int)jRPrintText.getTextHeight();
        if (n4 <= 0) {
            if (n3 <= 0) {
                throw new JRException("Invalid text height");
            }
            n4 = n3;
        }
        this.startElement(jRPrintText);
        int n5 = jRPrintText.getLineBox().getTopPadding();
        int n6 = jRPrintText.getLineBox().getLeftPadding();
        int n7 = jRPrintText.getLineBox().getBottomPadding();
        int n8 = jRPrintText.getLineBox().getRightPadding();
        String string = null;
        switch (jRPrintText.getRotation()) {
            case 1: {
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n6 = Math.max(n6, (n2 - n8 - n4) / 2);
                        break;
                    }
                    case 3: {
                        n6 = Math.max(n6, n2 - n8 - n4);
                    }
                }
                string = "{\\sp{\\sn txflTextFlow}{\\sv 2}}";
                break;
            }
            case 2: {
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n8 = Math.max(n8, (n2 - n6 - n4) / 2);
                        break;
                    }
                    case 3: {
                        n8 = Math.max(n8, n2 - n6 - n4);
                    }
                }
                string = "{\\sp{\\sn txflTextFlow}{\\sv 3}}";
                break;
            }
            case 3: {
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        n5 = Math.max(n5, n3 - n7 - n4);
                        break;
                    }
                    case 2: {
                        n5 = Math.max(n5, (n3 - n7 - n4) / 2);
                        break;
                    }
                }
                string = "";
                break;
            }
            default: {
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n5 = Math.max(n5, (n3 - n7 - n4) / 2);
                        break;
                    }
                    case 3: {
                        n5 = Math.max(n5, n3 - n7 - n4);
                    }
                }
                string = "";
            }
        }
        this.writer.write(string);
        this.writer.write("{\\sp{\\sn dyTextTop}{\\sv ");
        this.writer.write(String.valueOf(this.emu(n5)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dxTextLeft}{\\sv ");
        this.writer.write(String.valueOf(this.emu(n6)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dyTextBottom}{\\sv ");
        this.writer.write(String.valueOf(this.emu(n7)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dxTextRight}{\\sv ");
        this.writer.write(String.valueOf(this.emu(n8)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.writer.write("{\\shptxt{\\pard");
        JRPrintText jRPrintText2 = jRPrintText;
        this.writer.write("\\f");
        this.writer.write(String.valueOf(this.getFontIndex(jRPrintText2)));
        this.writer.write("\\cf");
        this.writer.write(String.valueOf(this.getColorIndex(jRPrintText.getForecolor())));
        this.writer.write("\\cb");
        this.writer.write(String.valueOf(this.getColorIndex(jRPrintText.getBackcolor())));
        this.writer.write(" ");
        if (jRPrintText2.isBold()) {
            this.writer.write("\\b");
        }
        if (jRPrintText2.isItalic()) {
            this.writer.write("\\i");
        }
        if (jRPrintText2.isStrikeThrough()) {
            this.writer.write("\\strike");
        }
        if (jRPrintText2.isUnderline()) {
            this.writer.write("\\ul");
        }
        this.writer.write("\\fs");
        this.writer.write(String.valueOf(jRPrintText2.getFontSize() * 2));
        switch (jRPrintText.getHorizontalAlignment()) {
            case 1: {
                this.writer.write("\\ql");
                break;
            }
            case 2: {
                this.writer.write("\\qc");
                break;
            }
            case 3: {
                this.writer.write("\\qr");
                break;
            }
            case 4: {
                this.writer.write("\\qj");
                break;
            }
            default: {
                this.writer.write("\\ql");
            }
        }
        this.writer.write("\\sl");
        this.writer.write(String.valueOf(this.twip(jRPrintText.getLineSpacingFactor() * (float)jRPrintText2.getFontSize())));
        this.writer.write(" ");
        if (jRPrintText.getAnchorName() != null) {
            this.writeAnchor(jRPrintText.getAnchorName());
        }
        this.exportHyperlink(jRPrintText);
        String string2 = jRStyledText.getText();
        int n9 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n9 < jRStyledText.length() && (n9 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            JRBaseFont jRBaseFont = new JRBaseFont(map);
            Color color = (Color)map.get(TextAttribute.FOREGROUND);
            Color color2 = (Color)map.get(TextAttribute.BACKGROUND);
            this.writer.write("\\f");
            this.writer.write(String.valueOf(this.getFontIndex(jRBaseFont)));
            this.writer.write("\\fs");
            this.writer.write(String.valueOf(2 * jRBaseFont.getFontSize()));
            if (jRBaseFont.isBold()) {
                this.writer.write("\\b");
            }
            if (jRBaseFont.isItalic()) {
                this.writer.write("\\i");
            }
            if (jRBaseFont.isUnderline()) {
                this.writer.write("\\ul");
            }
            if (jRBaseFont.isStrikeThrough()) {
                this.writer.write("\\strike");
            }
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(map.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\super");
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(map.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\sub");
            }
            if (null != color2 && !color2.equals(jRPrintText.getBackcolor())) {
                this.writer.write("\\highlight");
                this.writer.write(String.valueOf(this.getColorIndex(color2)));
            }
            this.writer.write("\\cf");
            this.writer.write(String.valueOf(this.getColorIndex(color)));
            if (jRPrintText.getRunDirection() == 1) {
                this.writer.write("\\rtlch");
            }
            this.writer.write(" ");
            this.writer.write(this.handleUnicodeText(string2.substring(attributedCharacterIterator.getIndex(), n9)));
            this.writer.write("\\plain");
            attributedCharacterIterator.setIndex(n9);
        }
        this.writer.write("\\par}}");
        this.finishElement();
        this.exportBox(jRPrintText.getLineBox(), jRPrintText.getX() + this.getOffsetX(), jRPrintText.getY() + this.getOffsetY(), n2, n3);
    }

    private String handleUnicodeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            long l2 = string.charAt(i2);
            if (l2 > 127L) {
                stringBuffer.append("\\u" + l2 + '?');
                continue;
            }
            if (l2 == 10L) {
                stringBuffer.append("\\line ");
                continue;
            }
            if (l2 == 92L || l2 == 123L || l2 == 125L) {
                stringBuffer.append('\\').append((char)l2);
                continue;
            }
            stringBuffer.append((char)l2);
        }
        return stringBuffer.toString();
    }

    public void exportImage(JRPrintImage jRPrintImage) throws JRException, IOException {
        int n2;
        int n3;
        int n4 = jRPrintImage.getLineBox().getLeftPadding();
        int n5 = jRPrintImage.getLineBox().getTopPadding();
        int n6 = jRPrintImage.getLineBox().getRightPadding();
        int n7 = jRPrintImage.getLineBox().getBottomPadding();
        int n8 = jRPrintImage.getWidth() - n4 - n6;
        n8 = n8 < 0 ? 0 : n8;
        int n9 = jRPrintImage.getHeight() - n5 - n7;
        n9 = n9 < 0 ? 0 : n9;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && n8 > 0 && n9 > 0) {
            if (jRRenderable.getType() == 0) {
                jRRenderable = JRImageRenderer.getOnErrorRendererForImageData(jRRenderable, jRPrintImage.getOnErrorType());
            }
        } else {
            jRRenderable = null;
        }
        if (jRRenderable != null) {
            Dimension2D dimension2D;
            if (jRRenderable.getType() == 1) {
                jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), 1 == jRPrintImage.getMode() ? jRPrintImage.getBackcolor() : null);
            }
            n3 = n8;
            n2 = n9;
            JRRenderable jRRenderable2 = JRImageRenderer.getOnErrorRendererForDimension(jRRenderable, jRPrintImage.getOnErrorType());
            Dimension2D dimension2D2 = dimension2D = jRRenderable2 == null ? null : jRRenderable2.getDimension();
            if (jRRenderable2 == jRRenderable && dimension2D != null) {
                n3 = (int)dimension2D.getWidth();
                n2 = (int)dimension2D.getHeight();
            }
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            switch (jRPrintImage.getScaleImage()) {
                case 1: {
                    switch (jRPrintImage.getHorizontalAlignment()) {
                        case 3: {
                            n15 = 65536 * (-n8 + n3) / n8;
                            n17 = 0;
                            break;
                        }
                        case 2: {
                            n17 = n15 = 65536 * (-n8 + n3) / n8 / 2;
                            break;
                        }
                        default: {
                            n15 = 0;
                            n17 = 65536 * (-n8 + n3) / n8;
                        }
                    }
                    switch (jRPrintImage.getVerticalAlignment()) {
                        case 1: {
                            n14 = 0;
                            n16 = 65536 * (-n9 + n2) / n2;
                            break;
                        }
                        case 2: {
                            n16 = n14 = 65536 * (-n9 + n2) / n2 / 2;
                            break;
                        }
                        default: {
                            n14 = 65536 * (-n9 + n2) / n2;
                            n16 = 0;
                        }
                    }
                    n10 = n8;
                    n11 = n9;
                    break;
                }
                case 2: {
                    n3 = n8;
                    n2 = n9;
                    n10 = n8;
                    n11 = n9;
                    break;
                }
                default: {
                    if (jRPrintImage.getHeight() <= 0) break;
                    double d2 = (double)n3 / (double)n2;
                    if (d2 > (double)n8 / (double)n9) {
                        n3 = n8;
                        n2 = (int)((double)n8 / d2);
                    } else {
                        n3 = (int)((double)n9 * d2);
                        n2 = n9;
                    }
                    n12 = (int)(this.getXAlignFactor(jRPrintImage) * (float)(n8 - n3));
                    n13 = (int)(this.getYAlignFactor(jRPrintImage) * (float)(n9 - n2));
                    n10 = n3;
                    n11 = n2;
                }
            }
            this.startElement(jRPrintImage);
            this.exportPen(jRPrintImage.getForecolor());
            this.finishElement();
            this.writer.write("{\\shp{\\*\\shpinst\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
            this.writer.write(String.valueOf(this.zorder++));
            this.writer.write("\\shpleft");
            this.writer.write(String.valueOf(this.twip(jRPrintImage.getX() + n4 + n12 + this.getOffsetX())));
            this.writer.write("\\shpright");
            this.writer.write(String.valueOf(this.twip(jRPrintImage.getX() + n4 + n12 + this.getOffsetX() + n10)));
            this.writer.write("\\shptop");
            this.writer.write(String.valueOf(this.twip(jRPrintImage.getY() + n5 + n13 + this.getOffsetY())));
            this.writer.write("\\shpbottom");
            this.writer.write(String.valueOf(this.twip(jRPrintImage.getY() + n5 + n13 + this.getOffsetY() + n11)));
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 75}}");
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 0}}");
            this.writer.write("{\\sp{\\sn fLockAspectRatio}{\\sv 0}}");
            this.writer.write("{\\sp{\\sn cropFromTop}{\\sv ");
            this.writer.write(String.valueOf(n14));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromLeft}{\\sv ");
            this.writer.write(String.valueOf(n15));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromBottom}{\\sv ");
            this.writer.write(String.valueOf(n16));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromRight}{\\sv ");
            this.writer.write(String.valueOf(n17));
            this.writer.write("}}");
            if (jRPrintImage.getAnchorName() != null) {
                this.writeAnchor(jRPrintImage.getAnchorName());
            }
            this.exportHyperlink(jRPrintImage);
            this.writer.write("{\\sp{\\sn pib}{\\sv {\\pict");
            if (jRRenderable.getImageType() == 2) {
                this.writer.write("\\jpegblip");
            } else {
                this.writer.write("\\pngblip");
            }
            this.writer.write("\n");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jRRenderable.getImageData());
            int n18 = 0;
            int n19 = 0;
            while ((n19 = byteArrayInputStream.read()) != -1) {
                String string = Integer.toHexString(n19);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                this.writer.write(string);
                if (++n18 != 64) continue;
                this.writer.write("\n");
                n18 = 0;
            }
            this.writer.write("\n}}}");
            this.writer.write("}}\n");
        }
        n3 = jRPrintImage.getX() + this.getOffsetX();
        n2 = jRPrintImage.getY() + this.getOffsetY();
        int n20 = jRPrintImage.getWidth();
        int n21 = jRPrintImage.getHeight();
        if (jRPrintImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (jRPrintImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(jRPrintImage.getLinePen(), n3, n2, n20, n21);
            }
        } else {
            this.exportBox(jRPrintImage.getLineBox(), n3, n2, n20, n21);
        }
    }

    public void exportFrame(JRPrintFrame jRPrintFrame) throws JRException, IOException {
        int n2 = jRPrintFrame.getX() + this.getOffsetX();
        int n3 = jRPrintFrame.getY() + this.getOffsetY();
        int n4 = jRPrintFrame.getWidth();
        int n5 = jRPrintFrame.getHeight();
        this.startElement(jRPrintFrame);
        this.exportPen(jRPrintFrame.getForecolor());
        this.finishElement();
        this.setFrameElementsOffset(jRPrintFrame, false);
        this.exportElements(jRPrintFrame.getElements());
        this.restoreElementOffsets();
        this.exportBox(jRPrintFrame.getLineBox(), n2, n3, n4, n5);
    }

    public void exportElements(Collection collection) throws JRException, IOException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (this.filter != null && !this.filter.isToExport(jRPrintElement)) continue;
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    private void exportBox(JRLineBox jRLineBox, int n2, int n3, int n4, int n5) throws IOException {
        this.exportTopPen(jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getRightPen(), n2, n3, n4, n5);
        this.exportLeftPen(jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), n2, n3, n4, n5);
        this.exportBottomPen(jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), n2, n3, n4, n5);
        this.exportRightPen(jRLineBox.getTopPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), n2, n3, n4, n5);
    }

    private void exportPen(JRPen jRPen, int n2, int n3, int n4, int n5) throws IOException {
        this.exportTopPen(jRPen, jRPen, jRPen, n2, n3, n4, n5);
        this.exportLeftPen(jRPen, jRPen, jRPen, n2, n3, n4, n5);
        this.exportBottomPen(jRPen, jRPen, jRPen, n2, n3, n4, n5);
        this.exportRightPen(jRPen, jRPen, jRPen, n2, n3, n4, n5);
    }

    private void exportTopPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, int n2, int n3, int n4, int n5) throws IOException {
        if (jRPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(jRPen, (float)n2 - jRPen2.getLineWidth().floatValue() / 2.0f, n3, (float)n4 + (jRPen2.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportLeftPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, int n2, int n3, int n4, int n5) throws IOException {
        if (jRPen2.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(jRPen2, n2, (float)n3 - jRPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)n5 + (jRPen.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f);
        }
    }

    private void exportBottomPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, int n2, int n3, int n4, int n5) throws IOException {
        if (jRPen2.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(jRPen2, (float)n2 - jRPen.getLineWidth().floatValue() / 2.0f, n3 + n5, (float)n4 + (jRPen.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportRightPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, int n2, int n3, int n4, int n5) throws IOException {
        if (jRPen3.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(jRPen3, n2 + n4, (float)n3 - jRPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)n5 + (jRPen.getLineWidth().floatValue() + jRPen2.getLineWidth().floatValue()) / 2.0f);
        }
    }

    public void exportHyperlink(JRPrintHyperlink jRPrintHyperlink) throws IOException {
        String string;
        String string2;
        String string3;
        block16: {
            JRHyperlinkProducer jRHyperlinkProducer;
            block15: {
                string3 = null;
                string2 = null;
                string = null;
                jRHyperlinkProducer = this.getCustomHandler(jRPrintHyperlink);
                if (jRHyperlinkProducer != null) break block15;
                switch (jRPrintHyperlink.getHyperlinkType()) {
                    case 2: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null) {
                            string2 = string = jRPrintHyperlink.getHyperlinkReference();
                            break;
                        }
                        break block16;
                    }
                    case 3: {
                        if (jRPrintHyperlink.getHyperlinkAnchor() != null) {
                            string2 = string3 = jRPrintHyperlink.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case 4: {
                        if (jRPrintHyperlink.getHyperlinkPage() != null) {
                            string2 = string3 = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + jRPrintHyperlink.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                    case 5: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null && jRPrintHyperlink.getHyperlinkAnchor() != null) {
                            string2 = string = jRPrintHyperlink.getHyperlinkReference() + "#" + jRPrintHyperlink.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case 6: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null && jRPrintHyperlink.getHyperlinkPage() != null) {
                            string2 = string = jRPrintHyperlink.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + jRPrintHyperlink.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            string2 = string = jRHyperlinkProducer.getHyperlink(jRPrintHyperlink);
        }
        if (string2 != null) {
            this.writer.write("{\\sp{\\sn fIsButton}{\\sv 1}}");
            this.writer.write("{\\sp{\\sn pihlShape}{\\sv {\\*\\hl");
            this.writer.write("{\\hlfr ");
            this.writer.write(string2);
            this.writer.write(" }");
            if (string3 != null) {
                this.writer.write("{\\hlloc ");
                this.writer.write(string3);
                this.writer.write(" }");
            }
            if (string != null) {
                this.writer.write("{\\hlsrc ");
                this.writer.write(string);
                this.writer.write(" }");
            }
            this.writer.write("}}}");
        }
    }

    public JRHyperlinkProducer getCustomHandler(JRPrintHyperlink jRPrintHyperlink) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(jRPrintHyperlink.getLinkType());
    }

    public void writeAnchor(String string) throws IOException {
        this.writer.write("{\\*\\bkmkstart ");
        this.writer.write(string);
        this.writer.write("}{\\*\\bkmkend ");
        this.writer.write(string);
        this.writer.write("}");
    }

    private float getXAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    private float getYAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }
}

