/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.PdfFont;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRPdfExporter
extends JRAbstractExporter {
    public static final String PDF_FORCE_SVG_SHAPES = "net.sf.jasperreports.export.pdf.force.svg.shapes";
    private static final String PDF_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.pdf.exclude.origin.";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static boolean fontsRegistered = false;
    public Document document = null;
    public PdfContentByte pdfContentByte = null;
    public PdfWriter pdfWriter = null;
    public Document imageTesterDocument = null;
    public PdfContentByte imageTesterPdfContentByte = null;
    public JRExportProgressMonitor progressMonitor = null;
    public int reportIndex = 0;
    public boolean forceSvgShapes;
    public boolean isCreatingBatchModeBookmarks;
    public boolean isCompressed;
    public boolean isEncrypted;
    public boolean is128BitKey;
    public String userPassword;
    public String ownerPassword;
    public int permissions = 0;
    public Character pdfVersion;
    public String pdfJavaScript;
    public Map loadedImagesMap = null;
    public Image pxImage = null;
    private BookmarkStack bookmarkStack = null;
    private Map fontMap = null;
    private SplitCharacter splitCharacter;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;

    public Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance(JRLoader.loadBytesFromLocation("net/sf/jasperreports/engine/images/pixel.GIF", null));
            }
            catch (Exception exception) {
                throw new JRRuntimeException(exception);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block20: {
            JRPdfExporter.registerFonts();
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                String string;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), PDF_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.isCreatingBatchModeBookmarks = this.getBooleanParameter(JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, "net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", false);
                this.forceSvgShapes = this.getBooleanParameter(JRPdfExporterParameter.FORCE_SVG_SHAPES, PDF_FORCE_SVG_SHAPES, false);
                this.isCompressed = this.getBooleanParameter(JRPdfExporterParameter.IS_COMPRESSED, "net.sf.jasperreports.export.pdf.compressed", false);
                this.isEncrypted = this.getBooleanParameter(JRPdfExporterParameter.IS_ENCRYPTED, "net.sf.jasperreports.export.pdf.encrypted", false);
                this.is128BitKey = this.getBooleanParameter(JRPdfExporterParameter.IS_128_BIT_KEY, "net.sf.jasperreports.export.pdf.128.bit.key", false);
                this.userPassword = this.getStringParameter(JRPdfExporterParameter.USER_PASSWORD, "net.sf.jasperreports.export.pdf.user.password");
                this.ownerPassword = this.getStringParameter(JRPdfExporterParameter.OWNER_PASSWORD, "net.sf.jasperreports.export.pdf.owner.password");
                Integer n2 = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
                if (n2 != null) {
                    this.permissions = n2;
                }
                this.pdfVersion = (string = this.getStringParameter(JRPdfExporterParameter.PDF_VERSION, "net.sf.jasperreports.export.pdf.version")) == null || string.length() == 0 ? null : new Character(string.charAt(0));
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setSplitCharacter();
                this.setHyperlinkProducerFactory();
                this.pdfJavaScript = this.getStringParameter(JRPdfExporterParameter.PDF_JAVASCRIPT, "net.sf.jasperreports.export.pdf.javascript");
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    this.exportReportToStream(outputStream);
                    break block20;
                }
                File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (file == null) {
                    String string2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string2 != null) {
                        file = new File(string2);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToStream(outputStream);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setSplitCharacter() {
        Boolean bl2 = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_LINEBREAK_POLICY);
        boolean bl3 = bl2 == null ? JRProperties.getBooleanProperty(this.jasperPrint.getPropertiesMap(), "net.sf.jasperreports.export.pdf.force.linebreak.policy", false) : bl2;
        if (bl3) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
    }

    public void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public void exportReportToStream(OutputStream outputStream) throws JRException {
        this.document = new Document(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean bl2 = true;
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            this.pdfWriter = PdfWriter.getInstance(this.document, outputStream);
            this.pdfWriter.setCloseStream(false);
            if (this.pdfVersion != null) {
                this.pdfWriter.setPdfVersion(this.pdfVersion.charValue());
            }
            if (this.isCompressed) {
                this.pdfWriter.setFullCompression();
            }
            if (this.isEncrypted) {
                this.pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            if ((string5 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_TITLE)) != null) {
                this.document.addTitle(string5);
            }
            if ((string4 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_AUTHOR)) != null) {
                this.document.addAuthor(string4);
            }
            if ((string3 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_SUBJECT)) != null) {
                this.document.addSubject(string3);
            }
            if ((string2 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_KEYWORDS)) != null) {
                this.document.addKeywords(string2);
            }
            if ((string = (String)this.parameters.get(JRPdfExporterParameter.METADATA_CREATOR)) != null) {
                this.document.addCreator(string);
            } else {
                this.document.addCreator("JasperReports (" + this.jasperPrint.getName() + ")");
            }
            this.document.open();
            if (this.pdfJavaScript != null) {
                this.pdfWriter.addJavaScript(this.pdfJavaScript);
            }
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            this.initBookmarks();
            PdfWriter pdfWriter = PdfWriter.getInstance(this.imageTesterDocument, new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = pdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
                List list = this.jasperPrint.getPages();
                if (list != null && list.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        if (this.isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                        this.startPageIndex = 0;
                        this.endPageIndex = list.size() - 1;
                    }
                    for (int i2 = this.startPageIndex; i2 <= this.endPageIndex; ++i2) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage jRPrintPage = (JRPrintPage)list.get(i2);
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        this.writePageAnchor(i2);
                        this.exportPage(jRPrintPage);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            bl2 = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException documentException) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), documentException);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), iOException);
        }
        finally {
            if (bl2) {
                try {
                    this.document.close();
                }
                catch (Throwable throwable) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void writePageAnchor(int n2) throws DocumentException {
        Object object;
        Chunk chunk;
        Map map = this.getDefaultPdfFontAttributes();
        if (map == null) {
            chunk = new Chunk(" ");
        } else {
            object = this.getFont(map);
            chunk = new Chunk(" ", (com.lowagie.text.Font)object);
        }
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (n2 + 1));
        object = new ColumnText(this.pdfContentByte);
        ((ColumnText)object).setSimpleColumn(new Phrase(chunk), 0.0f, this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
        ((ColumnText)object).go();
    }

    public Map getDefaultPdfFontAttributes() {
        HashMap<JRTextAttribute, Object> hashMap;
        JRStyle jRStyle = this.jasperPrint.getDefaultStyle();
        if (jRStyle != null) {
            hashMap = new HashMap<JRTextAttribute, Object>();
            hashMap.put(JRTextAttribute.PDF_FONT_NAME, jRStyle.getPdfFontName());
            hashMap.put(JRTextAttribute.PDF_ENCODING, jRStyle.getPdfEncoding());
            hashMap.put(JRTextAttribute.IS_PDF_EMBEDDED, jRStyle.isPdfEmbedded());
        } else {
            JRReportFont jRReportFont = this.jasperPrint.getDefaultFont();
            if (jRReportFont != null) {
                hashMap = new HashMap();
                hashMap.put(JRTextAttribute.PDF_FONT_NAME, jRReportFont.getPdfFontName());
                hashMap.put(JRTextAttribute.PDF_ENCODING, jRReportFont.getPdfEncoding());
                hashMap.put(JRTextAttribute.IS_PDF_EMBEDDED, jRReportFont.isPdfEmbedded() ? Boolean.TRUE : Boolean.FALSE);
            } else {
                hashMap = null;
            }
        }
        return hashMap;
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException, DocumentException, IOException {
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public void exportElements(Collection collection) throws DocumentException, IOException, JRException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (this.filter != null && !this.filter.isToExport(jRPrintElement)) continue;
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    public void exportLine(JRPrintLine jRPrintLine) {
        float f2 = jRPrintLine.getLinePen().getLineWidth().floatValue();
        if (f2 > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, jRPrintLine.getLinePen());
            this.pdfContentByte.setLineCap(0);
            if (jRPrintLine.getWidth() == 1) {
                if (jRPrintLine.getHeight() != 1) {
                    this.pdfContentByte.moveTo((float)(jRPrintLine.getX() + this.getOffsetX()) + 0.5f, this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY());
                    this.pdfContentByte.lineTo((float)(jRPrintLine.getX() + this.getOffsetX()) + 0.5f, this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY() - jRPrintLine.getHeight());
                }
            } else if (jRPrintLine.getHeight() == 1) {
                this.pdfContentByte.moveTo(jRPrintLine.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY()) - 0.5f);
                this.pdfContentByte.lineTo(jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth(), (float)(this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY()) - 0.5f);
            } else if (jRPrintLine.getDirection() == 1) {
                this.pdfContentByte.moveTo(jRPrintLine.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY());
                this.pdfContentByte.lineTo(jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY() - jRPrintLine.getHeight());
            } else {
                this.pdfContentByte.moveTo(jRPrintLine.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY() - jRPrintLine.getHeight());
                this.pdfContentByte.lineTo(jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY());
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.setLineCap(2);
        }
    }

    public void exportRectangle(JRPrintRectangle jRPrintRectangle) {
        this.pdfContentByte.setRGBColorFill(jRPrintRectangle.getBackcolor().getRed(), jRPrintRectangle.getBackcolor().getGreen(), jRPrintRectangle.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, jRPrintRectangle.getLinePen());
        this.pdfContentByte.roundRectangle(jRPrintRectangle.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintRectangle.getY() - this.getOffsetY() - jRPrintRectangle.getHeight(), jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight(), jRPrintRectangle.getRadius());
        if (jRPrintRectangle.getMode() == 1) {
            if (jRPrintRectangle.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.pdfContentByte.fillStroke();
            } else {
                this.pdfContentByte.fill();
            }
        } else if (jRPrintRectangle.getLinePen().getLineWidth().floatValue() > 0.0f) {
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    public void exportEllipse(JRPrintEllipse jRPrintEllipse) {
        this.pdfContentByte.setRGBColorFill(jRPrintEllipse.getBackcolor().getRed(), jRPrintEllipse.getBackcolor().getGreen(), jRPrintEllipse.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, jRPrintEllipse.getLinePen());
        this.pdfContentByte.ellipse(jRPrintEllipse.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY() - jRPrintEllipse.getHeight(), jRPrintEllipse.getX() + this.getOffsetX() + jRPrintEllipse.getWidth(), this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY());
        if (jRPrintEllipse.getMode() == 1) {
            if (jRPrintEllipse.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.pdfContentByte.fillStroke();
            } else {
                this.pdfContentByte.fill();
            }
        } else if (jRPrintEllipse.getLinePen().getLineWidth().floatValue() > 0.0f) {
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage jRPrintImage) throws DocumentException, IOException, JRException {
        if (jRPrintImage.getMode() == 1) {
            this.pdfContentByte.setRGBColorFill(jRPrintImage.getBackcolor().getRed(), jRPrintImage.getBackcolor().getGreen(), jRPrintImage.getBackcolor().getBlue());
            this.pdfContentByte.rectangle(jRPrintImage.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintImage.getY() - this.getOffsetY(), jRPrintImage.getWidth(), -jRPrintImage.getHeight());
            this.pdfContentByte.fill();
        }
        int n2 = jRPrintImage.getLineBox().getTopPadding();
        int n3 = jRPrintImage.getLineBox().getLeftPadding();
        int n4 = jRPrintImage.getLineBox().getBottomPadding();
        int n5 = jRPrintImage.getLineBox().getRightPadding();
        int n6 = jRPrintImage.getWidth() - n3 - n5;
        n6 = n6 < 0 ? 0 : n6;
        int n7 = jRPrintImage.getHeight() - n2 - n4;
        n7 = n7 < 0 ? 0 : n7;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && n6 > 0 && n7 > 0) {
            if (jRRenderable.getType() == 0) {
                jRRenderable = JRImageRenderer.getOnErrorRendererForImageData(jRRenderable, jRPrintImage.getOnErrorType());
            }
        } else {
            jRRenderable = null;
        }
        if (jRRenderable != null) {
            int n8 = 0;
            int n9 = 0;
            Chunk chunk = null;
            float f2 = n6;
            float f3 = n7;
            if (jRRenderable.getType() == 0) {
                Image image = null;
                float f4 = this.getXAlignFactor(jRPrintImage);
                float f5 = this.getYAlignFactor(jRPrintImage);
                switch (jRPrintImage.getScaleImage()) {
                    case 1: {
                        jRRenderable = JRImageRenderer.getOnErrorRendererForDimension(jRRenderable, jRPrintImage.getOnErrorType());
                        if (jRRenderable == null) break;
                        int n10 = n6;
                        int n11 = n7;
                        Dimension2D dimension2D = jRRenderable.getDimension();
                        if (dimension2D != null) {
                            n10 = (int)dimension2D.getWidth();
                            n11 = (int)dimension2D.getHeight();
                        }
                        n8 = (int)(f4 * (float)(n6 - n10));
                        n9 = (int)(f5 * (float)(n7 - n11));
                        int n12 = Math.min(n10, n6);
                        int n13 = Math.min(n11, n7);
                        BufferedImage bufferedImage = new BufferedImage(n12, n13, 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        if (jRPrintImage.getMode() == 1) {
                            graphics2D.setColor(jRPrintImage.getBackcolor());
                            graphics2D.fillRect(0, 0, n12, n13);
                        }
                        jRRenderable.render(graphics2D, new java.awt.Rectangle(n8 > 0 ? 0 : n8, n9 > 0 ? 0 : n9, n10, n11));
                        graphics2D.dispose();
                        n8 = n8 < 0 ? 0 : n8;
                        n9 = n9 < 0 ? 0 : n9;
                        image = Image.getInstance(bufferedImage, null);
                        break;
                    }
                    case 2: {
                        if (jRPrintImage.isUsingCache() && this.loadedImagesMap.containsKey(jRRenderable)) {
                            image = (Image)this.loadedImagesMap.get(jRRenderable);
                        } else {
                            try {
                                image = Image.getInstance(jRRenderable.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception exception) {
                                JRImageRenderer jRImageRenderer = JRImageRenderer.getOnErrorRendererForImage(JRImageRenderer.getInstance(jRRenderable.getImageData()), jRPrintImage.getOnErrorType());
                                if (jRImageRenderer == null) break;
                                java.awt.Image image2 = jRImageRenderer.getImage();
                                image = Image.getInstance(image2, null);
                            }
                            if (jRPrintImage.isUsingCache()) {
                                this.loadedImagesMap.put(jRRenderable, image);
                            }
                        }
                        image.scaleAbsolute(n6, n7);
                        break;
                    }
                    default: {
                        if (jRPrintImage.isUsingCache() && this.loadedImagesMap.containsKey(jRRenderable)) {
                            image = (Image)this.loadedImagesMap.get(jRRenderable);
                        } else {
                            try {
                                image = Image.getInstance(jRRenderable.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception exception) {
                                JRImageRenderer jRImageRenderer = JRImageRenderer.getOnErrorRendererForImage(JRImageRenderer.getInstance(jRRenderable.getImageData()), jRPrintImage.getOnErrorType());
                                if (jRImageRenderer == null) break;
                                java.awt.Image image3 = jRImageRenderer.getImage();
                                image = Image.getInstance(image3, null);
                            }
                            if (jRPrintImage.isUsingCache()) {
                                this.loadedImagesMap.put(jRRenderable, image);
                            }
                        }
                        image.scaleToFit(n6, n7);
                        n8 = (int)(f4 * ((float)n6 - image.plainWidth()));
                        n9 = (int)(f5 * ((float)n7 - image.plainHeight()));
                        n8 = n8 < 0 ? 0 : n8;
                        int n14 = n9 = n9 < 0 ? 0 : n9;
                    }
                }
                if (image != null) {
                    chunk = new Chunk(image, 0.0f, 0.0f);
                    f2 = image.scaledWidth();
                    f3 = image.scaledHeight();
                }
            } else {
                Graphics2D graphics2D;
                double d2 = n6;
                double d3 = n7;
                double d4 = n6;
                double d5 = n7;
                double d6 = 1.0;
                double d7 = 1.0;
                Rectangle2D.Double double_ = null;
                Dimension2D dimension2D = jRRenderable.getDimension();
                if (dimension2D != null) {
                    d2 = dimension2D.getWidth();
                    d3 = dimension2D.getHeight();
                    d4 = d2;
                    d5 = d3;
                    float f6 = this.getXAlignFactor(jRPrintImage);
                    float f7 = this.getYAlignFactor(jRPrintImage);
                    switch (jRPrintImage.getScaleImage()) {
                        case 1: {
                            n8 = (int)((double)f6 * ((double)n6 - d2));
                            n9 = (int)((double)f7 * ((double)n7 - d3));
                            double_ = new Rectangle2D.Double(-n8, -n9, n6, n7);
                            break;
                        }
                        case 2: {
                            d6 = (double)n6 / d2;
                            d7 = (double)n7 / d3;
                            d2 *= d6;
                            d3 *= d7;
                            n8 = 0;
                            n9 = 0;
                            break;
                        }
                        default: {
                            d6 = (double)n6 / d2;
                            d7 = (double)n7 / d3;
                            d7 = d6 = d6 < d7 ? d6 : d7;
                            n8 = (int)((double)f6 * ((double)n6 - (d2 *= d6)));
                            n9 = (int)((double)f7 * ((double)n7 - (d3 *= d7)));
                        }
                    }
                }
                PdfTemplate pdfTemplate = this.pdfContentByte.createTemplate((float)d4, (float)d5);
                Graphics2D graphics2D2 = graphics2D = this.forceSvgShapes ? pdfTemplate.createGraphicsShapes((float)d4, (float)d5) : pdfTemplate.createGraphics(n6, n7, new LocalFontMapper(this));
                if (double_ != null) {
                    graphics2D.setClip(double_);
                }
                if (jRPrintImage.getMode() == 1) {
                    graphics2D.setColor(jRPrintImage.getBackcolor());
                    graphics2D.fillRect(0, 0, (int)d4, (int)d5);
                }
                Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d4, d5);
                jRRenderable.render(graphics2D, double_2);
                graphics2D.dispose();
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(pdfTemplate, (float)d6, 0.0f, 0.0f, (float)d7, jRPrintImage.getX() + this.getOffsetX() + n8, this.jasperPrint.getPageHeight() - jRPrintImage.getY() - this.getOffsetY() - (int)d3 - n9);
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute(n6, n7);
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
            if (chunk != null) {
                this.setAnchor(chunk, jRPrintImage, jRPrintImage);
                this.setHyperlinkInfo(chunk, jRPrintImage);
                ColumnText columnText = new ColumnText(this.pdfContentByte);
                int n15 = this.jasperPrint.getPageHeight() - jRPrintImage.getY() - n2 - this.getOffsetY() - n9;
                int n16 = jRPrintImage.getX() + n3 + this.getOffsetX() + n8;
                columnText.setSimpleColumn(new Phrase(chunk), n16, (float)n15 - f3, (float)n16 + f2, n15, f3, 0);
                columnText.go();
            }
        }
        if (jRPrintImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && jRPrintImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (jRPrintImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(jRPrintImage.getLinePen(), jRPrintImage);
            }
        } else {
            this.exportBox(jRPrintImage.getLineBox(), jRPrintImage);
        }
    }

    private float getXAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    private float getYAlignFactor(JRPrintImage jRPrintImage) {
        float f2 = 0.0f;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                f2 = 1.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    public void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink jRPrintHyperlink) {
        block0 : switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                if (jRPrintHyperlink.getHyperlinkReference() == null) break;
                switch (jRPrintHyperlink.getHyperlinkTarget()) {
                    case 2: {
                        chunk.setAction(PdfAction.javaScript("if (app.viewerVersion < 7){this.getURL(\"" + jRPrintHyperlink.getHyperlinkReference() + "\");}" + "else {app.launchURL(\"" + jRPrintHyperlink.getHyperlinkReference() + "\", true);};", this.pdfWriter));
                        break block0;
                    }
                }
                chunk.setAnchor(jRPrintHyperlink.getHyperlinkReference());
                break;
            }
            case 3: {
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(jRPrintHyperlink.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + jRPrintHyperlink.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (jRPrintHyperlink.getHyperlinkReference() == null || jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(jRPrintHyperlink.getHyperlinkReference(), jRPrintHyperlink.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (jRPrintHyperlink.getHyperlinkReference() == null || jRPrintHyperlink.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(jRPrintHyperlink.getHyperlinkReference(), jRPrintHyperlink.getHyperlinkPage());
                break;
            }
            case 7: {
                String string;
                if (this.hyperlinkProducerFactory == null || (string = this.hyperlinkProducerFactory.produceHyperlink(jRPrintHyperlink)) == null) break;
                chunk.setAnchor(string);
            }
        }
    }

    public Phrase getPhrase(JRStyledText jRStyledText, JRPrintText jRPrintText) {
        Phrase phrase = new Phrase();
        String string = jRStyledText.getText();
        int n2 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n2 < jRStyledText.length() && (n2 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            Chunk chunk = this.getChunk(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n2));
            this.setAnchor(chunk, jRPrintText, jRPrintText);
            this.setHyperlinkInfo(chunk, jRPrintText);
            phrase.add(chunk);
            attributedCharacterIterator.setIndex(n2);
        }
        return phrase;
    }

    public Chunk getChunk(Map map, String string) {
        Object v2;
        com.lowagie.text.Font font = this.getFont(map);
        Chunk chunk = new Chunk(string, font);
        Color color = (Color)map.get(TextAttribute.BACKGROUND);
        if (color != null) {
            chunk.setBackground(color);
        }
        if ((v2 = map.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(v2)) {
                chunk.setTextRise(font.leading(1.0f) / 2.0f);
            } else if (v2 != null && TextAttribute.SUPERSCRIPT_SUB.equals(v2)) {
                chunk.setTextRise(-font.leading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    public com.lowagie.text.Font getFont(Map map) {
        JRBaseFont jRBaseFont = new JRBaseFont(map);
        Exception exception = null;
        Color color = (Color)map.get(TextAttribute.FOREGROUND);
        com.lowagie.text.Font font = null;
        PdfFont pdfFont = null;
        FontKey fontKey = new FontKey(jRBaseFont.getFontName(), jRBaseFont.isBold(), jRBaseFont.isItalic());
        pdfFont = this.fontMap != null && this.fontMap.containsKey(fontKey) ? (PdfFont)this.fontMap.get(fontKey) : new PdfFont(jRBaseFont.getPdfFontName(), jRBaseFont.getPdfEncoding(), jRBaseFont.isPdfEmbedded());
        try {
            font = FontFactory.getFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), jRBaseFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jRBaseFont.isUnderline() ? 4 : 0) | (jRBaseFont.isStrikeThrough() ? 8 : 0), color);
            if (font.getBaseFont() == null && font.family() == -1) {
                font = null;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (font == null) {
            byte[] byArray = null;
            try {
                byArray = JRLoader.loadBytesFromLocation(pdfFont.getPdfFontName(), this.classLoader, this.urlHandlerFactory);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Could not load the following font : \npdfFontName   : " + pdfFont.getPdfFontName() + "\npdfEncoding   : " + pdfFont.getPdfEncoding() + "\nisPdfEmbedded : " + pdfFont.isPdfEmbedded(), exception);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), true, byArray, null);
            }
            catch (DocumentException documentException) {
                throw new JRRuntimeException(documentException);
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
            font = new com.lowagie.text.Font(baseFont, (float)jRBaseFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jRBaseFont.isUnderline() ? 4 : 0) | (jRBaseFont.isStrikeThrough() ? 8 : 0), color);
        }
        return font;
    }

    public void exportText(JRPrintText jRPrintText) throws DocumentException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText, false);
        if (jRStyledText == null) {
            return;
        }
        int n2 = jRStyledText.length();
        int n3 = jRPrintText.getX() + this.getOffsetX();
        int n4 = jRPrintText.getY() + this.getOffsetY();
        int n5 = jRPrintText.getWidth();
        int n6 = jRPrintText.getHeight();
        int n7 = jRPrintText.getLineBox().getTopPadding();
        int n8 = jRPrintText.getLineBox().getLeftPadding();
        int n9 = jRPrintText.getLineBox().getBottomPadding();
        int n10 = jRPrintText.getLineBox().getRightPadding();
        int n11 = 0;
        int n12 = 0;
        double d2 = 0.0;
        switch (jRPrintText.getRotation()) {
            case 1: {
                n4 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                n11 = 1;
                n5 = jRPrintText.getHeight();
                n6 = jRPrintText.getWidth();
                int n13 = n7;
                n7 = n8;
                n8 = n9;
                n9 = n10;
                n10 = n13;
                d2 = 1.5707963267948966;
                break;
            }
            case 2: {
                n3 = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n12 = -1;
                n5 = jRPrintText.getHeight();
                n6 = jRPrintText.getWidth();
                int n13 = n7;
                n7 = n10;
                n10 = n9;
                n9 = n8;
                n8 = n13;
                d2 = -1.5707963267948966;
                break;
            }
            case 3: {
                n3 = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n4 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                int n13 = n7;
                n7 = n9;
                n9 = n13;
                n13 = n8;
                n8 = n10;
                n10 = n13;
                d2 = Math.PI;
                break;
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2, n3, this.jasperPrint.getPageHeight() - n4);
        this.pdfContentByte.transform(affineTransform);
        if (jRPrintText.getMode() == 1) {
            Color color = jRPrintText.getBackcolor();
            this.pdfContentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.rectangle(n3 + n11, this.jasperPrint.getPageHeight() - n4 + n12, n5, -n6);
            this.pdfContentByte.fill();
        }
        if (n2 > 0) {
            int n14 = 0;
            switch (jRPrintText.getHorizontalAlignment()) {
                case 1: {
                    if (jRPrintText.getRunDirection() == 0) {
                        n14 = 0;
                        break;
                    }
                    n14 = 2;
                    break;
                }
                case 2: {
                    n14 = 1;
                    break;
                }
                case 3: {
                    if (jRPrintText.getRunDirection() == 0) {
                        n14 = 2;
                        break;
                    }
                    n14 = 0;
                    break;
                }
                case 4: {
                    n14 = 3;
                    break;
                }
                default: {
                    n14 = 0;
                }
            }
            float f2 = 0.0f;
            switch (jRPrintText.getVerticalAlignment()) {
                case 1: {
                    f2 = 0.0f;
                    break;
                }
                case 2: {
                    f2 = ((float)(n6 - n7 - n9) - jRPrintText.getTextHeight()) / 2.0f;
                    break;
                }
                case 3: {
                    f2 = (float)(n6 - n7 - n9) - jRPrintText.getTextHeight();
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            ColumnText columnText = new ColumnText(this.pdfContentByte);
            columnText.setSimpleColumn(this.getPhrase(jRStyledText, jRPrintText), n3 + n8, (float)(this.jasperPrint.getPageHeight() - n4 - n7) - f2 - jRPrintText.getLeadingOffset(), n3 + n5 - n10, this.jasperPrint.getPageHeight() - n4 - n6 + n9, 0.0f, n14);
            columnText.setLeading(0.0f, jRPrintText.getLineSpacingFactor());
            columnText.setRunDirection(jRPrintText.getRunDirection() == 0 ? 2 : 3);
            columnText.go();
        }
        affineTransform = new AffineTransform();
        affineTransform.rotate(-d2, n3, this.jasperPrint.getPageHeight() - n4);
        this.pdfContentByte.transform(affineTransform);
        this.exportBox(jRPrintText.getLineBox(), jRPrintText);
    }

    public void exportBox(JRLineBox jRLineBox, JRPrintElement jRPrintElement) {
        this.pdfContentByte.setLineCap(0);
        this.exportTopPen(jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getRightPen(), jRPrintElement);
        this.exportLeftPen(jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), jRPrintElement);
        this.exportBottomPen(jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), jRPrintElement);
        this.exportRightPen(jRLineBox.getTopPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), jRPrintElement);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    public void exportPen(JRPen jRPen, JRPrintElement jRPrintElement) {
        this.pdfContentByte.setLineCap(0);
        this.exportTopPen(jRPen, jRPen, jRPen, jRPrintElement);
        this.exportLeftPen(jRPen, jRPen, jRPen, jRPrintElement);
        this.exportBottomPen(jRPen, jRPen, jRPen, jRPrintElement);
        this.exportRightPen(jRPen, jRPen, jRPen, jRPrintElement);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    public void exportTopPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement) {
        if (jRPen.getLineWidth().floatValue() > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, jRPen);
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX()) - jRPen2.getLineWidth().floatValue() / 2.0f, this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY());
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth()) + jRPen3.getLineWidth().floatValue() / 2.0f, this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY());
            this.pdfContentByte.stroke();
        }
    }

    public void exportLeftPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement) {
        if (jRPen2.getLineWidth().floatValue() > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, jRPen2);
            this.pdfContentByte.moveTo(jRPrintElement.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + jRPen.getLineWidth().floatValue() / 2.0f);
            this.pdfContentByte.lineTo(jRPrintElement.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight()) - jRPen3.getLineWidth().floatValue() / 2.0f);
            this.pdfContentByte.stroke();
        }
    }

    public void exportBottomPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement) {
        if (jRPen2.getLineWidth().floatValue() > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, jRPen2);
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX()) - jRPen.getLineWidth().floatValue() / 2.0f, this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight());
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth()) + jRPen3.getLineWidth().floatValue() / 2.0f, this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight());
            this.pdfContentByte.stroke();
        }
    }

    public void exportRightPen(JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement) {
        if (jRPen3.getLineWidth().floatValue() > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, jRPen3);
            this.pdfContentByte.moveTo(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + jRPen.getLineWidth().floatValue() / 2.0f);
            this.pdfContentByte.lineTo(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight()) - jRPen2.getLineWidth().floatValue() / 2.0f);
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    private static void preparePen(PdfContentByte pdfContentByte, JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        pdfContentByte.setLineWidth(f2);
        Color color = jRPen.getLineColor();
        pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        switch (jRPen.getLineStyle()) {
            case 1: {
                pdfContentByte.setLineDash(5.0f * f2, 3.0f * f2, 0.0f);
                break;
            }
            default: {
                pdfContentByte.setLineDash(0.0f);
            }
        }
    }

    public static synchronized void registerFonts() {
        if (!fontsRegistered) {
            Object object;
            Object object2;
            Object object3;
            List list = JRProperties.getProperties("net.sf.jasperreports.export.pdf.font.");
            if (!list.isEmpty()) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (JRProperties.PropertySuffix)object3.next();
                    object = ((JRProperties.PropertySuffix)object2).getValue();
                    if (((String)object).toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)object);
                        continue;
                    }
                    String string = ((JRProperties.PropertySuffix)object2).getSuffix();
                    FontFactory.register((String)object, string);
                }
            }
            if (!(object3 = JRProperties.getProperties("net.sf.jasperreports.export.pdf.fontdir.")).isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (JRProperties.PropertySuffix)object2.next();
                    FontFactory.registerDirectory(((JRProperties.PropertySuffix)object).getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    public void initBookmarks() {
        this.bookmarkStack = new BookmarkStack();
        int n2 = this.isModeBatch && this.isCreatingBatchModeBookmarks ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), n2);
        this.bookmarkStack.a(bookmark);
    }

    public void addBookmark(int n2, String string, int n3, int n4) {
        Bookmark bookmark = this.bookmarkStack.a();
        while (bookmark.a > n2 - 1) {
            this.bookmarkStack.b();
            bookmark = this.bookmarkStack.a();
        }
        for (int i2 = bookmark.a + 1; i2 < n2; ++i2) {
            Bookmark bookmark2 = new Bookmark(bookmark, bookmark.b.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
            this.bookmarkStack.a(bookmark2);
            bookmark = bookmark2;
        }
        Bookmark bookmark3 = new Bookmark(bookmark, n3, this.jasperPrint.getPageHeight() - n4, string);
        this.bookmarkStack.a(bookmark3);
    }

    public void setAnchor(Chunk chunk, JRPrintAnchor jRPrintAnchor, JRPrintElement jRPrintElement) {
        String string = jRPrintAnchor.getAnchorName();
        if (string != null) {
            chunk.setLocalDestination(string);
            if (jRPrintAnchor.getBookmarkLevel() != 0) {
                this.addBookmark(jRPrintAnchor.getBookmarkLevel(), jRPrintAnchor.getAnchorName(), jRPrintElement.getX(), jRPrintElement.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame jRPrintFrame) throws DocumentException, IOException, JRException {
        if (jRPrintFrame.getMode() == 1) {
            int n2 = jRPrintFrame.getX() + this.getOffsetX();
            int n3 = jRPrintFrame.getY() + this.getOffsetY();
            Color color = jRPrintFrame.getBackcolor();
            this.pdfContentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.rectangle(n2, this.jasperPrint.getPageHeight() - n3, jRPrintFrame.getWidth(), -jRPrintFrame.getHeight());
            this.pdfContentByte.fill();
        }
        this.setFrameElementsOffset(jRPrintFrame, false);
        try {
            this.exportElements(jRPrintFrame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(jRPrintFrame.getLineBox(), jRPrintFrame);
    }

    public class LocalFontMapper
    implements FontMapper {
        private final JRPdfExporter this$0;

        public LocalFontMapper(JRPdfExporter jRPdfExporter) {
            this.this$0 = jRPdfExporter;
        }

        public BaseFont awtToPdf(Font font) {
            return this.this$0.getFont(font.getAttributes()).getBaseFont();
        }

        public Font pdfToAwt(BaseFont baseFont, int n2) {
            return null;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        public void write(int n2) {
        }

        public void write(byte[] byArray, int n2, int n3) {
        }

        public void write(byte[] byArray) {
        }
    }

    protected static class BookmarkStack {
        public LinkedList a = new LinkedList();

        public void a(Bookmark bookmark) {
            this.a.add(bookmark);
        }

        public Bookmark b() {
            return (Bookmark)this.a.removeLast();
        }

        public Bookmark a() {
            return (Bookmark)this.a.getLast();
        }
    }

    protected static class Bookmark {
        public final PdfOutline b;
        public final int a;

        public Bookmark(Bookmark bookmark, int n2, int n3, String string) {
            this(bookmark, new PdfDestination(0, n2, n3, 0.0f), string);
        }

        public Bookmark(Bookmark bookmark, PdfDestination pdfDestination, String string) {
            this.b = new PdfOutline(bookmark.b, pdfDestination, string, false);
            this.a = bookmark.a + 1;
        }

        public Bookmark(PdfOutline pdfOutline, int n2) {
            this.b = pdfOutline;
            this.a = n2;
        }
    }
}

