/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementWrapper;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.util.JRBoxUtil;

public class JRGridLayout {
    private final ExporterNature nature;
    private final int width;
    private final int height;
    private final int offsetX;
    private final int offsetY;
    private final String address;
    private CutsInfo xCuts;
    private CutsInfo yCuts;
    private JRExporterGridCell[][] grid;
    private Map boxesCache;
    private int virtualFrameIndex = 0;

    public JRGridLayout(ExporterNature exporterNature, List list, int n2, int n3, int n4, int n5) {
        this(exporterNature, list, n2, n3, n4, n5, null);
    }

    public JRGridLayout(ExporterNature exporterNature, List list, int n2, int n3, int n4, int n5, CutsInfo cutsInfo) {
        this.nature = exporterNature;
        this.height = n3;
        this.width = n2;
        this.offsetX = n4;
        this.offsetY = n5;
        this.address = null;
        this.xCuts = cutsInfo;
        this.boxesCache = new HashMap();
        this.virtualFrameIndex = list.size();
        this.layoutGrid(JRGridLayout.createWrappers(list, this.address));
        if (exporterNature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    public JRGridLayout(ExporterNature exporterNature, ElementWrapper[] elementWrapperArray, int n2, int n3, int n4, int n5, String string) {
        this.nature = exporterNature;
        this.height = n3;
        this.width = n2;
        this.offsetX = n4;
        this.offsetY = n5;
        this.address = string;
        this.boxesCache = new HashMap();
        this.layoutGrid(elementWrapperArray);
        if (exporterNature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    private void createNestedGrid(int n2, int n3, int n4, int n5) {
        JRBasePrintFrame jRBasePrintFrame = new JRBasePrintFrame(null);
        ArrayList<ElementWrapper> arrayList = new ArrayList<ElementWrapper>();
        for (int i2 = n2; i2 < n4; ++i2) {
            for (int i3 = n3; i3 < n5; ++i3) {
                JRExporterGridCell jRExporterGridCell = this.grid[i2][i3];
                this.grid[i2][i3] = JRExporterGridCell.OCCUPIED_CELL;
                ElementWrapper elementWrapper = jRExporterGridCell.getWrapper();
                if (jRExporterGridCell == JRExporterGridCell.OCCUPIED_CELL || elementWrapper == null) continue;
                arrayList.add(elementWrapper);
                jRBasePrintFrame.addElement(elementWrapper.getElement());
            }
        }
        jRBasePrintFrame.setWidth(this.xCuts.getCut(n5) - this.xCuts.getCut(n3));
        jRBasePrintFrame.setHeight(this.yCuts.getCut(n4) - this.yCuts.getCut(n2));
        String string = (this.address == null ? "" : this.address + "_") + this.getNextVirtualFrameIndex();
        JRExporterGridCell jRExporterGridCell = new JRExporterGridCell(new ElementWrapper(jRBasePrintFrame, string, null), jRBasePrintFrame.getWidth(), jRBasePrintFrame.getHeight(), n5 - n3, n4 - n2);
        jRExporterGridCell.setLayout(new JRGridLayout(this.nature, arrayList.toArray(new ElementWrapper[arrayList.size()]), jRBasePrintFrame.getWidth(), jRBasePrintFrame.getHeight(), this.offsetX - this.xCuts.getCut(n3), this.offsetY - this.yCuts.getCut(n2), string));
        this.grid[n2][n3] = jRExporterGridCell;
    }

    public void layoutGrid(ElementWrapper[] elementWrapperArray) {
        boolean bl2 = this.xCuts == null;
        this.xCuts = bl2 ? new CutsInfo(this.width) : this.xCuts;
        this.yCuts = this.nature.isIgnoreLastRow() ? new CutsInfo(0) : new CutsInfo(this.height);
        this.createCuts(elementWrapperArray, this.offsetX, this.offsetY, bl2);
        this.xCuts.use();
        this.yCuts.use();
        int n2 = this.xCuts.size() - 1;
        int n3 = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[n3][n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.grid[i2][i3] = new JRExporterGridCell(null, this.xCuts.getCut(i3 + 1) - this.xCuts.getCut(i3), this.yCuts.getCut(i2 + 1) - this.yCuts.getCut(i2), 1, 1);
            }
        }
        this.setGridElements(elementWrapperArray, this.offsetX, this.offsetY, 0, 0, n3, n2);
    }

    public void createCuts(ElementWrapper[] elementWrapperArray, int n2, int n3, boolean bl2) {
        for (int i2 = 0; i2 < elementWrapperArray.length; ++i2) {
            JRPrintFrame jRPrintFrame;
            ElementWrapper elementWrapper = elementWrapperArray[i2];
            JRPrintElement jRPrintElement = elementWrapper.getElement();
            if (this.nature.isToExport(jRPrintElement)) {
                if (bl2) {
                    this.xCuts.addXCuts(jRPrintElement, n2);
                }
                this.yCuts.addYCuts(jRPrintElement, n3);
            }
            JRPrintFrame jRPrintFrame2 = jRPrintFrame = jRPrintElement instanceof JRPrintFrame ? (JRPrintFrame)jRPrintElement : null;
            if (!this.nature.isDeep() || jRPrintFrame == null) continue;
            this.createCuts(elementWrapper.getWrappers(), jRPrintElement.getX() + n2 + jRPrintFrame.getLineBox().getLeftPadding(), jRPrintElement.getY() + n3 + jRPrintFrame.getLineBox().getTopPadding(), bl2);
        }
    }

    public void setGridElements(ElementWrapper[] elementWrapperArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        for (int i2 = elementWrapperArray.length - 1; i2 >= 0; --i2) {
            JRPrintFrame jRPrintFrame;
            ElementWrapper elementWrapper = elementWrapperArray[i2];
            JRPrintElement jRPrintElement = elementWrapper.getElement();
            boolean bl2 = this.nature.isToExport(jRPrintElement);
            JRPrintFrame jRPrintFrame2 = jRPrintFrame = jRPrintElement instanceof JRPrintFrame ? (JRPrintFrame)jRPrintElement : null;
            if (!bl2 && jRPrintFrame == null) continue;
            int n8 = jRPrintElement.getX() + n2;
            int n9 = jRPrintElement.getY() + n3;
            int n10 = this.xCuts.indexOfCut(n8);
            int n11 = this.yCuts.indexOfCut(n9);
            int n12 = this.xCuts.indexOfCut(n8 + jRPrintElement.getWidth());
            int n13 = this.yCuts.indexOfCut(n9 + jRPrintElement.getHeight());
            if (bl2 && this.isOverlap(n11, n10, n13, n12)) continue;
            if (this.nature.isDeep() && jRPrintFrame != null) {
                this.setGridElements(elementWrapper.getWrappers(), n8 + jRPrintFrame.getLineBox().getLeftPadding(), n9 + jRPrintFrame.getLineBox().getTopPadding(), n11, n10, n13, n12);
            }
            if (!bl2) continue;
            if (this.nature.isDeep() && jRPrintFrame != null) {
                this.setFrameCellsStyle(jRPrintFrame, n11, n10, n13, n12);
                continue;
            }
            this.setGridElement(elementWrapper, n11, n10, n13, n12);
        }
        if (this.nature.isHorizontallyMergeEmptyCells()) {
            this.horizontallyMergeEmptyCells(n4, n5, n6, n7);
        }
    }

    public void horizontallyMergeEmptyCells(int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 < n4; ++i2) {
            JRExporterGridCell jRExporterGridCell;
            int n6;
            int n7 = -1;
            int n8 = 0;
            for (n6 = n3; n6 < n5; ++n6) {
                jRExporterGridCell = this.grid[i2][n6];
                if (jRExporterGridCell.isEmpty()) {
                    if (n7 == -1) {
                        n7 = n6;
                    }
                    n8 += jRExporterGridCell.getWidth();
                    continue;
                }
                if (n7 != -1 && n6 - n7 > 1) {
                    JRExporterGridCell jRExporterGridCell2 = this.grid[i2][n7];
                    jRExporterGridCell2.setColSpan(n6 - n7);
                    jRExporterGridCell2.setWidth(n8);
                }
                n7 = -1;
                n8 = 0;
            }
            if (n7 == -1 || n6 - n7 <= 1) continue;
            jRExporterGridCell = this.grid[i2][n7];
            jRExporterGridCell.setColSpan(n6 - n7);
            jRExporterGridCell.setWidth(n8);
        }
    }

    public boolean isOverlap(int n2, int n3, int n4, int n5) {
        boolean bl2;
        block4: {
            bl2 = false;
            if (this.nature.isSpanCells()) {
                for (int i2 = n2; i2 < n4; ++i2) {
                    for (int i3 = n3; i3 < n5; ++i3) {
                        if (this.grid[i2][i3].isEmpty()) continue;
                        bl2 = true;
                        break block4;
                    }
                }
            } else {
                bl2 = this.grid[n2][n3].getWrapper() != null;
            }
        }
        return bl2;
    }

    public void setGridElement(ElementWrapper elementWrapper, int n2, int n3, int n4, int n5) {
        int n6;
        this.yCuts.addUsage(n2, 1);
        this.xCuts.addUsage(n3, 1);
        for (n6 = n2; n6 < n4; ++n6) {
            for (int i2 = n3; i2 < n5; ++i2) {
                this.grid[n6][i2] = JRExporterGridCell.OCCUPIED_CELL;
            }
            this.yCuts.addUsage(n6, 2);
        }
        for (n6 = n3; n6 < n5; ++n6) {
            this.xCuts.addUsage(n6, 2);
        }
        if (n5 - n3 != 0 && n4 - n2 != 0) {
            JRPrintElement jRPrintElement = elementWrapper.getElement();
            JRPrintFrame jRPrintFrame = jRPrintElement instanceof JRPrintFrame ? (JRPrintFrame)jRPrintElement : null;
            JRExporterGridCell jRExporterGridCell = new JRExporterGridCell(elementWrapper, jRPrintElement.getWidth(), jRPrintElement.getHeight(), n5 - n3, n4 - n2);
            if (jRPrintFrame != null) {
                jRExporterGridCell.setLayout(new JRGridLayout(this.nature, elementWrapper.getWrappers(), jRPrintFrame.getWidth(), jRPrintFrame.getHeight(), 0, 0, elementWrapper.getAddress()));
            }
            jRExporterGridCell.setBox(jRPrintElement instanceof JRBoxContainer ? ((JRBoxContainer)((Object)jRPrintElement)).getLineBox() : null);
            this.grid[n2][n3] = jRExporterGridCell;
        }
    }

    public void setFrameCellsStyle(JRPrintFrame jRPrintFrame, int n2, int n3, int n4, int n5) {
        Color color = jRPrintFrame.getMode() == 1 ? jRPrintFrame.getBackcolor() : null;
        for (int i2 = n2; i2 < n4; ++i2) {
            for (int i3 = n3; i3 < n5; ++i3) {
                boolean bl2;
                JRExporterGridCell jRExporterGridCell = this.grid[i2][i3];
                if (jRExporterGridCell.getBackcolor() == null && jRPrintFrame.getMode() == 1) {
                    jRExporterGridCell.setBackcolor(color);
                }
                if (jRExporterGridCell.getForecolor() == null) {
                    jRExporterGridCell.setForecolor(jRPrintFrame.getForecolor());
                }
                boolean bl3 = i3 == n3;
                boolean bl4 = i3 == n5 - jRExporterGridCell.getColSpan();
                boolean bl5 = i2 == n2;
                boolean bl6 = bl2 = i2 == n4 - jRExporterGridCell.getRowSpan();
                if (!bl3 && !bl4 && !bl5 && !bl2) continue;
                JRLineBox jRLineBox = jRExporterGridCell.getBox();
                BoxKey boxKey = new BoxKey(jRPrintFrame.getLineBox(), jRLineBox, bl3, bl4, bl5, bl2);
                JRLineBox jRLineBox2 = (JRLineBox)this.boxesCache.get(boxKey);
                if (jRLineBox2 == null) {
                    jRLineBox2 = JRBoxUtil.clone(jRPrintFrame.getLineBox(), bl3, bl4, bl5, bl2, jRLineBox);
                    this.boxesCache.put(boxKey, jRLineBox2);
                }
                jRExporterGridCell.setBox(jRLineBox2);
            }
        }
    }

    private void splitSharedRowSpanIntoNestedGrids() {
        int n2;
        for (int i2 = 0; i2 < this.grid.length; i2 += Math.abs(n2)) {
            n2 = this.getSharedRowSpan(i2);
            if (n2 <= 0) continue;
            this.splitSharedColSpanIntoNestedGrids(i2, i2 + n2);
        }
    }

    private void splitSharedColSpanIntoNestedGrids(int n2, int n3) {
        int n4;
        for (int i2 = 0; i2 < this.grid[n2].length; i2 += Math.abs(n4)) {
            n4 = this.getSharedColSpan(n2, n3, i2);
            if (n4 <= 0 || n2 == 0 && n3 == this.grid.length && i2 == 0 && n4 == this.grid[0].length) continue;
            this.createNestedGrid(n2, i2, n3, i2 + n4);
        }
    }

    private int getSharedRowSpan(int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < this.grid[0].length; ++i3) {
                JRExporterGridCell jRExporterGridCell = this.grid[n2 + i2][i3];
                if (i2 + jRExporterGridCell.getRowSpan() <= n3) continue;
                ++n4;
                n3 = i2 + jRExporterGridCell.getRowSpan();
            }
        }
        return n4 > 1 ? n3 : -n3;
    }

    private int getSharedColSpan(int n2, int n3, int n4) {
        int n5 = 1;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = n2; i3 < n3; ++i3) {
                JRExporterGridCell jRExporterGridCell = this.grid[i3][n4 + i2];
                if (i2 + jRExporterGridCell.getColSpan() > n5) {
                    bl2 = true;
                    n5 = i2 + jRExporterGridCell.getColSpan();
                    continue;
                }
                if (jRExporterGridCell.getRowSpan() <= 1) continue;
                bl2 = true;
            }
        }
        return bl2 ? n5 : -n5;
    }

    public JRExporterGridCell[][] getGrid() {
        return this.grid;
    }

    public CutsInfo getXCuts() {
        return this.xCuts;
    }

    public CutsInfo getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRowHeight(int n2) {
        return this.yCuts.getCut(n2 + 1) - this.yCuts.getCut(n2);
    }

    public static int getMaxRowHeight(JRExporterGridCell[] jRExporterGridCellArray) {
        int n2 = jRExporterGridCellArray[0].getHeight();
        for (int i2 = 0; i2 < jRExporterGridCellArray.length; ++i2) {
            JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray[i2];
            if (jRExporterGridCell == JRExporterGridCell.OCCUPIED_CELL || n2 >= jRExporterGridCell.getHeight()) continue;
            n2 = jRExporterGridCell.getHeight();
        }
        return n2;
    }

    public static int getRowHeight(JRExporterGridCell[] jRExporterGridCellArray) {
        int n2;
        if (jRExporterGridCellArray[0].getRowSpan() == 1 && jRExporterGridCellArray[0] != JRExporterGridCell.OCCUPIED_CELL) {
            return jRExporterGridCellArray[0].getHeight();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = jRExporterGridCellArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray[n2];
            if (jRExporterGridCell == JRExporterGridCell.OCCUPIED_CELL) continue;
            if (jRExporterGridCell.getRowSpan() == 1) {
                n3 = jRExporterGridCell.getHeight();
                break;
            }
            if (jRExporterGridCell.getRowSpan() >= jRExporterGridCellArray[n4].getRowSpan()) continue;
            n4 = n2;
        }
        if (n2 >= n5) {
            n3 = jRExporterGridCellArray[n4].getHeight();
        }
        return n3;
    }

    public static CutsInfo calculateXCuts(ExporterNature exporterNature, List list, int n2, int n3, int n4, int n5) {
        CutsInfo cutsInfo = new CutsInfo(n4);
        for (int i2 = n2; i2 <= n3; ++i2) {
            JRPrintPage jRPrintPage = (JRPrintPage)list.get(i2);
            JRGridLayout.addXCuts(exporterNature, jRPrintPage.getElements(), n5, cutsInfo);
        }
        return cutsInfo;
    }

    public static void addXCuts(ExporterNature exporterNature, List list, int n2, CutsInfo cutsInfo) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
            if (exporterNature.isToExport(jRPrintElement)) {
                cutsInfo.addXCuts(jRPrintElement, n2);
            }
            if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
            JRGridLayout.addXCuts(exporterNature, jRPrintFrame.getElements(), jRPrintElement.getX() + n2 + jRPrintFrame.getLineBox().getLeftPadding(), cutsInfo);
        }
    }

    public int getNextVirtualFrameIndex() {
        return this.virtualFrameIndex++;
    }

    private static ElementWrapper[] createWrappers(List list, String string) {
        ElementWrapper[] elementWrapperArray = new ElementWrapper[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JRPrintElement jRPrintElement = (JRPrintElement)list.get(i2);
            String string2 = (string == null ? "" : string + "_") + i2;
            elementWrapperArray[i2] = new ElementWrapper(jRPrintElement, string2, jRPrintElement instanceof JRPrintFrame ? JRGridLayout.createWrappers(((JRPrintFrame)jRPrintElement).getElements(), string2) : null);
        }
        return elementWrapperArray;
    }

    protected static class BoxKey {
        public final JRLineBox f;
        public final JRLineBox b;
        public final boolean e;
        public final boolean c;
        public final boolean d;
        public final boolean g;
        public final int a;

        public BoxKey(JRLineBox jRLineBox, JRLineBox jRLineBox2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.f = jRLineBox;
            this.b = jRLineBox2;
            this.e = bl2;
            this.c = bl3;
            this.d = bl4;
            this.g = bl5;
            int n2 = jRLineBox.hashCode();
            if (jRLineBox2 != null) {
                n2 = 31 * n2 + jRLineBox2.hashCode();
            }
            n2 = 31 * n2 + (bl2 ? 1231 : 1237);
            n2 = 31 * n2 + (bl3 ? 1231 : 1237);
            n2 = 31 * n2 + (bl4 ? 1231 : 1237);
            this.a = n2 = 31 * n2 + (bl5 ? 1231 : 1237);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            BoxKey boxKey = (BoxKey)object;
            return boxKey.f.equals(this.f) && (boxKey.b == null ? this.b == null : this.b != null && boxKey.b.equals(this.b)) && boxKey.e == this.e && boxKey.c == this.c && boxKey.d == this.d && boxKey.g == this.g;
        }

        public int hashCode() {
            return this.a;
        }
    }
}

