/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRSourceCompileTask {
    private JasperDesign jasperDesign;
    private String unitName;
    private JRExpressionCollector expressionCollector;
    private Map parametersMap;
    private Map fieldsMap;
    private Map variablesMap;
    private JRVariable[] variables;
    private List expressions;
    private boolean onlyDefaultEvaluation;

    public JRSourceCompileTask(JasperDesign jasperDesign, String string, JRExpressionCollector jRExpressionCollector, Map map, Map map2, Map map3, JRVariable[] jRVariableArray, boolean bl2) {
        this.jasperDesign = jasperDesign;
        this.unitName = string;
        this.expressionCollector = jRExpressionCollector;
        this.parametersMap = map;
        this.fieldsMap = map2;
        this.variablesMap = map3;
        this.variables = jRVariableArray;
        this.expressions = jRExpressionCollector.getExpressions();
        this.onlyDefaultEvaluation = bl2;
    }

    public JRSourceCompileTask(JasperDesign jasperDesign, JRDesignDataset jRDesignDataset, JRExpressionCollector jRExpressionCollector, String string) {
        this(jasperDesign, string, jRExpressionCollector.getCollector(jRDesignDataset), jRDesignDataset.getParametersMap(), jRDesignDataset.getFieldsMap(), jRDesignDataset.getVariablesMap(), jRDesignDataset.getVariables(), false);
    }

    public JRSourceCompileTask(JasperDesign jasperDesign, JRDesignCrosstab jRDesignCrosstab, JRExpressionCollector jRExpressionCollector, String string) {
        this(jasperDesign, string, jRExpressionCollector.getCollector(jRDesignCrosstab), jRDesignCrosstab.getParametersMap(), null, jRDesignCrosstab.getVariablesMap(), jRDesignCrosstab.getVariables(), true);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public Map getFieldsMap() {
        return this.fieldsMap;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public String[] getImports() {
        return this.jasperDesign.getImports();
    }

    public boolean isOnlyDefaultEvaluation() {
        return this.onlyDefaultEvaluation;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public Map getVariablesMap() {
        return this.variablesMap;
    }

    public Integer getExpressionId(JRExpression jRExpression) {
        return this.expressionCollector.getExpressionId(jRExpression);
    }

    public JRExpression getExpression(int n2) {
        return this.expressionCollector.getExpression(n2);
    }
}

