/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignTextField
extends JRDesignTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    public boolean isStretchWithOverflow = false;
    public byte evaluationTime = 1;
    public String pattern = null;
    public Boolean isBlankWhenNull = null;
    public byte hyperlinkType = 0;
    public String linkType;
    public byte hyperlinkTarget = 1;
    private List hyperlinkParameters = new ArrayList();
    public JRGroup evaluationGroup = null;
    public JRExpression expression = null;
    public JRExpression anchorNameExpression = null;
    public JRExpression hyperlinkReferenceExpression = null;
    public JRExpression hyperlinkAnchorExpression = null;
    public JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    public int bookmarkLevel = 0;

    public JRDesignTextField() {
        super(null);
    }

    public JRDesignTextField(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return this.pattern;
    }

    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setStretchWithOverflow(boolean bl2) {
        boolean bl3 = this.isStretchWithOverflow;
        this.isStretchWithOverflow = bl2;
        this.getEventSupport().firePropertyChange("stretchWithOverflow", bl3, this.isStretchWithOverflow);
    }

    public void setEvaluationTime(byte by2) {
        byte by3 = this.evaluationTime;
        this.evaluationTime = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, by3, this.evaluationTime);
    }

    public void setPattern(String string) {
        String string2 = this.pattern;
        this.pattern = string;
        this.getEventSupport().firePropertyChange("pattern", string2, this.pattern);
    }

    public void setBlankWhenNull(boolean bl2) {
        this.setBlankWhenNull(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBlankWhenNull(Boolean bl2) {
        Boolean bl3 = this.isBlankWhenNull;
        this.isBlankWhenNull = bl2;
        this.getEventSupport().firePropertyChange("blankWhenNull", bl3, this.isBlankWhenNull);
    }

    public void setHyperlinkType(byte by2) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by2));
    }

    public void setHyperlinkTarget(byte by2) {
        byte by3 = this.hyperlinkTarget;
        this.hyperlinkTarget = by2;
        this.getEventSupport().firePropertyChange("hyperlinkTarget", by3, this.hyperlinkTarget);
    }

    public void setEvaluationGroup(JRGroup jRGroup) {
        JRGroup jRGroup2 = this.evaluationGroup;
        this.evaluationGroup = jRGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, jRGroup2, this.evaluationGroup);
    }

    public void setExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.expression;
        this.expression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, jRExpression2, this.expression);
    }

    public void setAnchorNameExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.anchorNameExpression;
        this.anchorNameExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, jRExpression2, this.anchorNameExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", jRExpression2, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", jRExpression2, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", jRExpression2, this.hyperlinkPageExpression);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitTextField(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n2) {
        int n3 = this.bookmarkLevel;
        this.bookmarkLevel = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, n3, this.bookmarkLevel);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        String string2 = this.linkType;
        this.linkType = string;
        this.getEventSupport().firePropertyChange("linkType", string2, this.linkType);
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", jRHyperlinkParameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        int n2 = this.hyperlinkParameters.indexOf(jRHyperlinkParameter);
        if (n2 >= 0) {
            this.hyperlinkParameters.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", jRHyperlinkParameter, n2);
        }
    }

    public void removeHyperlinkParameter(String string) {
        ListIterator listIterator = this.hyperlinkParameters.listIterator();
        while (listIterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)listIterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            listIterator.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", jRHyperlinkParameter, listIterator.nextIndex());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    public void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = jRExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", jRExpression2, this.hyperlinkTooltipExpression);
    }

    public Object clone() {
        JRDesignTextField jRDesignTextField = (JRDesignTextField)super.clone();
        if (this.hyperlinkParameters != null) {
            jRDesignTextField.hyperlinkParameters = new ArrayList(this.hyperlinkParameters.size());
            for (int i2 = 0; i2 < this.hyperlinkParameters.size(); ++i2) {
                jRDesignTextField.hyperlinkParameters.add(((JRHyperlinkParameter)this.hyperlinkParameters.get(i2)).clone());
            }
        }
        if (this.expression != null) {
            jRDesignTextField.expression = (JRExpression)this.expression.clone();
        }
        if (this.anchorNameExpression != null) {
            jRDesignTextField.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            jRDesignTextField.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            jRDesignTextField.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            jRDesignTextField.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            jRDesignTextField.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return jRDesignTextField;
    }
}

