/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRDesignFrame
extends JRDesignElement
implements JRFrame {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CHILDREN = "children";
    private List children = new ArrayList();
    public JRLineBox lineBox = new JRBaseLineBox(this);
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRDesignFrame(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    public JRDesignFrame() {
        this(null);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitFrame(this);
    }

    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public void addElement(JRElement jRElement) {
        if (jRElement instanceof JRDesignElement) {
            ((JRDesignElement)jRElement).setElementGroup(this);
        }
        this.children.add(jRElement);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, jRElement, this.children.size() - 1);
    }

    public boolean removeElement(JRElement jRElement) {
        int n2;
        if (jRElement instanceof JRDesignElement) {
            ((JRDesignElement)jRElement).setElementGroup(null);
        }
        if ((n2 = this.children.indexOf(jRElement)) >= 0) {
            this.children.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, jRElement, n2);
            return true;
        }
        return false;
    }

    public void addElementGroup(JRElementGroup jRElementGroup) {
        if (jRElementGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)jRElementGroup).setElementGroup(this);
        }
        this.children.add(jRElementGroup);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, jRElementGroup, this.children.size() - 1);
    }

    public boolean removeElementGroup(JRElementGroup jRElementGroup) {
        int n2;
        if (jRElementGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)jRElementGroup).setElementGroup(null);
        }
        if ((n2 = this.children.indexOf(jRElementGroup)) >= 0) {
            this.children.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, jRElementGroup, n2);
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.children;
    }

    public JRElement getElementByKey(String string) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), string);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox jRBox) {
        JRBoxUtil.setBoxToLineBox(jRBox, this.lineBox);
    }

    public void copyBox(JRLineBox jRLineBox) {
        this.lineBox = jRLineBox.clone(this);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRDesignFrame jRDesignFrame = (JRDesignFrame)super.clone();
        if (this.children != null) {
            jRDesignFrame.children = new ArrayList(this.children.size());
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                jRDesignFrame.children.add(((JRChild)this.children.get(i2)).clone(jRDesignFrame));
            }
        }
        return jRDesignFrame;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }
}

