/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseTextField
extends JRBaseTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_STRETCH_WITH_OVERFLOW = "stretchWithOverflow";
    public boolean isStretchWithOverflow = false;
    public byte evaluationTime = 1;
    public String pattern;
    public Boolean isBlankWhenNull = null;
    public byte hyperlinkType = 0;
    public String linkType;
    public byte hyperlinkTarget = 1;
    private JRHyperlinkParameter[] hyperlinkParameters;
    public JRGroup evaluationGroup = null;
    public JRExpression expression = null;
    public JRExpression anchorNameExpression = null;
    public JRExpression hyperlinkReferenceExpression = null;
    public JRExpression hyperlinkAnchorExpression = null;
    public JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    public int bookmarkLevel = 0;

    public JRBaseTextField(JRTextField jRTextField, JRBaseObjectFactory jRBaseObjectFactory) {
        super(jRTextField, jRBaseObjectFactory);
        this.isStretchWithOverflow = jRTextField.isStretchWithOverflow();
        this.evaluationTime = jRTextField.getEvaluationTime();
        this.pattern = jRTextField.getOwnPattern();
        this.isBlankWhenNull = jRTextField.isOwnBlankWhenNull();
        this.linkType = jRTextField.getLinkType();
        this.hyperlinkTarget = jRTextField.getHyperlinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(jRTextField, jRBaseObjectFactory);
        this.evaluationGroup = jRBaseObjectFactory.getGroup(jRTextField.getEvaluationGroup());
        this.expression = jRBaseObjectFactory.getExpression(jRTextField.getExpression());
        this.anchorNameExpression = jRBaseObjectFactory.getExpression(jRTextField.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = jRBaseObjectFactory.getExpression(jRTextField.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = jRBaseObjectFactory.getExpression(jRTextField.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = jRBaseObjectFactory.getExpression(jRTextField.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = jRBaseObjectFactory.getExpression(jRTextField.getHyperlinkTooltipExpression());
        this.bookmarkLevel = jRTextField.getBookmarkLevel();
    }

    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    public void setStretchWithOverflow(boolean bl2) {
        boolean bl3 = this.isStretchWithOverflow;
        this.isStretchWithOverflow = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_STRETCH_WITH_OVERFLOW, bl3, this.isStretchWithOverflow);
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        String string2 = this.pattern;
        this.pattern = string;
        this.getEventSupport().firePropertyChange("pattern", string2, this.pattern);
    }

    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    public void setBlankWhenNull(Boolean bl2) {
        Boolean bl3 = this.isBlankWhenNull;
        this.isBlankWhenNull = bl2;
        this.getEventSupport().firePropertyChange("blankWhenNull", bl3, this.isBlankWhenNull);
    }

    public void setBlankWhenNull(boolean bl2) {
        this.setBlankWhenNull(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitTextField(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    public void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Object clone() {
        JRBaseTextField jRBaseTextField = (JRBaseTextField)super.clone();
        if (this.hyperlinkParameters != null) {
            jRBaseTextField.hyperlinkParameters = new JRHyperlinkParameter[this.hyperlinkParameters.length];
            for (int i2 = 0; i2 < this.hyperlinkParameters.length; ++i2) {
                jRBaseTextField.hyperlinkParameters[i2] = (JRHyperlinkParameter)this.hyperlinkParameters[i2].clone();
            }
        }
        if (this.expression != null) {
            jRBaseTextField.expression = (JRExpression)this.expression.clone();
        }
        if (this.anchorNameExpression != null) {
            jRBaseTextField.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            jRBaseTextField.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            jRBaseTextField.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            jRBaseTextField.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            jRBaseTextField.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return jRBaseTextField;
    }
}

