/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseStyle
implements JRStyle,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10001L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BLANK_WHEN_NULL = "blankWhenNull";
    public static final String PROPERTY_BOLD = "bold";
    public static final String PROPERTY_FILL = "fill";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FORECOLOR = "forecolor";
    public static final String PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String PROPERTY_ITALIC = "italic";
    public static final String PROPERTY_LINE_SPACING = "lineSpacing";
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_PDF_EMBEDDED = "pdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_RADIUS = "radius";
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_SCALE_IMAGE = "scaleImage";
    public static final String PROPERTY_STRIKE_THROUGH = "strikeThrough";
    public static final String PROPERTY_IS_STYLED_TEXT = "isStyledText";
    public static final String PROPERTY_UNDERLINE = "underline";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    public JRDefaultStyleProvider defaultStyleProvider = null;
    public JRStyle parentStyle = null;
    public String parentStyleNameReference;
    public String name = null;
    public boolean isDefault = false;
    public Byte positionType = null;
    public Byte stretchType = null;
    public Byte mode = null;
    public Color forecolor = null;
    public Color backcolor = null;
    public JRPen linePen = null;
    public Byte fill = null;
    public Integer radius = null;
    public Byte scaleImage = null;
    public Byte horizontalAlignment = null;
    public Byte verticalAlignment = null;
    public JRLineBox lineBox = null;
    public String fontName = null;
    public Boolean isBold = null;
    public Boolean isItalic = null;
    public Boolean isUnderline = null;
    public Boolean isStrikeThrough = null;
    public Integer fontSize = null;
    public String pdfFontName = null;
    public String pdfEncoding = null;
    public Boolean isPdfEmbedded = null;
    public Byte rotation = null;
    public Byte lineSpacing = null;
    public Boolean isStyledText = null;
    public String pattern = null;
    public Boolean isBlankWhenNull = null;
    public JRConditionalStyle[] conditionalStyles;
    private transient JRPropertyChangeSupport eventSupport;
    private Byte pen;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRBaseStyle() {
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
    }

    public JRBaseStyle(String string) {
        this.name = string;
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
    }

    public JRBaseStyle(JRStyle jRStyle, JRAbstractObjectFactory jRAbstractObjectFactory) {
        this.name = jRStyle.getName();
        jRAbstractObjectFactory.setStyle(new JRStyleSetter(this){
            private final JRBaseStyle this$0;
            {
                this.this$0 = jRBaseStyle;
            }

            public void setStyle(JRStyle jRStyle) {
                this.this$0.setParentStyle(jRStyle);
            }

            public void setStyleNameReference(String string) {
                this.this$0.parentStyleNameReference = string;
            }
        }, jRStyle);
        this.isDefault = jRStyle.isDefault();
        this.mode = jRStyle.getOwnMode();
        this.forecolor = jRStyle.getOwnForecolor();
        this.backcolor = jRStyle.getOwnBackcolor();
        this.linePen = jRStyle.getLinePen().clone(this);
        this.fill = jRStyle.getOwnFill();
        this.radius = jRStyle.getOwnRadius();
        this.scaleImage = jRStyle.getOwnScaleImage();
        this.horizontalAlignment = jRStyle.getOwnHorizontalAlignment();
        this.verticalAlignment = jRStyle.getOwnVerticalAlignment();
        this.lineBox = jRStyle.getLineBox().clone(this);
        this.rotation = jRStyle.getOwnRotation();
        this.lineSpacing = jRStyle.getOwnLineSpacing();
        this.isStyledText = jRStyle.isOwnStyledText();
        this.pattern = jRStyle.getOwnPattern();
        this.fontName = jRStyle.getOwnFontName();
        this.isBold = jRStyle.isOwnBold();
        this.isItalic = jRStyle.isOwnItalic();
        this.isUnderline = jRStyle.isOwnUnderline();
        this.isStrikeThrough = jRStyle.isOwnStrikeThrough();
        this.fontSize = jRStyle.getOwnFontSize();
        this.pdfFontName = jRStyle.getOwnPdfFontName();
        this.pdfEncoding = jRStyle.getOwnPdfEncoding();
        this.isPdfEmbedded = jRStyle.isOwnPdfEmbedded();
        JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
        if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
            this.conditionalStyles = new JRConditionalStyle[jRConditionalStyleArray.length];
            for (int i2 = 0; i2 < jRConditionalStyleArray.length; ++i2) {
                this.conditionalStyles[i2] = jRAbstractObjectFactory.getConditionalStyle(jRConditionalStyleArray[i2], this);
            }
        }
    }

    public void setParentStyle(JRStyle jRStyle) {
        this.parentStyle = jRStyle;
        this.checkCircularParent();
    }

    public void checkCircularParent() {
        for (JRStyle jRStyle = this.parentStyle; jRStyle != null; jRStyle = jRStyle.getStyle()) {
            if (jRStyle != this) continue;
            throw new JRRuntimeException("Circular dependency detected for style " + this.getName());
        }
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle getStyle() {
        return this.parentStyle;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String string) {
        this.name = string;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public JRPen getLinePen() {
        return this.linePen;
    }

    public Byte getPen() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.linePen));
    }

    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    public void setPen(byte by2) {
        this.setPen(new Byte(by2));
    }

    public void setPen(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, this.linePen);
    }

    public Byte getFill() {
        return JRStyleResolver.getFill(this);
    }

    public Byte getOwnFill() {
        return this.fill;
    }

    public Integer getRadius() {
        return JRStyleResolver.getRadius(this);
    }

    public Integer getOwnRadius() {
        return this.radius;
    }

    public Byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    public Byte getOwnScaleImage() {
        return this.scaleImage;
    }

    public Byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public Byte getBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getPen()));
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public Integer getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public Byte getTopBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen()));
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public Integer getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public Byte getLeftBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen()));
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public Integer getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public Byte getBottomBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen()));
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public Integer getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public Byte getRightBorder() {
        return new Byte(JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen()));
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public Integer getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public Byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return this.rotation;
    }

    public Byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public Boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return this.isStyledText;
    }

    public Boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return this.isStyledText;
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public Boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public Boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public Boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public Boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public Integer getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public Boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return this.pattern;
    }

    public Byte getMode() {
        return JRStyleResolver.getMode(this);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    public void setForecolor(Color color) {
        Color color2 = this.forecolor;
        this.forecolor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_FORECOLOR, color2, this.forecolor);
    }

    public void setBackcolor(Color color) {
        Color color2 = this.backcolor;
        this.backcolor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, color2, this.backcolor);
    }

    public void setMode(byte by2) {
        this.setMode(new Byte(by2));
    }

    public void setMode(Byte by2) {
        Byte by3 = this.mode;
        this.mode = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_MODE, by3, this.mode);
    }

    public void setFill(byte by2) {
        this.setFill(new Byte(by2));
    }

    public void setFill(Byte by2) {
        Byte by3 = this.fill;
        this.fill = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_FILL, by3, this.fill);
    }

    public void setRadius(int n2) {
        this.setRadius(new Integer(n2));
    }

    public void setRadius(Integer n2) {
        Integer n3 = this.radius;
        this.radius = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_RADIUS, n3, this.radius);
    }

    public void setScaleImage(byte by2) {
        this.setScaleImage(new Byte(by2));
    }

    public void setScaleImage(Byte by2) {
        Byte by3 = this.scaleImage;
        this.scaleImage = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_SCALE_IMAGE, by3, this.scaleImage);
    }

    public void setHorizontalAlignment(byte by2) {
        this.setHorizontalAlignment(new Byte(by2));
    }

    public void setHorizontalAlignment(Byte by2) {
        Byte by3 = this.horizontalAlignment;
        this.horizontalAlignment = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_ALIGNMENT, by3, this.horizontalAlignment);
    }

    public void setVerticalAlignment(byte by2) {
        this.setVerticalAlignment(new Byte(by2));
    }

    public void setVerticalAlignment(Byte by2) {
        Byte by3 = this.verticalAlignment;
        this.verticalAlignment = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_ALIGNMENT, by3, this.verticalAlignment);
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRotation(byte by2) {
        this.setRotation(new Byte(by2));
    }

    public void setRotation(Byte by2) {
        Byte by3 = this.rotation;
        this.rotation = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, by3, this.rotation);
    }

    public void setFontName(String string) {
        String string2 = this.fontName;
        this.fontName = string;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, string2, this.fontName);
    }

    public void setBold(boolean bl2) {
        this.setBold(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean bl2) {
        Boolean bl3 = this.isBold;
        this.isBold = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, bl3, this.isBold);
    }

    public void setItalic(boolean bl2) {
        this.setItalic(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean bl2) {
        Boolean bl3 = this.isItalic;
        this.isItalic = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, bl3, this.isItalic);
    }

    public void setPdfEmbedded(boolean bl2) {
        this.setPdfEmbedded(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean bl2) {
        Boolean bl3 = this.isPdfEmbedded;
        this.isPdfEmbedded = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, bl3, this.isPdfEmbedded);
    }

    public void setStrikeThrough(boolean bl2) {
        this.setStrikeThrough(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean bl2) {
        Boolean bl3 = this.isStrikeThrough;
        this.isStrikeThrough = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, bl3, this.isStrikeThrough);
    }

    public void setStyledText(boolean bl2) {
        this.setStyledText(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean bl2) {
        Boolean bl3 = this.isStyledText;
        this.isStyledText = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_IS_STYLED_TEXT, bl3, this.isStyledText);
    }

    public void setBlankWhenNull(boolean bl2) {
        this.setBlankWhenNull(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBlankWhenNull(Boolean bl2) {
        Boolean bl3 = this.isBlankWhenNull;
        this.isBlankWhenNull = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_BLANK_WHEN_NULL, bl3, this.isBlankWhenNull);
    }

    public void setUnderline(boolean bl2) {
        this.setUnderline(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean bl2) {
        Boolean bl3 = this.isUnderline;
        this.isUnderline = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, bl3, this.isUnderline);
    }

    public void setLineSpacing(byte by2) {
        this.setLineSpacing(new Byte(by2));
    }

    public void setLineSpacing(Byte by2) {
        Byte by3 = this.lineSpacing;
        this.lineSpacing = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_SPACING, by3, this.lineSpacing);
    }

    public void setPattern(String string) {
        String string2 = this.pattern;
        this.pattern = string;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN, string2, this.pattern);
    }

    public void setPdfEncoding(String string) {
        String string2 = this.pdfEncoding;
        this.pdfEncoding = string;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, string2, this.pdfEncoding);
    }

    public void setPdfFontName(String string) {
        String string2 = this.pdfFontName;
        this.pdfFontName = string;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, string2, this.pdfFontName);
    }

    public void setFontSize(int n2) {
        this.setFontSize(new Integer(n2));
    }

    public void setFontSize(Integer n2) {
        Integer n3 = this.fontSize;
        this.fontSize = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, n3, this.fontSize);
    }

    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStyles;
    }

    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    public Float getDefaultLineWidth() {
        return null;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseStyle jRBaseStyle = this;
        synchronized (jRBaseStyle) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }
}

