/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import org.jfree.chart.plot.PlotOrientation;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BACKGROUND_ALPHA = "backgroundAlpha";
    public static final String PROPERTY_FOREGROUND_ALPHA = "foregroundAlpha";
    public static final String PROPERTY_LABEL_ROTATION = "labelRotation";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_SERIES_COLORS = "seriesColors";
    public JRChart chart = null;
    public Color backcolor = null;
    public PlotOrientation orientation = PlotOrientation.VERTICAL;
    public float backgroundAlpha = 1.0f;
    public float foregroundAlpha = 1.0f;
    public double labelRotation = 0.0;
    public SortedSet seriesColors = null;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBaseChartPlot(JRChartPlot jRChartPlot, JRChart jRChart) {
        this.chart = jRChart;
        if (jRChartPlot != null) {
            this.backcolor = jRChartPlot.getOwnBackcolor();
            this.orientation = jRChartPlot.getOrientation();
            this.backgroundAlpha = jRChartPlot.getBackgroundAlpha();
            this.foregroundAlpha = jRChartPlot.getForegroundAlpha();
            this.labelRotation = jRChartPlot.getLabelRotation();
            this.seriesColors = new TreeSet(jRChartPlot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet();
        }
    }

    public JRBaseChartPlot(JRChartPlot jRChartPlot, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRChartPlot, this);
        this.chart = (JRChart)jRBaseObjectFactory.getVisitResult(jRChartPlot.getChart());
        this.backcolor = jRChartPlot.getOwnBackcolor();
        this.orientation = jRChartPlot.getOrientation();
        this.backgroundAlpha = jRChartPlot.getBackgroundAlpha();
        this.foregroundAlpha = jRChartPlot.getForegroundAlpha();
        this.labelRotation = jRChartPlot.getLabelRotation();
        this.seriesColors = new TreeSet(jRChartPlot.getSeriesColors());
    }

    public JRChart getChart() {
        return this.chart;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color color) {
        Color color2 = this.backcolor;
        this.backcolor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, color2, this.backcolor);
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        PlotOrientation plotOrientation2 = this.orientation;
        this.orientation = plotOrientation;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, plotOrientation2, this.orientation);
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f2) {
        float f3 = this.backgroundAlpha;
        this.backgroundAlpha = f2;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKGROUND_ALPHA, f3, this.backgroundAlpha);
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f2) {
        float f3 = this.foregroundAlpha;
        this.foregroundAlpha = f2;
        this.getEventSupport().firePropertyChange(PROPERTY_FOREGROUND_ALPHA, f3, this.foregroundAlpha);
    }

    public double getLabelRotation() {
        return this.labelRotation;
    }

    public void setLabelRotation(double d2) {
        double d3 = this.labelRotation;
        this.labelRotation = d2;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_ROTATION, d3, this.labelRotation);
    }

    public SortedSet getSeriesColors() {
        return this.seriesColors;
    }

    public void clearSeriesColors() {
        this.setSeriesColors(null);
    }

    public void addSeriesColor(JRChartPlot.JRSeriesColor jRSeriesColor) {
        this.seriesColors.add(jRSeriesColor);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SERIES_COLORS, jRSeriesColor, this.seriesColors.size() - 1);
    }

    public void setSeriesColors(Collection collection) {
        TreeSet treeSet = new TreeSet(this.seriesColors);
        this.seriesColors.clear();
        if (collection != null) {
            this.seriesColors.addAll(collection);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_SERIES_COLORS, treeSet, this.seriesColors);
    }

    public Object clone(JRChart jRChart) {
        JRBaseChartPlot jRBaseChartPlot = null;
        try {
            jRBaseChartPlot = (JRBaseChartPlot)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JRRuntimeException(cloneNotSupportedException);
        }
        jRBaseChartPlot.chart = jRChart;
        if (this.seriesColors != null) {
            jRBaseChartPlot.seriesColors = new TreeSet();
            Iterator iterator = this.seriesColors.iterator();
            while (iterator.hasNext()) {
                jRBaseChartPlot.seriesColors.add(((JRChartPlot.JRSeriesColor)iterator.next()).clone());
            }
        }
        return jRBaseChartPlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseChartPlot jRBaseChartPlot = this;
        synchronized (jRBaseChartPlot) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable {
        private static final long serialVersionUID = 10200L;
        public int seriesOrder = -1;
        public Color color = null;

        public JRBaseSeriesColor(int n2, Color color) {
            this.seriesOrder = n2;
            this.color = color;
        }

        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.seriesOrder - ((JRBaseSeriesColor)object).getSeriesOrder();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new JRRuntimeException(cloneNotSupportedException);
            }
        }
    }
}

