/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";
    public static final String PROPERTY_LEGEND_COLOR = "legendColor";
    public static final String PROPERTY_LEGEND_POSITION = "legendPosition";
    public static final String PROPERTY_SHOW_LEGEND = "showLegend";
    public static final String PROPERTY_SUBTITLE_COLOR = "subtitleColor";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_TITLE_POSITION = "titlePosition";
    public byte chartType = 0;
    public boolean isShowLegend = false;
    public byte evaluationTime = 1;
    public byte hyperlinkType = 0;
    public String linkType;
    public byte hyperlinkTarget = 1;
    private JRHyperlinkParameter[] hyperlinkParameters;
    public byte titlePosition = 1;
    public Color titleColor = null;
    public Color subtitleColor = null;
    public Color legendColor = null;
    public Color legendBackgroundColor = null;
    public byte legendPosition = (byte)2;
    public JRLineBox lineBox = null;
    public JRFont titleFont = null;
    public JRFont subtitleFont = null;
    public JRFont legendFont = null;
    public String customizerClass;
    public JRGroup evaluationGroup = null;
    public JRExpression titleExpression = null;
    public JRExpression subtitleExpression = null;
    public JRExpression anchorNameExpression = null;
    public JRExpression hyperlinkReferenceExpression = null;
    public JRExpression hyperlinkAnchorExpression = null;
    public JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    public JRChartDataset dataset = null;
    public JRChartPlot plot = null;
    public int bookmarkLevel = 0;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRBaseChart(JRChart jRChart, JRBaseObjectFactory jRBaseObjectFactory) {
        super(jRChart, jRBaseObjectFactory);
        this.chartType = jRChart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 3: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 2: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 4: {
                this.dataset = jRBaseObjectFactory.getXyzDataset((JRXyzDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBubblePlot((JRBubblePlot)jRChart.getPlot());
                break;
            }
            case 5: {
                this.dataset = jRBaseObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getCandlestickPlot((JRCandlestickPlot)jRChart.getPlot());
                break;
            }
            case 6: {
                this.dataset = jRBaseObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getHighLowPlot((JRHighLowPlot)jRChart.getPlot());
                break;
            }
            case 7: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 17: {
                this.dataset = jRBaseObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getMeterPlot((JRMeterPlot)jRChart.getPlot());
                break;
            }
            case 19: {
                this.dataset = null;
                this.plot = jRBaseObjectFactory.getMultiAxisPlot((JRMultiAxisPlot)jRChart.getPlot());
                break;
            }
            case 9: {
                this.dataset = jRBaseObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getPiePlot((JRPiePlot)jRChart.getPlot());
                break;
            }
            case 8: {
                this.dataset = jRBaseObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getPie3DPlot((JRPie3DPlot)jRChart.getPlot());
                break;
            }
            case 10: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getScatterPlot((JRScatterPlot)jRChart.getPlot());
                break;
            }
            case 12: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 11: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 18: {
                this.dataset = jRBaseObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getThermometerPlot((JRThermometerPlot)jRChart.getPlot());
                break;
            }
            case 16: {
                this.dataset = jRBaseObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
                break;
            }
            case 13: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 14: {
                switch (jRChart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = jRBaseObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = jRBaseObjectFactory.getTimePeriodDataset((JRTimePeriodDataset)jRChart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                    }
                }
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 15: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 20: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.isShowLegend = jRChart.isShowLegend();
        this.evaluationTime = jRChart.getEvaluationTime();
        this.linkType = jRChart.getLinkType();
        this.hyperlinkTarget = jRChart.getHyperlinkTarget();
        this.titlePosition = jRChart.getTitlePosition();
        this.titleColor = jRChart.getOwnTitleColor();
        this.subtitleColor = jRChart.getOwnSubtitleColor();
        this.legendColor = jRChart.getOwnLegendColor();
        this.legendBackgroundColor = jRChart.getOwnLegendBackgroundColor();
        this.legendPosition = jRChart.getLegendPosition();
        this.titleFont = new JRBaseFont(null, null, this, jRChart.getTitleFont());
        this.subtitleFont = new JRBaseFont(null, null, this, jRChart.getSubtitleFont());
        this.legendFont = new JRBaseFont(null, null, this, jRChart.getLegendFont());
        this.evaluationGroup = jRBaseObjectFactory.getGroup(jRChart.getEvaluationGroup());
        this.titleExpression = jRBaseObjectFactory.getExpression(jRChart.getTitleExpression());
        this.subtitleExpression = jRBaseObjectFactory.getExpression(jRChart.getSubtitleExpression());
        this.anchorNameExpression = jRBaseObjectFactory.getExpression(jRChart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = jRChart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(jRChart, jRBaseObjectFactory);
        this.customizerClass = jRChart.getCustomizerClass();
        this.lineBox = jRChart.getLineBox().clone(this);
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean bl2) {
        boolean bl3 = this.isShowLegend;
        this.isShowLegend = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LEGEND, bl3, this.isShowLegend);
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte by2) {
        byte by3 = this.titlePosition;
        this.titlePosition = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_POSITION, by3, this.titlePosition);
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.titleColor;
        this.titleColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_COLOR, color2, this.titleColor);
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public void setSubtitleColor(Color color) {
        Color color2 = this.subtitleColor;
        this.subtitleColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_COLOR, color2, this.subtitleColor);
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendBackgroundColor(Color color) {
        Color color2 = this.legendBackgroundColor;
        this.legendBackgroundColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, color2, this.legendBackgroundColor);
    }

    public void setLegendColor(Color color) {
        Color color2 = this.legendColor;
        this.legendColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_COLOR, color2, this.legendColor);
    }

    public byte getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(byte by2) {
        byte by3 = this.legendPosition;
        this.legendPosition = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_POSITION, by3, this.legendPosition);
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitChart(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRBaseChart jRBaseChart = (JRBaseChart)super.clone();
        if (this.hyperlinkParameters != null) {
            jRBaseChart.hyperlinkParameters = new JRHyperlinkParameter[this.hyperlinkParameters.length];
            for (int i2 = 0; i2 < this.hyperlinkParameters.length; ++i2) {
                jRBaseChart.hyperlinkParameters[i2] = (JRHyperlinkParameter)this.hyperlinkParameters[i2].clone();
            }
        }
        if (this.titleExpression != null) {
            jRBaseChart.titleExpression = (JRExpression)this.titleExpression.clone();
        }
        if (this.subtitleExpression != null) {
            jRBaseChart.subtitleExpression = (JRExpression)this.subtitleExpression.clone();
        }
        if (this.anchorNameExpression != null) {
            jRBaseChart.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            jRBaseChart.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            jRBaseChart.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            jRBaseChart.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            jRBaseChart.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        if (this.dataset != null) {
            jRBaseChart.dataset = (JRChartDataset)this.dataset.clone();
        }
        if (this.plot != null) {
            jRBaseChart.plot = (JRChartPlot)this.plot.clone(jRBaseChart);
        }
        return jRBaseChart;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
    }
}

