/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRJdk12Compiler;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JasperCompileManager {
    public static Class a;

    public static String compileReportToFile(String string) throws JRException {
        File file = new File(string);
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        File file2 = new File(file.getParent(), jasperDesign.getName() + ".jasper");
        String string2 = file2.toString();
        JasperCompileManager.compileReportToFile(jasperDesign, string2);
        return string2;
    }

    public static void compileReportToFile(String string, String string2) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        JasperCompileManager.compileReportToFile(jasperDesign, string2);
    }

    public static void compileReportToFile(JasperDesign jasperDesign, String string) throws JRException {
        JasperReport jasperReport = JasperCompileManager.compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, string);
    }

    public static JasperReport compileReport(String string) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static void compileReportToStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        JasperCompileManager.compileReportToStream(jasperDesign, outputStream);
    }

    public static void compileReportToStream(JasperDesign jasperDesign, OutputStream outputStream) throws JRException {
        JasperReport jasperReport = JasperCompileManager.compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, outputStream);
    }

    public static JasperReport compileReport(InputStream inputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        return JasperCompileManager.getCompiler(jasperDesign).compileReport(jasperDesign);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        JRCompiler jRCompiler = JasperCompileManager.getCompiler(jasperReport);
        return jRCompiler.loadEvaluator(jasperReport, jRDataset);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab jRCrosstab) throws JRException {
        JRCompiler jRCompiler = JasperCompileManager.getCompiler(jasperReport);
        return jRCompiler.loadEvaluator(jasperReport, jRCrosstab);
    }

    public static JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return JasperCompileManager.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    public static String writeReportToXmlFile(String string) throws JRException {
        File file = new File(string);
        JRReport jRReport = (JRReport)JRLoader.loadObject(file);
        File file2 = new File(file.getParent(), jRReport.getName() + ".jasper.jrxml");
        String string2 = file2.toString();
        JasperCompileManager.writeReportToXmlFile(jRReport, string2);
        return string2;
    }

    public static void writeReportToXmlFile(String string, String string2) throws JRException {
        JRReport jRReport = (JRReport)JRLoader.loadObject(string);
        JasperCompileManager.writeReportToXmlFile(jRReport, string2);
    }

    public static void writeReportToXmlFile(JRReport jRReport, String string) throws JRException {
        JRXmlWriter.writeReport(jRReport, string, "UTF-8");
    }

    public static void writeReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JRReport jRReport = (JRReport)JRLoader.loadObject(inputStream);
        JasperCompileManager.writeReportToXmlStream(jRReport, outputStream);
    }

    public static void writeReportToXmlStream(JRReport jRReport, OutputStream outputStream) throws JRException {
        JRXmlWriter.writeReport(jRReport, outputStream, "UTF-8");
    }

    public static String writeReportToXml(JRReport jRReport) {
        return JRXmlWriter.writeReport(jRReport, "UTF-8");
    }

    private static JRCompiler getJavaCompiler() {
        JRAbstractJavaCompiler jRAbstractJavaCompiler = null;
        try {
            JRClassLoader.loadClassForRealName("org.eclipse.jdt.internal.compiler.Compiler");
            jRAbstractJavaCompiler = new JRJdtCompiler();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jRAbstractJavaCompiler == null) {
            try {
                JRClassLoader.loadClassForRealName("com.sun.tools.javac.Main");
                jRAbstractJavaCompiler = new JRJdk13Compiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jRAbstractJavaCompiler == null) {
            try {
                JRClassLoader.loadClassForRealName("sun.tools.javac.Main");
                jRAbstractJavaCompiler = new JRJdk12Compiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jRAbstractJavaCompiler == null) {
            jRAbstractJavaCompiler = new JRJavacCompiler();
        }
        return jRAbstractJavaCompiler;
    }

    private static JRCompiler getCompiler(JasperReport jasperReport) throws JRException {
        JRCompiler jRCompiler = null;
        String string = jasperReport.getCompilerClass();
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = (a == null ? (a = JasperCompileManager.a("net.sf.jasperreports.engine.JasperCompileManager")) : a).getClassLoader();
            try {
                clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Report compiler class not found : " + string);
            }
        }
        try {
            jRCompiler = (JRCompiler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JRException("Could not instantiate report compiler : " + string, exception);
        }
        return jRCompiler;
    }

    private static JRCompiler getCompiler(JasperDesign jasperDesign) throws JRException {
        Object object;
        JRCompiler jRCompiler = null;
        String string = JRProperties.getProperty("net.sf.jasperreports.compiler.class");
        if (string == null || string.trim().length() == 0) {
            object = jasperDesign.getLanguage();
            string = JRProperties.getProperty("net.sf.jasperreports.compiler." + (String)object);
            if (string == null || string.trim().length() == 0) {
                if ("java".equals(object)) {
                    return JasperCompileManager.getJavaCompiler();
                }
                throw new JRException("No report compiler set for language : " + (String)object);
            }
        }
        try {
            object = JRClassLoader.loadClassForName(string);
            jRCompiler = (JRCompiler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new JRException("Could not instantiate report compiler : " + string, exception);
        }
        return jRCompiler;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

