/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRPrintImageArea {
    public static final byte SHAPE_DEFAULT = 0;
    public static final byte SHAPE_RECTANGLE = 1;
    public static final byte SHAPE_CIRCLE = 2;
    public static final byte SHAPE_POLYGON = 3;
    public static final String SHAPE_HTML_DEFAULT = "default";
    public static final String SHAPE_HTML_RECTANGLE = "rect";
    public static final String SHAPE_HTML_CIRCLE = "circle";
    public static final String SHAPE_HTML_POLYGON = "poly";
    private static final Map htmlShapes = new HashMap();
    private byte shape = 0;
    private int[] coordinates;
    private transient Shape cachedAWTShape;

    public static byte getShape(String string) {
        Byte by2 = (Byte)htmlShapes.get(string.toLowerCase());
        if (by2 == null) {
            throw new JRRuntimeException("Unknown HTML image area shape \"" + string + "\"");
        }
        return by2;
    }

    public static String getHtmlShape(byte by2) {
        String string;
        switch (by2) {
            case 0: {
                string = SHAPE_HTML_DEFAULT;
                break;
            }
            case 1: {
                string = SHAPE_HTML_RECTANGLE;
                break;
            }
            case 2: {
                string = SHAPE_HTML_CIRCLE;
                break;
            }
            case 3: {
                string = SHAPE_HTML_POLYGON;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown image area shape " + by2 + "");
            }
        }
        return string;
    }

    public byte getShape() {
        return this.shape;
    }

    public void setShape(byte by2) {
        this.shape = by2;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(int[] nArray) {
        this.coordinates = nArray;
    }

    public boolean containsPoint(int n2, int n3) {
        boolean bl2;
        if (this.hasAWTShape()) {
            this.ensureAWTShape();
            bl2 = this.cachedAWTShape.contains(n2, n3);
        } else {
            bl2 = true;
        }
        return bl2;
    }

    public void ensureAWTShape() {
        if (this.cachedAWTShape == null) {
            this.cachedAWTShape = this.createAWTShape();
        }
    }

    public boolean hasAWTShape() {
        return this.shape != 0;
    }

    public Shape createAWTShape() {
        Shape shape;
        switch (this.shape) {
            case 1: {
                shape = this.createAWTRectangle();
                break;
            }
            case 2: {
                shape = this.createAWTCircle();
                break;
            }
            case 3: {
                shape = this.createAWTPolygon();
                break;
            }
            default: {
                shape = null;
            }
        }
        return shape;
    }

    public Shape createAWTRectangle() {
        if (this.coordinates == null || this.coordinates.length != 4) {
            throw new JRRuntimeException("A rectangle must have exactly 4 coordinates");
        }
        return new Rectangle(this.coordinates[0], this.coordinates[1], this.coordinates[2] - this.coordinates[0], this.coordinates[3] - this.coordinates[1]);
    }

    private Shape createAWTCircle() {
        if (this.coordinates == null || this.coordinates.length != 3) {
            throw new JRRuntimeException("A circle must have exactly 4 coordinates");
        }
        return new Ellipse2D.Float(this.coordinates[0], this.coordinates[1], this.coordinates[2], this.coordinates[2]);
    }

    private Shape createAWTPolygon() {
        int n2;
        if (this.coordinates == null || this.coordinates.length == 0 || this.coordinates.length % 2 != 0) {
            throw new JRRuntimeException("A polygon must have an even number of coordinates");
        }
        Polygon polygon = new Polygon();
        for (n2 = 0; n2 < this.coordinates.length - 2; n2 += 2) {
            polygon.addPoint(this.coordinates[n2], this.coordinates[n2 + 1]);
        }
        if (this.coordinates[n2] != this.coordinates[0] || this.coordinates[n2 + 1] != this.coordinates[1]) {
            polygon.addPoint(this.coordinates[n2], this.coordinates[n2 + 1]);
        }
        return polygon;
    }

    static {
        htmlShapes.put(SHAPE_HTML_DEFAULT, new Byte(0));
        htmlShapes.put(SHAPE_HTML_RECTANGLE, new Byte(1));
        htmlShapes.put(SHAPE_HTML_CIRCLE, new Byte(2));
        htmlShapes.put(SHAPE_HTML_POLYGON, new Byte(3));
    }
}

