/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRAbstractExporter
implements JRExporter {
    private ParameterResolver parameterResolver;
    public Map parameters = new HashMap();
    public List jasperPrintList = null;
    public JasperPrint jasperPrint = null;
    public boolean isModeBatch = true;
    public int startPageIndex = 0;
    public int endPageIndex = 0;
    public int globalOffsetX = 0;
    public int globalOffsetY = 0;
    public ClassLoader classLoader = null;
    public boolean classLoaderSet = false;
    public URLStreamHandlerFactory urlHandlerFactory = null;
    public boolean urlHandlerFactorySet = false;
    public ExporterFilter filter = null;
    private LinkedList elementOffsetStack = new LinkedList();
    private int elementOffsetX = this.globalOffsetX;
    private int elementOffsetY = this.globalOffsetY;
    public Map dateFormatCache = new HashMap();
    public Map numberFormatCache = new HashMap();
    public static Class j;
    public static Class d;
    public static Class k;
    public static Class c;
    public static Class g;
    public static Class i;
    public static Class e;
    public static Class f;
    public static Class a;
    public static Class h;
    public static Class b;

    public void reset() {
        this.parameters = new HashMap();
        this.elementOffsetStack = new LinkedList();
    }

    public void setParameter(JRExporterParameter jRExporterParameter, Object object) {
        this.parameters.put(jRExporterParameter, object);
    }

    public Object getParameter(JRExporterParameter jRExporterParameter) {
        return this.parameters.get(jRExporterParameter);
    }

    public void setParameters(Map map) {
        this.parameters = map;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public ParameterResolver getParameterResolver() {
        if (this.parameterResolver == null) {
            Boolean bl2 = (Boolean)this.parameters.get(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS);
            boolean bl3 = bl2 == null ? JRProperties.getBooleanProperty("net.sf.jasperreports.export.parameters.override.report.hints") : bl2;
            this.parameterResolver = bl3 ? new ParameterOverrideResolver(this) : new ParameterOverriddenResolver(this);
        }
        return this.parameterResolver;
    }

    public String getStringParameter(JRExporterParameter jRExporterParameter, String string) {
        return this.getParameterResolver().getStringParameter(jRExporterParameter, string);
    }

    public String getStringParameterOrDefault(JRExporterParameter jRExporterParameter, String string) {
        return this.getParameterResolver().getStringParameterOrDefault(jRExporterParameter, string);
    }

    public boolean getBooleanParameter(JRExporterParameter jRExporterParameter, String string, boolean bl2) {
        return this.getParameterResolver().getBooleanParameter(jRExporterParameter, string, bl2);
    }

    public int getIntegerParameter(JRExporterParameter jRExporterParameter, String string, int n2) {
        return this.getParameterResolver().getIntegerParameter(jRExporterParameter, string, n2);
    }

    public abstract void exportReport() throws JRException;

    public void setOffset() {
        this.setOffset(true);
    }

    public void setOffset(boolean bl2) {
        Integer n2 = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        this.globalOffsetX = n2 != null ? n2 : 0;
        Integer n3 = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y);
        this.globalOffsetY = n3 != null ? n3 : 0;
        if (bl2) {
            this.elementOffsetX = this.globalOffsetX;
            this.elementOffsetY = this.globalOffsetY;
        }
    }

    public void setExportContext() {
        this.classLoaderSet = false;
        this.urlHandlerFactorySet = false;
        this.classLoader = (ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER);
        if (this.classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(this.classLoader);
            this.classLoaderSet = true;
        }
        this.urlHandlerFactory = (URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY);
        if (this.urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
            this.urlHandlerFactorySet = true;
        }
    }

    public void resetExportContext() {
        if (this.classLoaderSet) {
            JRResourcesUtil.resetClassLoader();
        }
        if (this.urlHandlerFactorySet) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
    }

    public void setClassLoader() {
        this.setExportContext();
    }

    public void resetClassLoader() {
        this.resetExportContext();
    }

    public void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream inputStream = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (inputStream != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
                } else {
                    URL uRL = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (uRL != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(uRL);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String string = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (string != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(string);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
        this.filter = (ExporterFilter)this.parameters.get(JRExporterParameter.FILTER);
    }

    public void setPageRange() throws JRException {
        Integer n2;
        int n3 = -1;
        if (this.jasperPrint.getPages() != null) {
            n3 = this.jasperPrint.getPages().size() - 1;
        }
        if ((n2 = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = n2;
            if (this.startPageIndex < 0 || this.startPageIndex > n3) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + n3);
            }
        }
        Integer n4 = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (n4 == null) {
            this.endPageIndex = n3;
        } else {
            this.endPageIndex = n4;
            if (this.endPageIndex < this.startPageIndex || this.endPageIndex > n3) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " (" + this.startPageIndex + " : " + n3 + ")");
            }
        }
        Integer n5 = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (n5 != null) {
            int n6 = n5;
            if (n6 < 0 || n6 > n3) {
                throw new JRException("Page index out of range : " + n6 + " of " + n3);
            }
            this.startPageIndex = n6;
            this.endPageIndex = n6;
        }
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText, boolean bl2) {
        return jRPrintText.getStyledText(bl2 ? JRStyledTextAttributeSelector.ALL : JRStyledTextAttributeSelector.NO_BACKCOLOR);
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText) {
        return this.getStyledText(jRPrintText, true);
    }

    public void setOutput() {
    }

    public int getOffsetX() {
        return this.elementOffsetX;
    }

    public int getOffsetY() {
        return this.elementOffsetY;
    }

    public void setFrameElementsOffset(JRPrintFrame jRPrintFrame, boolean bl2) {
        if (bl2) {
            this.setElementOffsets(0, 0);
        } else {
            int n2 = jRPrintFrame.getLineBox().getTopPadding();
            int n3 = jRPrintFrame.getLineBox().getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + jRPrintFrame.getX() + n3, this.getOffsetY() + jRPrintFrame.getY() + n2);
        }
    }

    private void setElementOffsets(int n2, int n3) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = n2;
        this.elementOffsetY = n3;
    }

    public void restoreElementOffsets() {
        int[] nArray = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = nArray[0];
        this.elementOffsetY = nArray[1];
    }

    public String getTextFormatFactoryClass(JRPrintText jRPrintText) {
        String string = jRPrintText.getFormatFactoryClass();
        if (string == null) {
            string = this.jasperPrint.getFormatFactoryClass();
        }
        return string;
    }

    public Locale getTextLocale(JRPrintText jRPrintText) {
        String string = jRPrintText.getLocaleCode();
        if (string == null) {
            string = this.jasperPrint.getLocaleCode();
        }
        return string == null ? null : JRDataUtils.getLocale(string);
    }

    public TimeZone getTextTimeZone(JRPrintText jRPrintText) {
        String string = jRPrintText.getTimeZoneId();
        if (string == null) {
            string = this.jasperPrint.getTimeZoneId();
        }
        return string == null ? null : JRDataUtils.getTimeZone(string);
    }

    public TextValue getTextValue(JRPrintText jRPrintText, String string) {
        TextValue textValue;
        if (jRPrintText.getValueClassName() == null) {
            textValue = this.getTextValueString(jRPrintText, string);
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForRealName(jRPrintText.getValueClassName());
                textValue = (j == null ? (j = JRAbstractExporter.a("java.lang.Number")) : j).isAssignableFrom(clazz) ? this.getNumberCellValue(jRPrintText, string) : ((d == null ? (d = JRAbstractExporter.a("java.util.Date")) : d).isAssignableFrom(clazz) ? this.getDateCellValue(jRPrintText, string) : ((k == null ? (k = JRAbstractExporter.a("java.lang.Boolean")) : k).equals(clazz) ? this.getBooleanCellValue(jRPrintText, string) : this.getTextValueString(jRPrintText, string)));
            }
            catch (ParseException parseException) {
                textValue = this.getTextValueString(jRPrintText, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                textValue = this.getTextValueString(jRPrintText, string);
            }
        }
        return textValue;
    }

    public TextValue getTextValueString(JRPrintText jRPrintText, String string) {
        return new StringTextValue(string);
    }

    public TextValue getBooleanCellValue(JRPrintText jRPrintText, String string) {
        Boolean bl2 = null;
        if (string != null || string.length() > 0) {
            bl2 = Boolean.valueOf(string);
        }
        return new BooleanTextValue(string, bl2);
    }

    public TextValue getDateCellValue(JRPrintText jRPrintText, String string) throws ParseException {
        TextValue textValue;
        String string2 = jRPrintText.getPattern();
        if (string2 == null || string2.trim().length() == 0) {
            textValue = this.getTextValueString(jRPrintText, string);
        } else {
            DateFormat dateFormat = this.getDateFormat(this.getTextFormatFactoryClass(jRPrintText), string2, this.getTextLocale(jRPrintText), this.getTextTimeZone(jRPrintText));
            Date date = null;
            if (string != null && string.length() > 0) {
                date = dateFormat.parse(string);
            }
            textValue = new DateTextValue(string, date, string2);
        }
        return textValue;
    }

    public TextValue getNumberCellValue(JRPrintText jRPrintText, String string) throws ParseException, ClassNotFoundException {
        TextValue textValue;
        String string2 = jRPrintText.getPattern();
        if (string2 == null || string2.trim().length() == 0) {
            Number number;
            textValue = string != null && string.length() > 0 ? ((number = this.defaultParseNumber(string, JRClassLoader.loadClassForRealName(jRPrintText.getValueClassName()))) != null ? new NumberTextValue(string, number, null) : this.getTextValueString(jRPrintText, string)) : new NumberTextValue(string, null, null);
        } else {
            NumberFormat numberFormat = this.getNumberFormat(this.getTextFormatFactoryClass(jRPrintText), string2, this.getTextLocale(jRPrintText));
            Number number = null;
            if (string != null && string.length() > 0) {
                number = numberFormat.parse(string);
            }
            textValue = new NumberTextValue(string, number, string2);
        }
        return textValue;
    }

    public Number defaultParseNumber(String string, Class clazz) {
        Number number = null;
        try {
            if (clazz.equals(c == null ? (c = JRAbstractExporter.a("java.lang.Byte")) : c)) {
                number = Byte.valueOf(string);
            } else if (clazz.equals(g == null ? (g = JRAbstractExporter.a("java.lang.Short")) : g)) {
                number = Short.valueOf(string);
            } else if (clazz.equals(i == null ? (i = JRAbstractExporter.a("java.lang.Integer")) : i)) {
                number = Integer.valueOf(string);
            } else if (clazz.equals(e == null ? (e = JRAbstractExporter.a("java.lang.Long")) : e)) {
                number = Long.valueOf(string);
            } else if (clazz.equals(f == null ? (f = JRAbstractExporter.a("java.lang.Float")) : f)) {
                number = Float.valueOf(string);
            } else if (clazz.equals(a == null ? (a = JRAbstractExporter.a("java.lang.Double")) : a)) {
                number = Double.valueOf(string);
            } else if (clazz.equals(h == null ? (h = JRAbstractExporter.a("java.math.BigInteger")) : h)) {
                number = new BigInteger(string);
            } else if (clazz.equals(b == null ? (b = JRAbstractExporter.a("java.math.BigDecimal")) : b)) {
                number = new BigDecimal(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    public DateFormat getDateFormat(String string, String string2, Locale locale, TimeZone timeZone) {
        String string3 = string + "|" + string2 + "|" + JRDataUtils.getLocaleCode(locale) + "|" + JRDataUtils.getTimeZoneId(timeZone);
        DateFormat dateFormat = (DateFormat)this.dateFormatCache.get(string3);
        if (dateFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(string);
            dateFormat = formatFactory.createDateFormat(string2, locale, timeZone);
            this.dateFormatCache.put(string3, dateFormat);
        }
        return dateFormat;
    }

    public NumberFormat getNumberFormat(String string, String string2, Locale locale) {
        String string3 = string + "|" + string2 + "|" + JRDataUtils.getLocaleCode(locale);
        NumberFormat numberFormat = (NumberFormat)this.numberFormatCache.get(string3);
        if (numberFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(string);
            numberFormat = formatFactory.createNumberFormat(string2, locale);
            this.dateFormatCache.put(string3, numberFormat);
        }
        return numberFormat;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ParameterOverriddenResolver
    implements ParameterResolver {
        private final JRAbstractExporter this$0;

        public ParameterOverriddenResolver(JRAbstractExporter jRAbstractExporter) {
            this.this$0 = jRAbstractExporter;
        }

        public String getStringParameter(JRExporterParameter jRExporterParameter, String string) {
            String string2;
            JRPropertiesMap jRPropertiesMap = this.this$0.jasperPrint.getPropertiesMap();
            if (jRPropertiesMap != null && jRPropertiesMap.containsProperty(string)) {
                string2 = jRPropertiesMap.getProperty(string);
            } else {
                string2 = (String)this.this$0.parameters.get(jRExporterParameter);
                if (string2 == null) {
                    string2 = JRProperties.getProperty(string);
                }
            }
            return string2;
        }

        public String getStringParameterOrDefault(JRExporterParameter jRExporterParameter, String string) {
            JRPropertiesMap jRPropertiesMap = this.this$0.jasperPrint.getPropertiesMap();
            String string2 = jRPropertiesMap != null && jRPropertiesMap.containsProperty(string) ? jRPropertiesMap.getProperty(string) : (String)this.this$0.parameters.get(jRExporterParameter);
            if (string2 == null) {
                string2 = JRProperties.getProperty(string);
            }
            return string2;
        }

        public boolean getBooleanParameter(JRExporterParameter jRExporterParameter, String string, boolean bl2) {
            Boolean bl3;
            String string2;
            JRPropertiesMap jRPropertiesMap = this.this$0.jasperPrint.getPropertiesMap();
            boolean bl4 = jRPropertiesMap != null && jRPropertiesMap.containsProperty(string) ? ((string2 = jRPropertiesMap.getProperty(string)) == null ? JRProperties.getBooleanProperty(string) : JRProperties.asBoolean(string2)) : ((bl3 = (Boolean)this.this$0.parameters.get(jRExporterParameter)) == null ? JRProperties.getBooleanProperty(string) : bl3);
            return bl4;
        }

        public int getIntegerParameter(JRExporterParameter jRExporterParameter, String string, int n2) {
            Integer n3;
            String string2;
            JRPropertiesMap jRPropertiesMap = this.this$0.jasperPrint.getPropertiesMap();
            int n4 = jRPropertiesMap != null && jRPropertiesMap.containsProperty(string) ? ((string2 = jRPropertiesMap.getProperty(string)) == null ? JRProperties.getIntegerProperty(string) : JRProperties.asInteger(string2)) : ((n3 = (Integer)this.this$0.parameters.get(jRExporterParameter)) == null ? JRProperties.getIntegerProperty(string) : n3);
            return n4;
        }
    }

    protected class ParameterOverrideResolver
    implements ParameterResolver {
        private final JRAbstractExporter this$0;

        public ParameterOverrideResolver(JRAbstractExporter jRAbstractExporter) {
            this.this$0 = jRAbstractExporter;
        }

        public String getStringParameter(JRExporterParameter jRExporterParameter, String string) {
            if (this.this$0.parameters.containsKey(jRExporterParameter)) {
                return (String)this.this$0.parameters.get(jRExporterParameter);
            }
            return JRProperties.getProperty(this.this$0.jasperPrint.getPropertiesMap(), string);
        }

        public String getStringParameterOrDefault(JRExporterParameter jRExporterParameter, String string) {
            if (this.this$0.parameters.containsKey(jRExporterParameter)) {
                String string2 = (String)this.this$0.parameters.get(jRExporterParameter);
                if (string2 == null) {
                    return JRProperties.getProperty(string);
                }
                return string2;
            }
            return JRProperties.getProperty(this.this$0.jasperPrint.getPropertiesMap(), string);
        }

        public boolean getBooleanParameter(JRExporterParameter jRExporterParameter, String string, boolean bl2) {
            if (this.this$0.parameters.containsKey(jRExporterParameter)) {
                Boolean bl3 = (Boolean)this.this$0.parameters.get(jRExporterParameter);
                if (bl3 == null) {
                    return JRProperties.getBooleanProperty(string);
                }
                return bl3;
            }
            return JRProperties.getBooleanProperty(this.this$0.jasperPrint.getPropertiesMap(), string, bl2);
        }

        public int getIntegerParameter(JRExporterParameter jRExporterParameter, String string, int n2) {
            if (this.this$0.parameters.containsKey(jRExporterParameter)) {
                Integer n3 = (Integer)this.this$0.parameters.get(jRExporterParameter);
                if (n3 == null) {
                    return JRProperties.getIntegerProperty(string);
                }
                return n3;
            }
            return JRProperties.getIntegerProperty(this.this$0.jasperPrint.getPropertiesMap(), string, n2);
        }
    }

    protected static interface ParameterResolver {
        public String getStringParameter(JRExporterParameter var1, String var2);

        public String getStringParameterOrDefault(JRExporterParameter var1, String var2);

        public boolean getBooleanParameter(JRExporterParameter var1, String var2, boolean var3);

        public int getIntegerParameter(JRExporterParameter var1, String var2, int var3);
    }
}

