/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.collections.SequencedHashMap;

public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_COLUMN_BREAK_OFFSET = "columnBreakOffset";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_HEADER_CELL = "headerCell";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_REPEAT_COLUMN_HEADERS = "repeatColumnHeaders";
    public static final String PROPERTY_REPEAT_ROW_HEADERS = "repeatRowHeaders";
    public static final String PROPERTY_WHEN_NO_DATA_CELL = "whenNoDataCell";
    public static final String PROPERTY_CELLS = "cells";
    public static final String PROPERTY_ROW_GROUPS = "rowGroups";
    public static final String PROPERTY_COLUMN_GROUPS = "columnGroups";
    public static final String PROPERTY_MEASURES = "measures";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public List parametersList;
    public Map parametersMap;
    public SequencedHashMap variablesList;
    public JRExpression parametersMapExpression;
    public JRDesignCrosstabDataset dataset;
    public List rowGroups;
    public List columnGroups;
    public List measures;
    public Map rowGroupsMap;
    public Map columnGroupsMap;
    public Map measuresMap;
    public int columnBreakOffset = 10;
    public boolean repeatColumnHeaders = true;
    public boolean repeatRowHeaders = true;
    public byte runDirection;
    public List cellsList;
    public Map cellsMap;
    public JRDesignCrosstabCell[][] crossCells;
    public JRDesignCellContents whenNoDataCell;
    public JRDesignCellContents headerCell;
    private PropertyChangeListener measureClassChangeListener = new MeasureClassChangeListener(this, null);
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", h == null ? (h = JRDesignCrosstab.a("java.util.Map")) : h, "REPORT_LOCALE", c == null ? (c = JRDesignCrosstab.a("java.util.Locale")) : c, "REPORT_RESOURCE_BUNDLE", a == null ? (a = JRDesignCrosstab.a("java.util.ResourceBundle")) : a, "REPORT_TIME_ZONE", b == null ? (b = JRDesignCrosstab.a("java.util.TimeZone")) : b, "REPORT_FORMAT_FACTORY", d == null ? (d = JRDesignCrosstab.a("net.sf.jasperreports.engine.util.FormatFactory")) : d, "REPORT_CLASS_LOADER", g == null ? (g = JRDesignCrosstab.a("java.lang.ClassLoader")) : g, "REPORT_URL_HANDLER_FACTORY", f == null ? (f = JRDesignCrosstab.a("java.net.URLStreamHandlerFactory")) : f};
    private static final Object[] BUILT_IN_VARIABLES = new Object[]{"ROW_COUNT", e == null ? (e = JRDesignCrosstab.a("java.lang.Integer")) : e, "COLUMN_COUNT", e == null ? (e = JRDesignCrosstab.a("java.lang.Integer")) : e};
    public static Class h;
    public static Class c;
    public static Class a;
    public static Class b;
    public static Class d;
    public static Class g;
    public static Class f;
    public static Class e;

    public JRDesignCrosstab(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
        this.parametersList = new ArrayList();
        this.parametersMap = new HashMap();
        this.rowGroupsMap = new HashMap();
        this.rowGroups = new ArrayList();
        this.columnGroupsMap = new HashMap();
        this.columnGroups = new ArrayList();
        this.measuresMap = new HashMap();
        this.measures = new ArrayList();
        this.cellsMap = new HashMap();
        this.cellsList = new ArrayList();
        this.addBuiltinParameters();
        this.variablesList = new SequencedHashMap();
        this.addBuiltinVariables();
        this.dataset = new JRDesignCrosstabDataset();
    }

    private void addBuiltinParameters() {
        for (int i2 = 0; i2 < BUILT_IN_PARAMETERS.length; ++i2) {
            JRDesignCrosstabParameter jRDesignCrosstabParameter = new JRDesignCrosstabParameter();
            jRDesignCrosstabParameter.setName((String)BUILT_IN_PARAMETERS[i2++]);
            jRDesignCrosstabParameter.setValueClass((Class)BUILT_IN_PARAMETERS[i2]);
            jRDesignCrosstabParameter.setSystemDefined(true);
            try {
                this.addParameter(jRDesignCrosstabParameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private void addBuiltinVariables() {
        for (int i2 = 0; i2 < BUILT_IN_VARIABLES.length; ++i2) {
            JRDesignVariable jRDesignVariable = new JRDesignVariable();
            jRDesignVariable.setName((String)BUILT_IN_VARIABLES[i2]);
            jRDesignVariable.setValueClass((Class)BUILT_IN_VARIABLES[++i2]);
            jRDesignVariable.setCalculation((byte)8);
            jRDesignVariable.setSystemDefined(true);
            this.addVariable(jRDesignVariable);
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    public int getId() {
        return 0;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(jRCrosstabRowGroupArray);
        return jRCrosstabRowGroupArray;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(jRCrosstabColumnGroupArray);
        return jRCrosstabColumnGroupArray;
    }

    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(jRCrosstabMeasureArray);
        return jRCrosstabMeasureArray;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitCrosstab(this);
    }

    public void setDataset(JRDesignCrosstabDataset jRDesignCrosstabDataset) {
        JRDesignCrosstabDataset jRDesignCrosstabDataset2 = this.dataset;
        this.dataset = jRDesignCrosstabDataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, jRDesignCrosstabDataset2, this.dataset);
    }

    public void addRowGroup(JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup) throws JRException {
        String string = jRDesignCrosstabRowGroup.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(string, new Integer(this.rowGroups.size()));
        this.rowGroups.add(jRDesignCrosstabRowGroup);
        this.addRowGroupVars(jRDesignCrosstabRowGroup);
        this.setParent(jRDesignCrosstabRowGroup);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ROW_GROUPS, jRDesignCrosstabRowGroup, this.rowGroups.size() - 1);
    }

    public void addRowGroupVars(JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup) {
        this.addVariable(jRDesignCrosstabRowGroup.getVariable());
        Iterator iterator = this.measures.iterator();
        while (iterator.hasNext()) {
            JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)iterator.next();
            this.addTotalVar(jRCrosstabMeasure, jRDesignCrosstabRowGroup, null);
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabColumnGroup jRCrosstabColumnGroup = (JRCrosstabColumnGroup)iterator2.next();
                this.addTotalVar(jRCrosstabMeasure, jRDesignCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup) throws JRException {
        String string = jRDesignCrosstabColumnGroup.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(string, new Integer(this.columnGroups.size()));
        this.columnGroups.add(jRDesignCrosstabColumnGroup);
        this.addColGroupVars(jRDesignCrosstabColumnGroup);
        this.setParent(jRDesignCrosstabColumnGroup);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMN_GROUPS, jRDesignCrosstabColumnGroup, this.columnGroups.size() - 1);
    }

    public void addColGroupVars(JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup) {
        this.addVariable(jRDesignCrosstabColumnGroup.getVariable());
        Iterator iterator = this.measures.iterator();
        while (iterator.hasNext()) {
            JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)iterator.next();
            this.addTotalVar(jRCrosstabMeasure, null, jRDesignCrosstabColumnGroup);
            Iterator iterator2 = this.rowGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabRowGroup jRCrosstabRowGroup = (JRCrosstabRowGroup)iterator2.next();
                this.addTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRDesignCrosstabColumnGroup);
            }
        }
    }

    public void addMeasure(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) throws JRException {
        String string = jRDesignCrosstabMeasure.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        jRDesignCrosstabMeasure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(string, new Integer(this.measures.size()));
        this.measures.add(jRDesignCrosstabMeasure);
        this.addMeasureVars(jRDesignCrosstabMeasure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, jRDesignCrosstabMeasure, this.measures.size() - 1);
    }

    public void addMeasureVars(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) {
        JRCrosstabGroup jRCrosstabGroup;
        this.addVariable(jRDesignCrosstabMeasure.getVariable());
        Iterator iterator = this.columnGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabColumnGroup)iterator.next();
            this.addTotalVar(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup);
        }
        iterator = this.rowGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabRowGroup)iterator.next();
            this.addTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null);
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabColumnGroup jRCrosstabColumnGroup = (JRCrosstabColumnGroup)iterator2.next();
                this.addTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public void addTotalVar(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setCalculation((byte)8);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setName(JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup));
        jRDesignVariable.setValueClassName(jRCrosstabMeasure.getValueClassName());
        this.addVariable(jRDesignVariable);
    }

    public void removeTotalVar(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        String string = JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
        this.removeVariable(string);
    }

    public static String getTotalVariableName(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(jRCrosstabMeasure.getName());
        if (jRCrosstabRowGroup != null) {
            stringBuffer.append('_');
            stringBuffer.append(jRCrosstabRowGroup.getName());
        }
        if (jRCrosstabColumnGroup != null) {
            stringBuffer.append('_');
            stringBuffer.append(jRCrosstabColumnGroup.getName());
        }
        stringBuffer.append("_ALL");
        return stringBuffer.toString();
    }

    public JRCrosstabRowGroup removeRowGroup(String string) {
        JRCrosstabRowGroup jRCrosstabRowGroup = null;
        Integer n2 = (Integer)this.rowGroupsMap.remove(string);
        if (n2 != null) {
            JRCloneable jRCloneable;
            jRCrosstabRowGroup = (JRCrosstabRowGroup)this.rowGroups.remove(n2);
            Iterator iterator = this.rowGroups.listIterator(n2);
            while (iterator.hasNext()) {
                jRCloneable = (JRCrosstabRowGroup)iterator.next();
                this.rowGroupsMap.put(jRCloneable.getName(), new Integer(iterator.previousIndex()));
            }
            iterator = this.cellsList.iterator();
            while (iterator.hasNext()) {
                jRCloneable = (JRCrosstabCell)iterator.next();
                String string2 = jRCloneable.getRowTotalGroup();
                if (string2 == null || !string2.equals(string)) continue;
                iterator.remove();
                this.cellsMap.remove(new Pair(string2, jRCloneable.getColumnTotalGroup()));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, jRCloneable, -1);
            }
            this.removeRowGroupVars(jRCrosstabRowGroup);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ROW_GROUPS, jRCrosstabRowGroup, n2);
        }
        return jRCrosstabRowGroup;
    }

    public void removeRowGroupVars(JRCrosstabRowGroup jRCrosstabRowGroup) {
        this.removeVariable(jRCrosstabRowGroup.getVariable());
        Iterator iterator = this.measures.iterator();
        while (iterator.hasNext()) {
            JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)iterator.next();
            this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, null);
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabColumnGroup jRCrosstabColumnGroup = (JRCrosstabColumnGroup)iterator2.next();
                this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) {
        return this.removeRowGroup(jRCrosstabRowGroup.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String string) {
        JRCrosstabColumnGroup jRCrosstabColumnGroup = null;
        Integer n2 = (Integer)this.columnGroupsMap.remove(string);
        if (n2 != null) {
            JRCloneable jRCloneable;
            jRCrosstabColumnGroup = (JRCrosstabColumnGroup)this.columnGroups.remove(n2);
            Iterator iterator = this.columnGroups.listIterator(n2);
            while (iterator.hasNext()) {
                jRCloneable = (JRCrosstabColumnGroup)iterator.next();
                this.columnGroupsMap.put(jRCloneable.getName(), new Integer(iterator.previousIndex()));
            }
            iterator = this.cellsList.iterator();
            while (iterator.hasNext()) {
                jRCloneable = (JRCrosstabCell)iterator.next();
                String string2 = jRCloneable.getColumnTotalGroup();
                if (string2 == null || !string2.equals(string)) continue;
                iterator.remove();
                this.cellsMap.remove(new Pair(jRCloneable.getRowTotalGroup(), string2));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, jRCloneable, -1);
            }
            this.removeColGroupVars(jRCrosstabColumnGroup);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMN_GROUPS, jRCrosstabColumnGroup, n2);
        }
        return jRCrosstabColumnGroup;
    }

    public void removeColGroupVars(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        this.removeVariable(jRCrosstabColumnGroup.getVariable());
        Iterator iterator = this.measures.iterator();
        while (iterator.hasNext()) {
            JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)iterator.next();
            this.removeTotalVar(jRCrosstabMeasure, null, jRCrosstabColumnGroup);
            Iterator iterator2 = this.rowGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabRowGroup jRCrosstabRowGroup = (JRCrosstabRowGroup)iterator2.next();
                this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        return this.removeColumnGroup(jRCrosstabColumnGroup.getName());
    }

    public JRCrosstabMeasure removeMeasure(String string) {
        JRDesignCrosstabMeasure jRDesignCrosstabMeasure = null;
        Integer n2 = (Integer)this.measuresMap.remove(string);
        if (n2 != null) {
            jRDesignCrosstabMeasure = (JRDesignCrosstabMeasure)this.measures.remove(n2);
            ListIterator listIterator = this.measures.listIterator(n2);
            while (listIterator.hasNext()) {
                JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)listIterator.next();
                this.measuresMap.put(jRCrosstabMeasure.getName(), new Integer(listIterator.previousIndex()));
            }
            this.removeMeasureVars(jRDesignCrosstabMeasure);
            jRDesignCrosstabMeasure.removePropertyChangeListener("valueClassName", this.measureClassChangeListener);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MEASURES, jRDesignCrosstabMeasure, n2);
        }
        return jRDesignCrosstabMeasure;
    }

    public void removeMeasureVars(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) {
        JRCrosstabGroup jRCrosstabGroup;
        this.removeVariable(jRDesignCrosstabMeasure.getVariable());
        Iterator iterator = this.columnGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabColumnGroup)iterator.next();
            this.removeTotalVar(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup);
        }
        iterator = this.rowGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabRowGroup)iterator.next();
            this.removeTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null);
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabColumnGroup jRCrosstabColumnGroup = (JRCrosstabColumnGroup)iterator2.next();
                this.removeTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure jRCrosstabMeasure) {
        return this.removeMeasure(jRCrosstabMeasure.getName());
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean bl2) {
        boolean bl3 = this.repeatColumnHeaders;
        this.repeatColumnHeaders = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_COLUMN_HEADERS, bl3, this.repeatColumnHeaders);
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean bl2) {
        boolean bl3 = this.repeatRowHeaders;
        this.repeatRowHeaders = bl2;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_ROW_HEADERS, bl3, this.repeatRowHeaders);
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List getCellsList() {
        return this.cellsList;
    }

    public void addCell(JRDesignCrosstabCell jRDesignCrosstabCell) throws JRException {
        String string = jRDesignCrosstabCell.getRowTotalGroup();
        if (string != null && !this.rowGroupsMap.containsKey(string)) {
            throw new JRException("Row group " + string + " does not exist.");
        }
        String string2 = jRDesignCrosstabCell.getColumnTotalGroup();
        if (string2 != null && !this.columnGroupsMap.containsKey(string2)) {
            throw new JRException("Row group " + string2 + " does not exist.");
        }
        Pair pair = new Pair(string, string2);
        if (this.cellsMap.containsKey(pair)) {
            throw new JRException("Duplicate cell in crosstab.");
        }
        this.cellsMap.put(pair, jRDesignCrosstabCell);
        this.cellsList.add(jRDesignCrosstabCell);
        this.setCellOrigin(jRDesignCrosstabCell.getContents(), new JRCrosstabOrigin(this, 7, string, string2));
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CELLS, jRDesignCrosstabCell, this.cellsList.size() - 1);
    }

    public JRCrosstabCell removeCell(String string, String string2) {
        Pair pair = new Pair(string, string2);
        JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)this.cellsMap.remove(pair);
        if (jRCrosstabCell != null) {
            this.cellsList.remove(jRCrosstabCell);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, jRCrosstabCell, -1);
        }
        return jRCrosstabCell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell jRCrosstabCell) {
        return this.removeCell(jRCrosstabCell.getRowTotalGroup(), jRCrosstabCell.getColumnTotalGroup());
    }

    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] jRCrosstabParameterArray = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(jRCrosstabParameterArray);
        return jRCrosstabParameterArray;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter jRCrosstabParameter) throws JRException {
        if (this.parametersMap.containsKey(jRCrosstabParameter.getName()) && this.parametersMap.containsKey(jRCrosstabParameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + jRCrosstabParameter.getName());
        }
        this.parametersMap.put(jRCrosstabParameter.getName(), jRCrosstabParameter);
        this.parametersList.add(jRCrosstabParameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, jRCrosstabParameter, this.parametersList.size() - 1);
    }

    public JRCrosstabParameter removeParameter(String string) {
        JRCrosstabParameter jRCrosstabParameter = (JRCrosstabParameter)this.parametersMap.remove(string);
        if (jRCrosstabParameter != null) {
            int n2 = this.parametersList.indexOf(jRCrosstabParameter);
            if (n2 >= 0) {
                this.parametersList.remove(n2);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, jRCrosstabParameter, n2);
        }
        return jRCrosstabParameter;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter jRCrosstabParameter) {
        return this.removeParameter(jRCrosstabParameter.getName());
    }

    public void setParametersMapExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.parametersMapExpression;
        this.parametersMapExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, jRExpression2, this.parametersMapExpression);
    }

    public Map getVariablesMap() {
        JRVariable[] jRVariableArray = this.getVariables();
        HashMap<String, JRVariable> hashMap = new HashMap<String, JRVariable>();
        for (int i2 = 0; i2 < jRVariableArray.length; ++i2) {
            hashMap.put(jRVariableArray[i2].getName(), jRVariableArray[i2]);
        }
        return hashMap;
    }

    public JRVariable[] getVariables() {
        JRVariable[] jRVariableArray = new JRVariable[this.variablesList.size()];
        this.variablesList.values().toArray(jRVariableArray);
        return jRVariableArray;
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int n2) {
        int n3 = this.columnBreakOffset;
        this.columnBreakOffset = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_BREAK_OFFSET, n3, this.columnBreakOffset);
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    public void setGroupVariablesClass(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRExpression jRExpression;
            JRDesignCrosstabGroup jRDesignCrosstabGroup = (JRDesignCrosstabGroup)iterator.next();
            JRCrosstabBucket jRCrosstabBucket = jRDesignCrosstabGroup.getBucket();
            if (jRCrosstabBucket == null || (jRExpression = jRCrosstabBucket.getExpression()) == null) continue;
            jRDesignCrosstabGroup.designVariable.setValueClassName(jRExpression.getValueClassName());
        }
    }

    public void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        int n2 = this.calculateRowHeadersSizes();
        int n3 = this.calculateColumnHeadersSizes();
        if (this.headerCell != null) {
            this.headerCell.setWidth(n2);
            this.headerCell.setHeight(n3);
        }
    }

    public void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    public void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        Iterator iterator = this.cellsList.iterator();
        while (iterator.hasNext()) {
            int n2;
            String string;
            int n3;
            JRDesignCrosstabCell jRDesignCrosstabCell = (JRDesignCrosstabCell)iterator.next();
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
            String string2 = jRDesignCrosstabCell.getRowTotalGroup();
            n3 = string2 == null ? (n3 = this.rowGroups.size()) : (Integer)this.rowGroupsMap.get(string2);
            Integer n4 = jRDesignCrosstabCell.getWidth();
            if (n4 != null) {
                jRDesignCellContents.setWidth(n4);
            }
            n2 = (string = jRDesignCrosstabCell.getColumnTotalGroup()) == null ? (n2 = this.columnGroups.size()) : (Integer)this.columnGroupsMap.get(string);
            Integer n5 = jRDesignCrosstabCell.getHeight();
            if (n5 != null) {
                jRDesignCellContents.setHeight(n5);
            }
            this.crossCells[n3][n2] = jRDesignCrosstabCell;
        }
        this.inheritCells();
    }

    public JRDesignCrosstabRowGroup getRowGroup(int n2) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(n2);
    }

    public JRDesignCrosstabColumnGroup getColumnGroup(int n2) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(n2);
    }

    public void inheritCells() {
        for (int i2 = this.rowGroups.size(); i2 >= 0; --i2) {
            for (int i3 = this.columnGroups.size(); i3 >= 0; --i3) {
                boolean bl2;
                boolean bl3 = bl2 = !(i2 != this.rowGroups.size() && !this.getRowGroup(i2).hasTotal() || i3 != this.columnGroups.size() && !this.getColumnGroup(i3).hasTotal());
                if (bl2) {
                    if (this.crossCells[i2][i3] == null) {
                        this.inheritCell(i2, i3);
                        if (this.crossCells[i2][i3] != null) continue;
                        this.crossCells[i2][i3] = this.emptyCell(i2, i3);
                        this.inheritCellSize(i2, i3);
                        continue;
                    }
                    this.inheritCellSize(i2, i3);
                    continue;
                }
                this.crossCells[i2][i3] = null;
            }
        }
    }

    private JRDesignCrosstabCell emptyCell(int n2, int n3) {
        JRDesignCrosstabCell jRDesignCrosstabCell = new JRDesignCrosstabCell();
        if (n2 < this.rowGroups.size()) {
            jRDesignCrosstabCell.setRowTotalGroup(((JRCrosstabRowGroup)this.rowGroups.get(n2)).getName());
        }
        if (n3 < this.columnGroups.size()) {
            jRDesignCrosstabCell.setColumnTotalGroup(((JRCrosstabColumnGroup)this.columnGroups.get(n3)).getName());
        }
        return jRDesignCrosstabCell;
    }

    public void inheritCellSize(int n2, int n3) {
        JRDesignCrosstabCell jRDesignCrosstabCell;
        JRDesignCellContents jRDesignCellContents;
        block6: {
            block7: {
                JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[n2][n3];
                jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
                if (jRDesignCellContents.getWidth() != Integer.MIN_VALUE) break block6;
                if (n2 >= this.rowGroups.size()) break block7;
                jRDesignCrosstabCell = this.crossCells[this.rowGroups.size()][n3];
                if (jRDesignCrosstabCell == null) break block6;
                jRDesignCellContents.setWidth(jRDesignCrosstabCell.getContents().getWidth());
                break block6;
            }
            for (int i2 = n3 + 1; i2 <= this.columnGroups.size(); ++i2) {
                if (this.crossCells[n2][i2] == null) continue;
                jRDesignCellContents.setWidth(this.crossCells[n2][i2].getContents().getWidth());
                break;
            }
        }
        if (jRDesignCellContents.getHeight() == Integer.MIN_VALUE) {
            if (n3 < this.columnGroups.size()) {
                jRDesignCrosstabCell = this.crossCells[n2][this.columnGroups.size()];
                if (jRDesignCrosstabCell != null) {
                    jRDesignCellContents.setHeight(jRDesignCrosstabCell.getContents().getHeight());
                }
            } else {
                for (int i3 = n2 + 1; i3 <= this.rowGroups.size(); ++i3) {
                    if (this.crossCells[i3][n3] == null) continue;
                    jRDesignCellContents.setHeight(this.crossCells[i3][n3].getContents().getHeight());
                }
            }
        }
    }

    public void inheritCell(int n2, int n3) {
        JRDesignCellContents jRDesignCellContents;
        JRDesignCrosstabCell jRDesignCrosstabCell;
        int n4;
        JRDesignCellContents jRDesignCellContents2;
        JRDesignCrosstabCell jRDesignCrosstabCell2;
        JRDesignCrosstabCell jRDesignCrosstabCell3 = null;
        if (n3 < this.columnGroups.size()) {
            jRDesignCrosstabCell2 = this.crossCells[this.rowGroups.size()][n3];
            jRDesignCellContents2 = jRDesignCrosstabCell2 == null ? null : (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
            for (n4 = n3 + 1; jRDesignCrosstabCell3 == null && n4 <= this.columnGroups.size(); ++n4) {
                jRDesignCrosstabCell = this.crossCells[n2][n4];
                if (jRDesignCrosstabCell == null) continue;
                jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
                if (jRDesignCellContents2 != null && jRDesignCellContents.getWidth() != jRDesignCellContents2.getWidth()) continue;
                jRDesignCrosstabCell3 = jRDesignCrosstabCell;
            }
        }
        if (jRDesignCrosstabCell3 == null && n2 < this.rowGroups.size()) {
            jRDesignCrosstabCell2 = this.crossCells[n2][this.columnGroups.size()];
            jRDesignCellContents2 = jRDesignCrosstabCell2 == null ? null : (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
            for (n4 = n2 + 1; jRDesignCrosstabCell3 == null && n4 <= this.rowGroups.size(); ++n4) {
                jRDesignCrosstabCell = this.crossCells[n4][n3];
                if (jRDesignCrosstabCell == null) continue;
                jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
                if (jRDesignCellContents2 != null && jRDesignCellContents.getHeight() != jRDesignCellContents2.getHeight()) continue;
                jRDesignCrosstabCell3 = jRDesignCrosstabCell;
            }
        }
        this.crossCells[n2][n3] = jRDesignCrosstabCell3;
    }

    public int calculateRowHeadersSizes() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = this.rowGroups.size() - 1; i2 >= 0; --i2) {
            JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup = (JRDesignCrosstabRowGroup)this.rowGroups.get(i2);
            n2 += jRDesignCrosstabRowGroup.getWidth();
            JRDesignCrosstabCell jRDesignCrosstabCell = this.crossCells[i2 + 1][this.columnGroups.size()];
            if (jRDesignCrosstabCell != null) {
                n3 += jRDesignCrosstabCell.getContents().getHeight();
            }
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabRowGroup.getHeader();
            jRDesignCellContents.setHeight(n3);
            jRDesignCellContents.setWidth(jRDesignCrosstabRowGroup.getWidth());
            if (!jRDesignCrosstabRowGroup.hasTotal()) continue;
            JRDesignCellContents jRDesignCellContents2 = (JRDesignCellContents)jRDesignCrosstabRowGroup.getTotalHeader();
            jRDesignCellContents2.setWidth(n2);
            JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[i2][this.columnGroups.size()];
            if (jRDesignCrosstabCell2 == null) continue;
            jRDesignCellContents2.setHeight(jRDesignCrosstabCell2.getContents().getHeight());
        }
        return n2;
    }

    public int calculateColumnHeadersSizes() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = this.columnGroups.size() - 1; i2 >= 0; --i2) {
            JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i2);
            n2 += jRDesignCrosstabColumnGroup.getHeight();
            JRDesignCrosstabCell jRDesignCrosstabCell = this.crossCells[this.rowGroups.size()][i2 + 1];
            if (jRDesignCrosstabCell != null) {
                n3 += jRDesignCrosstabCell.getContents().getWidth();
            }
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabColumnGroup.getHeader();
            jRDesignCellContents.setHeight(jRDesignCrosstabColumnGroup.getHeight());
            jRDesignCellContents.setWidth(n3);
            if (!jRDesignCrosstabColumnGroup.hasTotal()) continue;
            JRDesignCellContents jRDesignCellContents2 = (JRDesignCellContents)jRDesignCrosstabColumnGroup.getTotalHeader();
            jRDesignCellContents2.setHeight(n2);
            JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[this.rowGroups.size()][i2];
            if (jRDesignCrosstabCell2 == null) continue;
            jRDesignCellContents2.setWidth(jRDesignCrosstabCell2.getContents().getWidth());
        }
        return n2;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents jRDesignCellContents) {
        JRDesignCellContents jRDesignCellContents2 = this.whenNoDataCell;
        this.whenNoDataCell = jRDesignCellContents;
        this.setCellOrigin(this.whenNoDataCell, new JRCrosstabOrigin(this, 2));
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_CELL, jRDesignCellContents2, this.whenNoDataCell);
    }

    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(JRDesignCellContents jRDesignCellContents) {
        JRDesignCellContents jRDesignCellContents2 = this.headerCell;
        this.headerCell = jRDesignCellContents;
        this.setCellOrigin(this.headerCell, new JRCrosstabOrigin(this, 1));
        this.getEventSupport().firePropertyChange(PROPERTY_HEADER_CELL, jRDesignCellContents2, this.headerCell);
    }

    public void measureClassChanged(JRDesignCrosstabMeasure jRDesignCrosstabMeasure, String string) {
        JRCrosstabGroup jRCrosstabGroup;
        Iterator iterator = this.columnGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabColumnGroup)iterator.next();
            this.setTotalVarClass(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup, string);
        }
        iterator = this.rowGroups.iterator();
        while (iterator.hasNext()) {
            jRCrosstabGroup = (JRCrosstabRowGroup)iterator.next();
            this.setTotalVarClass(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null, string);
            Iterator iterator2 = this.columnGroups.iterator();
            while (iterator2.hasNext()) {
                JRCrosstabColumnGroup jRCrosstabColumnGroup = (JRCrosstabColumnGroup)iterator2.next();
                this.setTotalVarClass(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup, string);
            }
        }
    }

    public void setTotalVarClass(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup, String string) {
        JRDesignVariable jRDesignVariable = this.getVariable(JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup));
        jRDesignVariable.setValueClassName(string);
    }

    private void addVariable(JRVariable jRVariable) {
        this.variablesList.put(jRVariable.getName(), jRVariable);
    }

    private void removeVariable(JRVariable jRVariable) {
        this.removeVariable(jRVariable.getName());
    }

    private void removeVariable(String string) {
        this.variablesList.remove(string);
    }

    private JRDesignVariable getVariable(String string) {
        return (JRDesignVariable)this.variablesList.get(string);
    }

    public byte getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(byte by2) {
        byte by3 = this.runDirection;
        this.runDirection = by2;
        this.getEventSupport().firePropertyChange("runDirection", by3, this.runDirection);
    }

    public void setCellOrigin(JRCellContents jRCellContents, JRCrosstabOrigin jRCrosstabOrigin) {
        if (jRCellContents instanceof JRDesignCellContents) {
            this.setCellOrigin((JRDesignCellContents)jRCellContents, jRCrosstabOrigin);
        }
    }

    public void setCellOrigin(JRDesignCellContents jRDesignCellContents, JRCrosstabOrigin jRCrosstabOrigin) {
        if (jRDesignCellContents != null) {
            jRDesignCellContents.a(jRCrosstabOrigin);
        }
    }

    public void setParent(JRDesignCrosstabGroup jRDesignCrosstabGroup) {
        if (jRDesignCrosstabGroup != null) {
            jRDesignCrosstabGroup.a(this);
        }
    }

    public Object clone() {
        Object object;
        int n2;
        JRDesignCrosstab jRDesignCrosstab = (JRDesignCrosstab)super.clone();
        if (this.parametersList != null) {
            jRDesignCrosstab.parametersList = new ArrayList(this.parametersList.size());
            jRDesignCrosstab.parametersMap = new HashMap(this.parametersList.size());
            for (n2 = 0; n2 < this.parametersList.size(); ++n2) {
                object = (JRCrosstabParameter)((JRCrosstabParameter)this.parametersList.get(n2)).clone();
                jRDesignCrosstab.parametersList.add(object);
                jRDesignCrosstab.parametersMap.put(object.getName(), object);
            }
        }
        if (this.variablesList != null) {
            jRDesignCrosstab.variablesList = new SequencedHashMap(this.variablesList.size());
            Iterator iterator = this.variablesList.sequence().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                JRVariable jRVariable = (JRVariable)this.variablesList.get(object);
                jRDesignCrosstab.variablesList.put(jRVariable.getName(), jRVariable);
            }
        }
        if (this.parametersMapExpression != null) {
            jRDesignCrosstab.parametersMapExpression = (JRExpression)this.parametersMapExpression.clone();
        }
        if (this.dataset != null) {
            jRDesignCrosstab.dataset = (JRDesignCrosstabDataset)this.dataset.clone();
        }
        if (this.rowGroups != null) {
            jRDesignCrosstab.rowGroups = new ArrayList(this.rowGroups.size());
            jRDesignCrosstab.rowGroupsMap = new HashMap(this.rowGroups.size());
            for (n2 = 0; n2 < this.rowGroups.size(); ++n2) {
                object = (JRCrosstabRowGroup)((JRCrosstabRowGroup)this.rowGroups.get(n2)).clone();
                jRDesignCrosstab.rowGroups.add(object);
                jRDesignCrosstab.rowGroupsMap.put(object.getName(), object);
            }
        }
        if (this.columnGroups != null) {
            jRDesignCrosstab.columnGroups = new ArrayList(this.columnGroups.size());
            jRDesignCrosstab.columnGroupsMap = new HashMap(this.columnGroups.size());
            for (n2 = 0; n2 < this.columnGroups.size(); ++n2) {
                object = (JRCrosstabColumnGroup)((JRCrosstabColumnGroup)this.columnGroups.get(n2)).clone();
                jRDesignCrosstab.columnGroups.add(object);
                jRDesignCrosstab.columnGroupsMap.put(object.getName(), object);
            }
        }
        if (this.measures != null) {
            jRDesignCrosstab.measures = new ArrayList(this.measures.size());
            jRDesignCrosstab.measuresMap = new HashMap(this.measures.size());
            for (n2 = 0; n2 < this.measures.size(); ++n2) {
                object = (JRCrosstabMeasure)((JRCrosstabMeasure)this.measures.get(n2)).clone();
                jRDesignCrosstab.measures.add(object);
                jRDesignCrosstab.measuresMap.put(object.getName(), object);
            }
        }
        if (this.cellsList != null) {
            jRDesignCrosstab.cellsList = new ArrayList(this.cellsList.size());
            jRDesignCrosstab.cellsMap = new HashMap(this.cellsList.size());
            for (n2 = 0; n2 < this.cellsList.size(); ++n2) {
                object = (JRDesignCrosstabCell)((JRDesignCrosstabCell)this.cellsList.get(n2)).clone();
                jRDesignCrosstab.cellsList.add(object);
                jRDesignCrosstab.cellsMap.put(new Pair(((JRBaseCrosstabCell)object).getRowTotalGroup(), ((JRBaseCrosstabCell)object).getColumnTotalGroup()), object);
            }
        }
        if (this.whenNoDataCell != null) {
            jRDesignCrosstab.whenNoDataCell = (JRDesignCellContents)this.whenNoDataCell.clone();
        }
        if (this.headerCell != null) {
            jRDesignCrosstab.headerCell = (JRDesignCellContents)this.headerCell.clone();
        }
        return jRDesignCrosstab;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1 {
    }

    private class MeasureClassChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;
        private final JRDesignCrosstab this$0;

        private MeasureClassChangeListener(JRDesignCrosstab jRDesignCrosstab) {
            this.this$0 = jRDesignCrosstab;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.this$0.measureClassChanged((JRDesignCrosstabMeasure)propertyChangeEvent.getSource(), (String)propertyChangeEvent.getNewValue());
        }

        public MeasureClassChangeListener(JRDesignCrosstab jRDesignCrosstab, 1 var2_2) {
            this(jRDesignCrosstab);
        }
    }
}

