/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.JREvaluator;

public class JRBshEvaluator
extends JREvaluator {
    private String bshScript = null;
    private Interpreter interpreter = null;

    public JRBshEvaluator(String string) throws JRException {
        this.bshScript = string;
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            this.interpreter.eval((Reader)new StringReader(string));
        }
        catch (EvalError evalError) {
            throw new JRException("Error evaluating report expressions BeanShell script.\nMessage : " + evalError.getMessage() + "\nLine " + evalError.getErrorLineNumber() + " : " + this.extractLineContent(evalError));
        }
    }

    public void verify(Collection collection) throws JRException {
        try {
            this.interpreter.eval("bshEvaluator = createBshEvaluator()");
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    JRExpression jRExpression = (JRExpression)iterator.next();
                    this.interpreter.eval("bshEvaluator.evaluateOld(" + jRExpression.getId() + ")");
                }
            }
        }
        catch (TargetError targetError) {
        }
        catch (EvalError evalError) {
            throw new JRException("Error testing report expressions BeanShell script.\nMessage : " + evalError.getMessage() + "\nLine " + evalError.getErrorLineNumber() + " : " + this.extractLineContent(evalError));
        }
    }

    public void customizedInit(Map map, Map map2, Map map3) throws JRException {
        try {
            this.interpreter.set("calculator", (Object)this);
            this.interpreter.set("fldsm", (Object)map2);
            this.interpreter.set("varsm", (Object)map3);
            this.interpreter.set("parsm", (Object)map);
            this.interpreter.eval("bshEvaluator = createBshEvaluator()");
            this.interpreter.eval("bshEvaluator.init(calculator, parsm, fldsm, varsm)");
        }
        catch (EvalError evalError) {
            throw new JRException("Error initializing report BeanShell calculator.", evalError);
        }
    }

    public Object evaluateOld(int n2) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluateOld(" + n2 + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    public Object evaluateEstimated(int n2) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluateEstimated(" + n2 + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    public Object evaluate(int n2) throws Throwable {
        try {
            return this.interpreter.eval("bshEvaluator.evaluate(" + n2 + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractLineContent(EvalError evalError) {
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(new StringReader(this.bshScript));
            int n2 = evalError.getErrorLineNumber();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = ((LineNumberReader)bufferedReader).readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }
}

