/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.fill.JRFillXySeries;
import net.sf.jasperreports.charts.util.XYDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JRFillXyDataset
extends JRFillChartDataset
implements JRXyDataset {
    public JRFillXySeries[] xySeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillXyDataset(JRXyDataset jRXyDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRXyDataset, jRFillObjectFactory);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            this.xySeries = new JRFillXySeries[jRXySeriesArray.length];
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                this.xySeries[i2] = (JRFillXySeries)jRFillObjectFactory.getXySeries(jRXySeriesArray[i2]);
            }
        }
    }

    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    public void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    public void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                this.xySeries[i2].evaluate(jRCalculator);
            }
        }
    }

    public void customIncrement() {
        if (this.xySeries != null && this.xySeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i2 = 0; i2 < this.xySeries.length; ++i2) {
                Map<Number, String> map;
                JRFillXySeries jRFillXySeries = this.xySeries[i2];
                Comparable comparable = jRFillXySeries.getSeries();
                XYSeries xYSeries = (XYSeries)this.seriesMap.get(comparable);
                if (xYSeries == null) {
                    xYSeries = new XYSeries(comparable);
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, xYSeries);
                }
                xYSeries.addOrUpdate(jRFillXySeries.getXValue(), jRFillXySeries.getYValue());
                if (jRFillXySeries.getLabelExpression() != null) {
                    map = (HashMap<Number, String>)this.labelsMap.get(comparable);
                    if (map == null) {
                        map = new HashMap<Number, String>();
                        this.labelsMap.put(comparable, map);
                    }
                    map.put(jRFillXySeries.getXValue(), jRFillXySeries.getLabel());
                }
                if (!jRFillXySeries.hasItemHyperlinks()) continue;
                map = (Map)this.itemHyperlinks.get(comparable);
                if (map == null) {
                    map = new HashMap();
                    this.itemHyperlinks.put(comparable, map);
                }
                Pair pair = new Pair(jRFillXySeries.getXValue(), jRFillXySeries.getYValue());
                map.put((Number)((Object)pair), (String)((Object)jRFillXySeries.getPrintItemHyperlink()));
            }
        }
    }

    public Dataset getCustomDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        if (this.seriesNames != null) {
            for (int i2 = 0; i2 < this.seriesNames.size(); ++i2) {
                Comparable comparable = (Comparable)this.seriesNames.get(i2);
                xYSeriesCollection.addSeries((XYSeries)this.seriesMap.get(comparable));
            }
        }
        return xYSeriesCollection;
    }

    public byte getDatasetType() {
        return 3;
    }

    public XYDatasetLabelGenerator getLabelGenerator() {
        return new XYDatasetLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean bl2 = false;
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i2 = 0; i2 < this.xySeries.length && !bl2; ++i2) {
                JRFillXySeries jRFillXySeries = this.xySeries[i2];
                bl2 = jRFillXySeries.hasItemHyperlinks();
            }
        }
        return bl2;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

