/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    public JRFillTimeSeries[] timeSeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRTimeSeriesDataset, jRFillObjectFactory);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            this.timeSeries = new JRFillTimeSeries[jRTimeSeriesArray.length];
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2] = (JRFillTimeSeries)jRFillObjectFactory.getTimeSeries(jRTimeSeriesArray[i2]);
            }
        }
    }

    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    public void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    public void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2].evaluate(jRCalculator);
            }
        }
    }

    public void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                Map<Object, String> map;
                JRFillTimeSeries jRFillTimeSeries = this.timeSeries[i2];
                Comparable comparable = jRFillTimeSeries.getSeries();
                if (comparable == null) {
                    throw new JRRuntimeException("Time series name is null.");
                }
                TimeSeries timeSeries = (TimeSeries)this.seriesMap.get(comparable);
                if (timeSeries == null) {
                    timeSeries = new TimeSeries(comparable.toString(), this.getTimePeriod());
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, timeSeries);
                }
                RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance((Class)this.getTimePeriod(), (Date)jRFillTimeSeries.getTimePeriod(), (TimeZone)this.getTimeZone());
                timeSeries.addOrUpdate(regularTimePeriod, jRFillTimeSeries.getValue());
                if (jRFillTimeSeries.getLabelExpression() != null) {
                    map = (HashMap<RegularTimePeriod, String>)this.labelsMap.get(comparable);
                    if (map == null) {
                        map = new HashMap<RegularTimePeriod, String>();
                        this.labelsMap.put(comparable, map);
                    }
                    map.put(regularTimePeriod, jRFillTimeSeries.getLabel());
                }
                if (!jRFillTimeSeries.hasItemHyperlink()) continue;
                map = (Map)this.itemHyperlinks.get(comparable);
                if (map == null) {
                    map = new HashMap();
                    this.itemHyperlinks.put(comparable, map);
                }
                map.put(regularTimePeriod, (String)((Object)jRFillTimeSeries.getPrintItemHyperlink()));
            }
        }
    }

    public Dataset getCustomDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        if (this.seriesNames != null) {
            for (int i2 = 0; i2 < this.seriesNames.size(); ++i2) {
                Comparable comparable = (Comparable)this.seriesNames.get(i2);
                timeSeriesCollection.addSeries((TimeSeries)this.seriesMap.get(comparable));
            }
        }
        return timeSeriesCollection;
    }

    public Class getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    public void setTimePeriod(Class clazz) {
    }

    public byte getDatasetType() {
        return 6;
    }

    public TimeSeriesLabelGenerator getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean bl2 = false;
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i2 = 0; i2 < this.timeSeries.length && !bl2; ++i2) {
                bl2 = this.timeSeries[i2].hasItemHyperlink();
            }
        }
        return bl2;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

