/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaBrush;
import com.lowagie.text.pdf.wmf.MetaFont;
import com.lowagie.text.pdf.wmf.MetaObject;
import com.lowagie.text.pdf.wmf.MetaPen;
import com.lowagie.text.pdf.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    public int e;
    public int a;
    public int f;
    public int c;
    public int b;
    public MetaState d = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.e = this.in.readShort();
        this.a = this.in.readShort();
        this.f = this.in.readShort();
        this.c = this.in.readShort();
        this.b = this.in.readWord();
        this.d.setScalingX((float)(this.f - this.e) / (float)this.b * 72.0f);
        this.d.setScalingY((float)(this.c - this.a) / (float)this.b * 72.0f);
        this.d.setOffsetWx(this.e);
        this.d.setOffsetWy(this.a);
        this.d.setExtentWx(this.f - this.e);
        this.d.setExtentWy(this.c - this.a);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n2 = this.in.getLength();
            int n3 = this.in.readInt();
            if (n3 < 3) break;
            int n4 = this.in.readWord();
            switch (n4) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.d.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.d.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.d.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.d.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n5 = this.in.readWord();
                    this.d.selectMetaObject(n5, this.cb);
                    break;
                }
                case 496: {
                    int n6 = this.in.readWord();
                    this.d.deleteMetaObject(n6);
                    break;
                }
                case 30: {
                    this.d.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n7 = this.in.readShort();
                    this.d.restoreState(n7, this.cb);
                    break;
                }
                case 523: {
                    this.d.setOffsetWy(this.in.readShort());
                    this.d.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.d.setExtentWy(this.in.readShort());
                    this.d.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n8 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n8);
                    this.d.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n9 = this.in.readShort();
                    int n10 = this.in.readShort();
                    Point point = this.d.getCurrentPoint();
                    this.cb.moveTo(this.d.transformX(point.x), this.d.transformY(point.y));
                    this.cb.lineTo(this.d.transformX(n10), this.d.transformY(n9));
                    this.cb.stroke();
                    this.d.setCurrentPoint(new Point(n10, n9));
                    break;
                }
                case 805: {
                    this.d.setLineJoinPolygon(this.cb);
                    int n11 = this.in.readWord();
                    int n12 = this.in.readShort();
                    int n13 = this.in.readShort();
                    this.cb.moveTo(this.d.transformX(n12), this.d.transformY(n13));
                    for (int i2 = 1; i2 < n11; ++i2) {
                        n12 = this.in.readShort();
                        n13 = this.in.readShort();
                        this.cb.lineTo(this.d.transformX(n12), this.d.transformY(n13));
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n14 = this.in.readWord();
                    int n15 = this.in.readShort();
                    int n16 = this.in.readShort();
                    this.cb.moveTo(this.d.transformX(n15), this.d.transformY(n16));
                    for (int i3 = 1; i3 < n14; ++i3) {
                        int n17 = this.in.readShort();
                        int n18 = this.in.readShort();
                        this.cb.lineTo(this.d.transformX(n17), this.d.transformY(n18));
                    }
                    this.cb.lineTo(this.d.transformX(n15), this.d.transformY(n16));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n19;
                    if (this.isNullStrokeFill(false)) break;
                    int n20 = this.in.readWord();
                    int[] nArray = new int[n20];
                    for (n19 = 0; n19 < nArray.length; ++n19) {
                        nArray[n19] = this.in.readWord();
                    }
                    for (n19 = 0; n19 < nArray.length; ++n19) {
                        int n21 = nArray[n19];
                        int n22 = this.in.readShort();
                        int n23 = this.in.readShort();
                        this.cb.moveTo(this.d.transformX(n22), this.d.transformY(n23));
                        for (int i4 = 1; i4 < n21; ++i4) {
                            int n24 = this.in.readShort();
                            int n25 = this.in.readShort();
                            this.cb.lineTo(this.d.transformX(n24), this.d.transformY(n25));
                        }
                        this.cb.lineTo(this.d.transformX(n22), this.d.transformY(n23));
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.d.getLineNeutral())) break;
                    int n26 = this.in.readShort();
                    int n27 = this.in.readShort();
                    int n28 = this.in.readShort();
                    int n29 = this.in.readShort();
                    this.cb.arc(this.d.transformX(n29), this.d.transformY(n26), this.d.transformX(n27), this.d.transformY(n28), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.d.getLineNeutral())) break;
                    float f2 = this.d.transformY(this.in.readShort());
                    float f3 = this.d.transformX(this.in.readShort());
                    float f4 = this.d.transformY(this.in.readShort());
                    float f5 = this.d.transformX(this.in.readShort());
                    float f6 = this.d.transformY(this.in.readShort());
                    float f7 = this.d.transformX(this.in.readShort());
                    float f8 = this.d.transformY(this.in.readShort());
                    float f9 = this.d.transformX(this.in.readShort());
                    float f10 = (f7 + f9) / 2.0f;
                    float f11 = (f8 + f6) / 2.0f;
                    float f12 = MetaDo.a(f10, f11, f5, f4);
                    float f13 = MetaDo.a(f10, f11, f3, f2);
                    if ((f13 -= f12) <= 0.0f) {
                        f13 += 360.0f;
                    }
                    this.cb.arc(f9, f6, f7, f8, f12, f13);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    int n30;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.d.getLineNeutral())) break;
                    float f14 = this.d.transformY(this.in.readShort());
                    float f15 = this.d.transformX(this.in.readShort());
                    float f16 = this.d.transformY(this.in.readShort());
                    float f17 = this.d.transformX(this.in.readShort());
                    float f18 = this.d.transformY(this.in.readShort());
                    float f19 = this.d.transformX(this.in.readShort());
                    float f8 = this.d.transformY(this.in.readShort());
                    float f9 = this.d.transformX(this.in.readShort());
                    float f10 = (f19 + f9) / 2.0f;
                    float f11 = (f8 + f18) / 2.0f;
                    float f20 = MetaDo.a(f10, f11, f17, f16);
                    float f21 = MetaDo.a(f10, f11, f15, f14);
                    if ((f21 -= f20) <= 0.0f) {
                        f21 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f9, f18, f19, f8, f20, f21)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f10, f11);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    for (n30 = 0; n30 < arrayList.size(); ++n30) {
                        fArray = (float[])arrayList.get(n30);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f10, f11);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    int n30;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.d.getLineNeutral())) break;
                    float f22 = this.d.transformY(this.in.readShort());
                    float f23 = this.d.transformX(this.in.readShort());
                    float f24 = this.d.transformY(this.in.readShort());
                    float f25 = this.d.transformX(this.in.readShort());
                    float f26 = this.d.transformY(this.in.readShort());
                    float f27 = this.d.transformX(this.in.readShort());
                    float f8 = this.d.transformY(this.in.readShort());
                    float f9 = this.d.transformX(this.in.readShort());
                    float f10 = (f27 + f9) / 2.0f;
                    float f11 = (f8 + f26) / 2.0f;
                    float f28 = MetaDo.a(f10, f11, f25, f24);
                    float f29 = MetaDo.a(f10, f11, f23, f22);
                    if ((f29 -= f28) <= 0.0f) {
                        f29 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f9, f26, f27, f8, f28, f29)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f10 = fArray[0];
                    f11 = fArray[1];
                    this.cb.moveTo(f10, f11);
                    for (n30 = 0; n30 < arrayList.size(); ++n30) {
                        fArray = (float[])arrayList.get(n30);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f10, f11);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f30 = this.d.transformY(this.in.readShort());
                    float f31 = this.d.transformX(this.in.readShort());
                    float f32 = this.d.transformY(this.in.readShort());
                    float f33 = this.d.transformX(this.in.readShort());
                    this.cb.rectangle(f33, f30, f31 - f33, f32 - f30);
                    this.strokeAndFill();
                    break;
                }
                case 1564: {
                    if (this.isNullStrokeFill(true)) break;
                    float f34 = this.d.transformY(0) - this.d.transformY(this.in.readShort());
                    float f35 = this.d.transformX(this.in.readShort()) - this.d.transformX(0);
                    float f36 = this.d.transformY(this.in.readShort());
                    float f37 = this.d.transformX(this.in.readShort());
                    float f38 = this.d.transformY(this.in.readShort());
                    float f39 = this.d.transformX(this.in.readShort());
                    this.cb.roundRectangle(f39, f36, f37 - f39, f38 - f36, (f34 + f35) / 4.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f40 = this.d.transformY(this.in.readShort());
                    float f41 = this.d.transformX(this.in.readShort());
                    float f42 = this.d.transformY(this.in.readShort());
                    float f43 = this.d.transformX(this.in.readShort());
                    this.cb.rectangle(f43, f40, f41 - f43, f42 - f40);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    byte by2;
                    int n31;
                    int n32 = this.in.readShort();
                    int n33 = this.in.readShort();
                    int n34 = this.in.readWord();
                    int n35 = this.in.readWord();
                    int n36 = 0;
                    int n37 = 0;
                    int n38 = 0;
                    int n39 = 0;
                    if ((n35 & 6) != 0) {
                        n36 = this.in.readShort();
                        n37 = this.in.readShort();
                        n38 = this.in.readShort();
                        n39 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n34];
                    for (n31 = 0; n31 < n34 && (by2 = (byte)this.in.readByte()) != 0; ++n31) {
                        byArray[n31] = by2;
                    }
                    try {
                        string = new String(byArray, 0, n31, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n31);
                    }
                    this.outputText(n33, n32, n35, n36, n37, n38, n39, string);
                    break;
                }
                case 1313: {
                    String string;
                    byte by3;
                    int n40;
                    int n41 = this.in.readWord();
                    byte[] byArray = new byte[n41];
                    for (n40 = 0; n40 < n41 && (by3 = (byte)this.in.readByte()) != 0; ++n40) {
                        byArray[n40] = by3;
                    }
                    try {
                        string = new String(byArray, 0, n40, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n40);
                    }
                    n41 = n41 + 1 & 0xFFFE;
                    this.in.skip(n41 - n40);
                    int n42 = this.in.readShort();
                    int n43 = this.in.readShort();
                    this.outputText(n43, n42, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.d.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.d.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.d.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.d.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.d.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n44 = this.in.readShort();
                    int n45 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.d.transformX(n45), this.d.transformY(n44), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                    break;
                }
                case 2881: 
                case 3907: {
                    int n46 = this.in.readInt();
                    if (n4 == 3907) {
                        this.in.readWord();
                    }
                    int n47 = this.in.readShort();
                    int n48 = this.in.readShort();
                    int n49 = this.in.readShort();
                    int n50 = this.in.readShort();
                    float f44 = this.d.transformY(this.in.readShort()) - this.d.transformY(0);
                    float f8 = this.d.transformX(this.in.readShort()) - this.d.transformX(0);
                    float f9 = this.d.transformY(this.in.readShort());
                    float f10 = this.d.transformX(this.in.readShort());
                    byte[] byArray = new byte[n3 * 2 - (this.in.getLength() - n2)];
                    for (int i5 = 0; i5 < byArray.length; ++i5) {
                        byArray[i5] = (byte)this.in.readByte();
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        Image image = BmpImage.getImage(byteArrayInputStream, true, byArray.length);
                        this.cb.saveState();
                        this.cb.rectangle(f10, f9, f8, f44);
                        this.cb.clip();
                        this.cb.newPath();
                        image.scaleAbsolute(f8 * image.width() / (float)n48, -f44 * image.height() / (float)n47);
                        image.setAbsolutePosition(f10 - f8 * (float)n50 / (float)n48, f9 + f44 * (float)n49 / (float)n47 - image.scaledHeight());
                        this.cb.addImage(image);
                        this.cb.restoreState();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.in.skip(n3 * 2 - (this.in.getLength() - n2));
        }
    }

    public void outputText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) throws IOException {
        Color color;
        MetaFont metaFont = this.d.getCurrentFont();
        float f2 = this.d.transformX(n2);
        float f3 = this.d.transformY(n3);
        float f4 = this.d.transformAngle(metaFont.getAngle());
        float f5 = (float)Math.sin(f4);
        float f6 = (float)Math.cos(f4);
        float f7 = metaFont.getFontSize(this.d);
        BaseFont baseFont = metaFont.getFont();
        int n9 = this.d.getTextAlign();
        float f8 = baseFont.getWidthPoint(string, f7);
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = baseFont.getFontDescriptor(3, f7);
        float f12 = baseFont.getFontDescriptor(8, f7);
        this.cb.saveState();
        this.cb.concatCTM(f6, f5, -f5, f6, f2, f3);
        if ((n9 & 6) == 6) {
            f9 = -f8 / 2.0f;
        } else if ((n9 & 2) == 2) {
            f9 = -f8;
        }
        f10 = (n9 & 0x18) == 24 ? 0.0f : ((n9 & 8) == 8 ? -f11 : -f12);
        if (this.d.getBackgroundMode() == 2) {
            color = this.d.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f9, f10 + f11, f8, f12 - f11);
            this.cb.fill();
        }
        color = this.d.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f7);
        this.cb.setTextMatrix(f9, f10);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f9, f10 - f7 / 4.0f, f8, f7 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f9, f10 + f7 / 3.0f, f8, f7 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl2) {
        boolean bl3;
        MetaPen metaPen = this.d.getCurrentPen();
        MetaBrush metaBrush = this.d.getCurrentBrush();
        boolean bl4 = metaPen.getStyle() == 5;
        int n2 = metaBrush.getStyle();
        boolean bl5 = n2 == 0 || n2 == 2 && this.d.getBackgroundMode() == 2;
        boolean bl6 = bl3 = bl4 && !bl5;
        if (!bl4) {
            if (bl2) {
                this.d.setLineJoinRectangle(this.cb);
            } else {
                this.d.setLineJoinPolygon(this.cb);
            }
        }
        return bl3;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.d.getCurrentPen();
        MetaBrush metaBrush = this.d.getCurrentBrush();
        int n2 = metaPen.getStyle();
        int n3 = metaBrush.getStyle();
        if (n2 == 5) {
            this.cb.closePath();
            if (this.d.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl2;
            boolean bl3 = bl2 = n3 == 0 || n3 == 2 && this.d.getBackgroundMode() == 2;
            if (bl2) {
                if (this.d.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    public static float a(float f2, float f3, float f4, float f5) {
        double d2 = Math.atan2(f5 - f3, f4 - f2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return (float)(d2 / Math.PI * 180.0);
    }

    public static byte[] wrapBMP(Image image) throws IOException {
        if (image.getOriginalType() != 4) {
            throw new IOException("Only BMP can be wrapped in WMF.");
        }
        byte[] byArray = null;
        if (image.getOriginalData() == null) {
            InputStream inputStream = image.url().openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            inputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byArray = image.getOriginalData();
        }
        int n3 = byArray.length - 14 + 1 >>> 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeWord(byteArrayOutputStream, 9);
        MetaDo.writeWord(byteArrayOutputStream, 768);
        MetaDo.writeDWord(byteArrayOutputStream, 23 + (13 + n3) + 3);
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeDWord(byteArrayOutputStream, 14 + n3);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 4);
        MetaDo.writeWord(byteArrayOutputStream, 259);
        MetaDo.writeWord(byteArrayOutputStream, 8);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 523);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 524);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeDWord(byteArrayOutputStream, 13 + n3);
        MetaDo.writeWord(byteArrayOutputStream, 2881);
        MetaDo.writeDWord(byteArrayOutputStream, 0xCC0020);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(byArray, 14, byArray.length - 14);
        if ((byArray.length & 1) == 1) {
            byteArrayOutputStream.write(0);
        }
        MetaDo.writeDWord(byteArrayOutputStream, 3);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeWord(OutputStream outputStream, int n2) throws IOException {
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
    }

    public static void writeDWord(OutputStream outputStream, int n2) throws IOException {
        MetaDo.writeWord(outputStream, n2 & 0xFFFF);
        MetaDo.writeWord(outputStream, n2 >>> 16 & 0xFFFF);
    }
}

