/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.CharVector;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;

public class TernaryTree
implements Cloneable,
Serializable {
    public char[] lo;
    public char[] hi;
    public char[] eq;
    public char[] sc;
    public CharVector kv;
    public char root;
    public char freenode;
    public int length;
    public static final int BLOCK_SIZE = 2048;

    public TernaryTree() {
        this.init();
    }

    public void init() {
        this.root = '\u0000';
        this.freenode = '\u0001';
        this.length = 0;
        this.lo = new char[2048];
        this.hi = new char[2048];
        this.eq = new char[2048];
        this.sc = new char[2048];
        this.kv = new CharVector();
    }

    public void insert(String string, char c2) {
        int n2 = string.length() + 1;
        if (this.freenode + n2 > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        char[] cArray = new char[n2--];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        this.root = this.insert(this.root, cArray, 0, c2);
    }

    public void insert(char[] cArray, int n2, char c2) {
        int n3 = TernaryTree.strlen(cArray) + 1;
        if (this.freenode + n3 > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        this.root = this.insert(this.root, cArray, n2, c2);
    }

    private char insert(char c2, char[] cArray, int n2, char c3) {
        char c4;
        int n3 = TernaryTree.strlen(cArray, n2);
        if (c2 == '\u0000') {
            char c5 = this.freenode;
            this.freenode = (char)(c5 + '\u0001');
            c2 = c5;
            this.eq[c2] = c3;
            ++this.length;
            this.hi[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = 65535;
                this.lo[c2] = (char)this.kv.alloc(n3 + 1);
                TernaryTree.strcpy(this.kv.getArray(), this.lo[c2], cArray, n2);
            } else {
                this.sc[c2] = '\u0000';
                this.lo[c2] = '\u0000';
            }
            return c2;
        }
        if (this.sc[c2] == '\uffff') {
            char c6 = this.freenode;
            this.freenode = (char)(c6 + '\u0001');
            c4 = c6;
            this.lo[c4] = this.lo[c2];
            this.eq[c4] = this.eq[c2];
            this.lo[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = this.kv.get(this.lo[c4]);
                this.eq[c2] = c4;
                char c7 = c4;
                this.lo[c7] = (char)(this.lo[c7] + '\u0001');
                if (this.kv.get(this.lo[c4]) == '\u0000') {
                    this.lo[c4] = '\u0000';
                    this.sc[c4] = '\u0000';
                    this.hi[c4] = '\u0000';
                } else {
                    this.sc[c4] = 65535;
                }
            } else {
                this.sc[c4] = 65535;
                this.hi[c2] = c4;
                this.sc[c2] = '\u0000';
                this.eq[c2] = c3;
                ++this.length;
                return c2;
            }
        }
        if ((c4 = cArray[n2]) < this.sc[c2]) {
            this.lo[c2] = this.insert(this.lo[c2], cArray, n2, c3);
        } else if (c4 == this.sc[c2]) {
            this.eq[c2] = c4 != '\u0000' ? this.insert(this.eq[c2], cArray, n2 + 1, c3) : c3;
        } else {
            this.hi[c2] = this.insert(this.hi[c2], cArray, n2, c3);
        }
        return c2;
    }

    public static int strcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        return cArray[n2] - cArray2[n3];
    }

    public static int strcmp(String string, char[] cArray, int n2) {
        int n3;
        int n4 = string.length();
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = string.charAt(n3) - cArray[n2 + n3];
            if (n5 != 0) {
                return n5;
            }
            if (cArray[n2 + n3] != '\u0000') continue;
            return n5;
        }
        if (cArray[n2 + n3] != '\u0000') {
            return -cArray[n2 + n3];
        }
        return 0;
    }

    public static void strcpy(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray2[n3] != '\u0000') {
            cArray[n2++] = cArray2[n3++];
        }
        cArray[n2] = '\u0000';
    }

    public static int strlen(char[] cArray, int n2) {
        int n3 = 0;
        for (int i2 = n2; i2 < cArray.length && cArray[i2] != '\u0000'; ++i2) {
            ++n3;
        }
        return n3;
    }

    public static int strlen(char[] cArray) {
        return TernaryTree.strlen(cArray, 0);
    }

    public int find(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        return this.find(cArray, 0);
    }

    public int find(char[] cArray, int n2) {
        char c2 = this.root;
        int n3 = n2;
        while (c2 != '\u0000') {
            if (this.sc[c2] == '\uffff') {
                if (TernaryTree.strcmp(cArray, n3, this.kv.getArray(), this.lo[c2]) == 0) {
                    return this.eq[c2];
                }
                return -1;
            }
            char c3 = cArray[n3];
            int n4 = c3 - this.sc[c2];
            if (n4 == 0) {
                if (c3 == '\u0000') {
                    return this.eq[c2];
                }
                ++n3;
                c2 = this.eq[c2];
                continue;
            }
            if (n4 < 0) {
                c2 = this.lo[c2];
                continue;
            }
            c2 = this.hi[c2];
        }
        return -1;
    }

    public boolean knows(String string) {
        return this.find(string) >= 0;
    }

    private void redimNodeArrays(int n2) {
        int n3 = n2 < this.lo.length ? n2 : this.lo.length;
        char[] cArray = new char[n2];
        System.arraycopy(this.lo, 0, cArray, 0, n3);
        this.lo = cArray;
        cArray = new char[n2];
        System.arraycopy(this.hi, 0, cArray, 0, n3);
        this.hi = cArray;
        cArray = new char[n2];
        System.arraycopy(this.eq, 0, cArray, 0, n3);
        this.eq = cArray;
        cArray = new char[n2];
        System.arraycopy(this.sc, 0, cArray, 0, n3);
        this.sc = cArray;
    }

    public int size() {
        return this.length;
    }

    public Object clone() {
        TernaryTree ternaryTree = new TernaryTree();
        ternaryTree.lo = (char[])this.lo.clone();
        ternaryTree.hi = (char[])this.hi.clone();
        ternaryTree.eq = (char[])this.eq.clone();
        ternaryTree.sc = (char[])this.sc.clone();
        ternaryTree.kv = (CharVector)this.kv.clone();
        ternaryTree.root = this.root;
        ternaryTree.freenode = this.freenode;
        ternaryTree.length = this.length;
        return ternaryTree;
    }

    public void insertBalanced(String[] stringArray, char[] cArray, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        int n4 = n3 >> 1;
        this.insert(stringArray[n4 + n2], cArray[n4 + n2]);
        this.insertBalanced(stringArray, cArray, n2, n4);
        this.insertBalanced(stringArray, cArray, n2 + n4 + 1, n3 - n4 - 1);
    }

    public void balance() {
        int n2 = 0;
        int n3 = this.length;
        String[] stringArray = new String[n3];
        char[] cArray = new char[n3];
        Iterator iterator = new Iterator(this);
        while (iterator.hasMoreElements()) {
            cArray[n2] = iterator.getValue();
            stringArray[n2++] = (String)iterator.nextElement();
        }
        this.init();
        this.insertBalanced(stringArray, cArray, 0, n3);
    }

    public void trimToSize() {
        this.balance();
        this.redimNodeArrays(this.freenode);
        CharVector charVector = new CharVector();
        charVector.alloc(1);
        TernaryTree ternaryTree = new TernaryTree();
        this.compact(charVector, ternaryTree, this.root);
        this.kv = charVector;
        this.kv.trimToSize();
    }

    private void compact(CharVector charVector, TernaryTree ternaryTree, char c2) {
        if (c2 == '\u0000') {
            return;
        }
        if (this.sc[c2] == '\uffff') {
            int n2 = ternaryTree.find(this.kv.getArray(), this.lo[c2]);
            if (n2 < 0) {
                n2 = charVector.alloc(TernaryTree.strlen(this.kv.getArray(), this.lo[c2]) + 1);
                TernaryTree.strcpy(charVector.getArray(), n2, this.kv.getArray(), this.lo[c2]);
                ternaryTree.insert(charVector.getArray(), n2, (char)n2);
            }
            this.lo[c2] = (char)n2;
        } else {
            this.compact(charVector, ternaryTree, this.lo[c2]);
            if (this.sc[c2] != '\u0000') {
                this.compact(charVector, ternaryTree, this.eq[c2]);
            }
            this.compact(charVector, ternaryTree, this.hi[c2]);
        }
    }

    public Enumeration keys() {
        return new Iterator(this);
    }

    public void printStats() {
        System.out.println("Number of keys = " + Integer.toString(this.length));
        System.out.println("Node count = " + Integer.toString(this.freenode));
        System.out.println("Key Array length = " + Integer.toString(this.kv.length()));
    }

    public class Iterator
    implements Enumeration {
        public int c;
        public String b;
        public Stack d;
        public StringBuffer a;
        private final TernaryTree this$0;

        public Iterator(TernaryTree ternaryTree) {
            this.this$0 = ternaryTree;
            this.c = -1;
            this.d = new Stack();
            this.a = new StringBuffer();
            this.rewind();
        }

        public void rewind() {
            this.d.removeAllElements();
            this.a.setLength(0);
            this.c = this.this$0.root;
            this.run();
        }

        public Object nextElement() {
            String string = new String(this.b);
            this.c = this.up();
            this.run();
            return string;
        }

        public char getValue() {
            if (this.c >= 0) {
                return this.this$0.eq[this.c];
            }
            return '\u0000';
        }

        public boolean hasMoreElements() {
            return this.c != -1;
        }

        private int up() {
            Item item = new Item(this);
            int n2 = 0;
            if (this.d.empty()) {
                return -1;
            }
            if (this.c != 0 && this.this$0.sc[this.c] == '\u0000') {
                return this.this$0.lo[this.c];
            }
            boolean bl2 = true;
            block4: while (bl2) {
                item = (Item)this.d.pop();
                item.a = (char)(item.a + '\u0001');
                switch (item.a) {
                    case '\u0001': {
                        if (this.this$0.sc[item.b] != '\u0000') {
                            n2 = this.this$0.eq[item.b];
                            this.d.push(item.clone());
                            this.a.append(this.this$0.sc[item.b]);
                        } else {
                            item.a = (char)(item.a + '\u0001');
                            this.d.push(item.clone());
                            n2 = this.this$0.hi[item.b];
                        }
                        bl2 = false;
                        continue block4;
                    }
                    case '\u0002': {
                        n2 = this.this$0.hi[item.b];
                        this.d.push(item.clone());
                        if (this.a.length() > 0) {
                            this.a.setLength(this.a.length() - 1);
                        }
                        bl2 = false;
                        continue block4;
                    }
                }
                if (this.d.empty()) {
                    return -1;
                }
                bl2 = true;
            }
            return n2;
        }

        private int run() {
            block9: {
                if (this.c == -1) {
                    return -1;
                }
                boolean bl2 = false;
                while (true) {
                    if (this.c != 0) {
                        if (this.this$0.sc[this.c] == '\uffff') {
                            bl2 = true;
                        } else {
                            this.d.push(new Item(this, (char)this.c, '\u0000'));
                            if (this.this$0.sc[this.c] == '\u0000') {
                                bl2 = true;
                            } else {
                                this.c = this.this$0.lo[this.c];
                                continue;
                            }
                        }
                    }
                    if (bl2) break block9;
                    this.c = this.up();
                    if (this.c == -1) break;
                }
                return -1;
            }
            StringBuffer stringBuffer = new StringBuffer(this.a.toString());
            if (this.this$0.sc[this.c] == '\uffff') {
                int n2 = this.this$0.lo[this.c];
                while (this.this$0.kv.get(n2) != '\u0000') {
                    stringBuffer.append(this.this$0.kv.get(n2++));
                }
            }
            this.b = stringBuffer.toString();
            return 0;
        }

        private class Item
        implements Cloneable {
            public char b;
            public char a;
            private final Iterator this$1;

            public Item(Iterator iterator) {
                this.this$1 = iterator;
                this.b = '\u0000';
                this.a = '\u0000';
            }

            public Item(Iterator iterator, char c2, char c3) {
                this.this$1 = iterator;
                this.b = c2;
                this.a = c3;
            }

            public Object clone() {
                return new Item(this.this$1, this.b, this.a);
            }
        }
    }
}

