/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.hyphenation.Hyphen;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PatternInternalParser
implements PatternConsumer {
    public PatternConsumer a;

    public PatternInternalParser() {
    }

    public PatternInternalParser(PatternConsumer patternConsumer) {
        this.a = patternConsumer;
    }

    public void setConsumer(PatternConsumer patternConsumer) {
        this.a = patternConsumer;
    }

    public String getHyphString(InputStream inputStream) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        char[] cArray = new char[4000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = inputStreamReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n2);
        }
        inputStreamReader.close();
        return stringBuffer.toString();
    }

    public void parse(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.parse(fileInputStream);
    }

    public void parse(InputStream inputStream) {
        String string;
        try {
            string = this.getHyphString(inputStream);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.parseString(string);
    }

    public void parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.readClasses(stringTokenizer);
        this.readExceptions(stringTokenizer);
        this.readPatterns(stringTokenizer);
    }

    public void readClasses(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals("*")) {
            this.a.addClass(string);
        }
    }

    public void readExceptions(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals("*")) {
            String string2 = string;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.equals("{")) {
                    String string3;
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals("N")) {
                        string5 = null;
                    }
                    if ((string4 = stringTokenizer.nextToken()).equals("N")) {
                        string4 = null;
                    }
                    if ((string3 = stringTokenizer.nextToken()).equals("N")) {
                        string3 = null;
                    }
                    Hyphen hyphen = new Hyphen(string4, string5, string3);
                    arrayList.add(hyphen);
                    continue;
                }
                if (string.equals("#")) break;
                arrayList.add(string);
            }
            this.a.addException(string2, arrayList);
        }
    }

    public void readPatterns(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.a.addPattern(string, stringTokenizer.nextToken());
        }
    }

    public void addClass(String string) {
        System.out.println("class: " + string);
    }

    public void addException(String string, ArrayList arrayList) {
        System.out.println("exception: " + string + " : " + arrayList.toString());
    }

    public void addPattern(String string, String string2) {
        System.out.println("pattern: " + string + " : " + string2);
    }
}

