/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

public class TIFFLZWDecoder {
    public byte[][] o;
    public byte[] l = null;
    public byte[] m;
    public int j;
    public int n = 9;
    public int g;
    public int e;
    public int d;
    public int b;
    public int c;
    public int h;
    public int a;
    public int i = 0;
    public int k = 0;
    public int[] f = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int n2, int n3, int n4) {
        this.b = n2;
        this.h = n3;
        this.a = n4;
    }

    public byte[] decode(byte[] byArray, byte[] byArray2, int n2) {
        int n3;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new UnsupportedOperationException("TIFF 5.0-style LZW codes are not supported.");
        }
        this.initializeStringTable();
        this.l = byArray;
        this.c = n2;
        this.m = byArray2;
        this.g = 0;
        this.e = 0;
        this.d = 0;
        this.i = 0;
        this.k = 0;
        int n4 = 0;
        while ((n3 = this.getNextCode()) != 257 && this.d < byArray2.length) {
            byte[] byArray3;
            if (n3 == 256) {
                this.initializeStringTable();
                n3 = this.getNextCode();
                if (n3 == 257) break;
                this.writeString(this.o[n3]);
                n4 = n3;
                continue;
            }
            if (n3 < this.j) {
                byArray3 = this.o[n3];
                this.writeString(byArray3);
                this.addStringToTable(this.o[n4], byArray3[0]);
                n4 = n3;
                continue;
            }
            byArray3 = this.o[n4];
            byArray3 = this.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n4 = n3;
        }
        if (this.h == 2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = this.a * (i2 * this.b + 1);
                for (int i3 = this.a; i3 < this.b * this.a; ++i3) {
                    int n6 = n5;
                    byArray2[n6] = (byte)(byArray2[n6] + byArray2[n5 - this.a]);
                    ++n5;
                }
            }
        }
        return byArray2;
    }

    public void initializeStringTable() {
        this.o = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.o[i2] = new byte[1];
            this.o[i2][0] = (byte)i2;
        }
        this.j = 258;
        this.n = 9;
    }

    public void writeString(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.m[this.d++] = byArray[i2];
        }
    }

    public void addStringToTable(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        this.o[this.j++] = byArray2;
        if (this.j == 511) {
            this.n = 10;
        } else if (this.j == 1023) {
            this.n = 11;
        } else if (this.j == 2047) {
            this.n = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.o[this.j++] = byArray;
        if (this.j == 511) {
            this.n = 10;
        } else if (this.j == 1023) {
            this.n = 11;
        } else if (this.j == 2047) {
            this.n = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.i = this.i << 8 | this.l[this.g++] & 0xFF;
            this.k += 8;
            if (this.k < this.n) {
                this.i = this.i << 8 | this.l[this.g++] & 0xFF;
                this.k += 8;
            }
            int n2 = this.i >> this.k - this.n & this.f[this.n - 9];
            this.k -= this.n;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

