/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TIFFDirectory
implements Serializable {
    public boolean a;
    public int b;
    public TIFFField[] c;
    public Hashtable f = new Hashtable();
    public long e = 8L;
    public long d = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n2) {
        return n2 == 18761 || n2 == 19789;
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, int n2) throws IOException {
        long l2 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n3 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n3)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.a = n3 == 19789;
        int n4 = this.readUnsignedShort(randomAccessFileOrArray);
        if (n4 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        long l3 = this.readUnsignedInt(randomAccessFileOrArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (l3 == 0L) {
                throw new IllegalArgumentException("Directory number too large.");
            }
            randomAccessFileOrArray.seek(l3);
            int n5 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.skip(12 * n5);
            l3 = this.readUnsignedInt(randomAccessFileOrArray);
        }
        randomAccessFileOrArray.seek(l3);
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l2);
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, long l2, int n2) throws IOException {
        long l3 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n3 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n3)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.a = n3 == 19789;
        randomAccessFileOrArray.seek(l2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l2 + (long)(12 * n4));
            l2 = this.readUnsignedInt(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l2);
        }
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l3);
    }

    private void initialize(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        long l2 = 0L;
        long l3 = randomAccessFileOrArray.length();
        this.e = randomAccessFileOrArray.getFilePointer();
        this.b = this.readUnsignedShort(randomAccessFileOrArray);
        this.c = new TIFFField[this.b];
        for (int i2 = 0; i2 < this.b && l2 < l3; ++i2) {
            int n2 = this.readUnsignedShort(randomAccessFileOrArray);
            int n3 = this.readUnsignedShort(randomAccessFileOrArray);
            int n4 = (int)this.readUnsignedInt(randomAccessFileOrArray);
            boolean bl2 = false;
            boolean bl3 = true;
            l2 = randomAccessFileOrArray.getFilePointer() + 4;
            try {
                if (n4 * sizeOfType[n3] > 4) {
                    long l4 = this.readUnsignedInt(randomAccessFileOrArray);
                    if (l4 < l3) {
                        randomAccessFileOrArray.seek(l4);
                    } else {
                        bl3 = false;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl3 = false;
            }
            if (bl3) {
                this.f.put(new Integer(n2), new Integer(i2));
                Object object = null;
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        Object[] objectArray;
                        Object object2;
                        byte[] byArray = new byte[n4];
                        randomAccessFileOrArray.readFully(byArray, 0, n4);
                        if (n3 == 2) {
                            int n5 = 0;
                            int n6 = 0;
                            object2 = new ArrayList();
                            while (n5 < n4) {
                                while (n5 < n4 && byArray[n5++] != 0) {
                                }
                                ((ArrayList)object2).add(new String(byArray, n6, n5 - n6));
                                n6 = n5;
                            }
                            n4 = ((ArrayList)object2).size();
                            objectArray = new String[n4];
                            for (int i3 = 0; i3 < n4; ++i3) {
                                objectArray[i3] = (short)((String)((ArrayList)object2).get(i3));
                            }
                            object = objectArray;
                            break;
                        }
                        object = byArray;
                        break;
                    }
                    case 3: {
                        int n7;
                        char[] cArray = new char[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            cArray[n7] = (char)this.readUnsignedShort(randomAccessFileOrArray);
                        }
                        object = cArray;
                        break;
                    }
                    case 4: {
                        int n7;
                        long[] lArray = new long[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            lArray[n7] = this.readUnsignedInt(randomAccessFileOrArray);
                        }
                        object = lArray;
                        break;
                    }
                    case 5: {
                        int n7;
                        Object object2 = new long[n4][2];
                        for (n7 = 0; n7 < n4; ++n7) {
                            object2[n7][0] = this.readUnsignedInt(randomAccessFileOrArray);
                            object2[n7][1] = this.readUnsignedInt(randomAccessFileOrArray);
                        }
                        object = object2;
                        break;
                    }
                    case 8: {
                        int n7;
                        Object[] objectArray = new short[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            objectArray[n7] = this.readShort(randomAccessFileOrArray);
                        }
                        object = objectArray;
                        break;
                    }
                    case 9: {
                        int n7;
                        int[] nArray = new int[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            nArray[n7] = this.readInt(randomAccessFileOrArray);
                        }
                        object = nArray;
                        break;
                    }
                    case 10: {
                        int n7;
                        int[][] nArray = new int[n4][2];
                        for (n7 = 0; n7 < n4; ++n7) {
                            nArray[n7][0] = this.readInt(randomAccessFileOrArray);
                            nArray[n7][1] = this.readInt(randomAccessFileOrArray);
                        }
                        object = nArray;
                        break;
                    }
                    case 11: {
                        int n7;
                        float[] fArray = new float[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            fArray[n7] = this.readFloat(randomAccessFileOrArray);
                        }
                        object = fArray;
                        break;
                    }
                    case 12: {
                        int n7;
                        double[] dArray = new double[n4];
                        for (n7 = 0; n7 < n4; ++n7) {
                            dArray[n7] = this.readDouble(randomAccessFileOrArray);
                        }
                        object = dArray;
                        break;
                    }
                }
                this.c[i2] = new TIFFField(n2, n3, n4, object);
            }
            randomAccessFileOrArray.seek(l2);
        }
        this.d = this.readUnsignedInt(randomAccessFileOrArray);
    }

    public int getNumEntries() {
        return this.b;
    }

    public TIFFField getField(int n2) {
        Integer n3 = (Integer)this.f.get(new Integer(n2));
        if (n3 == null) {
            return null;
        }
        return this.c[n3];
    }

    public boolean isTagPresent(int n2) {
        return this.f.containsKey(new Integer(n2));
    }

    public int[] getTags() {
        int[] nArray = new int[this.f.size()];
        Enumeration enumeration = this.f.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.c;
    }

    public byte getFieldAsByte(int n2, int n3) {
        Integer n4 = (Integer)this.f.get(new Integer(n2));
        byte[] byArray = this.c[n4].getAsBytes();
        return byArray[n3];
    }

    public byte getFieldAsByte(int n2) {
        return this.getFieldAsByte(n2, 0);
    }

    public long getFieldAsLong(int n2, int n3) {
        Integer n4 = (Integer)this.f.get(new Integer(n2));
        return this.c[n4].getAsLong(n3);
    }

    public long getFieldAsLong(int n2) {
        return this.getFieldAsLong(n2, 0);
    }

    public float getFieldAsFloat(int n2, int n3) {
        Integer n4 = (Integer)this.f.get(new Integer(n2));
        return this.c[n4].getAsFloat(n3);
    }

    public float getFieldAsFloat(int n2) {
        return this.getFieldAsFloat(n2, 0);
    }

    public double getFieldAsDouble(int n2, int n3) {
        Integer n4 = (Integer)this.f.get(new Integer(n2));
        return this.c[n4].getAsDouble(n3);
    }

    public double getFieldAsDouble(int n2) {
        return this.getFieldAsDouble(n2, 0);
    }

    private short readShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readShort();
        }
        return randomAccessFileOrArray.readShortLE();
    }

    private int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private int readInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readInt();
        }
        return randomAccessFileOrArray.readIntLE();
    }

    private long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    private long readLong(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readLong();
        }
        return randomAccessFileOrArray.readLongLE();
    }

    private float readFloat(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readFloat();
        }
        return randomAccessFileOrArray.readFloatLE();
    }

    private double readDouble(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.a) {
            return randomAccessFileOrArray.readDouble();
        }
        return randomAccessFileOrArray.readDoubleLE();
    }

    private static int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl2) throws IOException {
        if (bl2) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private static long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl2) throws IOException {
        if (bl2) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    public static int getNumDirectories(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        long l2 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n2 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        boolean bl2 = n2 == 19789;
        int n3 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl2);
        if (n3 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        randomAccessFileOrArray.seek(4L);
        long l3 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl2);
        int n4 = 0;
        while (l3 != 0L) {
            ++n4;
            try {
                randomAccessFileOrArray.seek(l3);
                int n5 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl2);
                randomAccessFileOrArray.skip(12 * n5);
                l3 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl2);
            }
            catch (EOFException eOFException) {
                --n4;
                break;
            }
        }
        randomAccessFileOrArray.seek(l2);
        return n4;
    }

    public boolean isBigEndian() {
        return this.a;
    }

    public long getIFDOffset() {
        return this.e;
    }

    public long getNextIFDOffset() {
        return this.d;
    }
}

