/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;

public class PdfPTable
implements Element {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    public ArrayList rows = new ArrayList();
    public float totalHeight = 0.0f;
    public PdfPCell[] currentRow;
    public int currentRowIdx = 0;
    public PdfPCell defaultCell = new PdfPCell((Phrase)null);
    public float totalWidth = 0.0f;
    public float[] relativeWidths;
    public float[] absoluteWidths;
    public PdfPTableEvent tableEvent;
    public int headerRows;
    public float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    public boolean isColspan = false;
    public int runDirection = 0;

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.relativeWidths[i2] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(PdfPTable pdfPTable) {
        int n2;
        this.relativeWidths = new float[pdfPTable.relativeWidths.length];
        this.absoluteWidths = new float[pdfPTable.relativeWidths.length];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.relativeWidths.length);
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.relativeWidths.length);
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = pdfPTable.currentRowIdx;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        for (n2 = 0; n2 < this.currentRow.length && pdfPTable.currentRow[n2] != null; ++n2) {
            this.currentRow[n2] = new PdfPCell(pdfPTable.currentRow[n2]);
        }
        for (n2 = 0; n2 < pdfPTable.rows.size(); ++n2) {
            this.rows.add(new PdfPRow((PdfPRow)pdfPTable.rows.get(n2)));
        }
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.a();
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    private void calculateWidths() {
        int n2;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f2 = 0.0f;
        for (n2 = 0; n2 < this.absoluteWidths.length; ++n2) {
            f2 += this.relativeWidths[n2];
        }
        for (n2 = 0; n2 < this.absoluteWidths.length; ++n2) {
            this.absoluteWidths[n2] = this.totalWidth * this.relativeWidths[n2] / f2;
        }
    }

    public void setTotalWidth(float f2) {
        if (this.totalWidth == f2) {
            return;
        }
        this.totalWidth = f2;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.a();
    }

    public void setTotalWidth(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.totalWidth = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.totalWidth += fArray[i2];
        }
        this.setWidths(fArray);
    }

    public void setWidthPercentage(float[] fArray, Rectangle rectangle) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new IllegalArgumentException("Wrong number of columns.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        this.widthPercentage = f2 / (rectangle.right() - rectangle.left()) * 100.0f;
        this.setWidths(fArray);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public void a() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        this.totalHeight = 0.0f;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            pdfPRow.setWidths(this.absoluteWidths);
            this.totalHeight += pdfPRow.getMaxHeights();
        }
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n2;
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n3 = pdfPCell2.getColspan();
        n3 = Math.max(n3, 1);
        n3 = Math.min(n3, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n3);
        if (n3 != 1) {
            this.isColspan = true;
        }
        if ((n2 = pdfPCell2.getRunDirection()) == 0) {
            pdfPCell2.setRunDirection(this.runDirection);
        }
        this.currentRow[this.currentRowIdx] = pdfPCell2;
        this.currentRowIdx += n3;
        if (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            if (this.runDirection == 3) {
                object = new PdfPCell[this.absoluteWidths.length];
                int n4 = this.currentRow.length;
                for (int i2 = 0; i2 < this.currentRow.length; ++i2) {
                    PdfPCell pdfPCell3 = this.currentRow[i2];
                    int n5 = pdfPCell3.getColspan();
                    object[n4 -= n5] = pdfPCell3;
                    i2 += n5 - 1;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add(object);
            this.currentRow = new PdfPCell[this.absoluteWidths.length];
            this.currentRowIdx = 0;
        }
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.a(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.a(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        this.addCell(this.defaultCell);
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByteArray);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n6 = this.rows.size();
        if (n5 < 0) {
            n5 = n6;
        }
        n5 = Math.min(n5, n6);
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= n5) {
            return f3;
        }
        if (n3 < 0) {
            n3 = this.absoluteWidths.length;
        }
        n3 = Math.min(n3, this.absoluteWidths.length);
        if (n2 < 0) {
            n2 = 0;
        }
        n2 = Math.min(n2, this.absoluteWidths.length);
        float f4 = f3;
        for (int i2 = n4; i2 < n5; ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            pdfPRow.writeCells(n2, n3, f2, f3, pdfContentByteArray);
            f3 -= pdfPRow.getMaxHeights();
        }
        if (this.tableEvent != null && n2 == 0 && n3 == this.absoluteWidths.length) {
            float[] fArray = new float[n5 - n4 + 1];
            fArray[0] = f4;
            for (int i3 = n4; i3 < n5; ++i3) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(i3);
                fArray[i3 - n4 + 1] = fArray[i3 - n4] - pdfPRow.getMaxHeights();
            }
            this.tableEvent.tableLayout(this, this.a(f2, n4, n5, false), fArray, 0, n4, pdfContentByteArray);
        }
        return f3;
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte pdfContentByte) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByte);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte pdfContentByte) {
        float f4;
        if (n3 < 0) {
            n3 = this.absoluteWidths.length;
        }
        n3 = Math.min(n3, this.absoluteWidths.length);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n2 = Math.min(n2, this.absoluteWidths.length)) != 0 || n3 != this.absoluteWidths.length) {
            float f5 = 0.0f;
            for (int i2 = n2; i2 < n3; ++i2) {
                f5 += this.absoluteWidths[i2];
            }
            pdfContentByte.saveState();
            f4 = 0.0f;
            float f6 = 0.0f;
            if (n2 == 0) {
                f4 = 10000.0f;
            }
            if (n3 == this.absoluteWidths.length) {
                f6 = 10000.0f;
            }
            pdfContentByte.rectangle(f2 - f4, -10000.0f, f5 + f4 + f6, 20000.0f);
            pdfContentByte.clip();
            pdfContentByte.newPath();
        }
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        f4 = this.writeSelectedRows(n2, n3, n4, n5, f2, f3, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        if (n2 != 0 || n3 != this.absoluteWidths.length) {
            pdfContentByte.restoreState();
        }
        return f4;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n2) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
        return pdfPRow.getMaxHeights();
    }

    public float getHeaderHeight() {
        float f2 = 0.0f;
        int n2 = Math.min(this.rows.size(), this.headerRows);
        for (int i2 = 0; i2 < n2; ++i2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i2);
            f2 += pdfPRow.getMaxHeights();
        }
        return f2;
    }

    public boolean deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n2);
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.headerRows = n2;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public int type() {
        return 23;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f2) {
        this.widthPercentage = f2;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public PdfPRow a(int n2) {
        return (PdfPRow)this.rows.get(n2);
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        this.tableEvent = pdfPTableEvent;
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    public float[][] a(float f2, int n2, int n3, boolean bl2) {
        float[][] fArrayArray = new float[(bl2 ? this.headerRows : 0) + n3 - n2][];
        if (this.isColspan) {
            int n4 = 0;
            if (bl2) {
                for (int i2 = 0; i2 < this.headerRows; ++i2) {
                    fArrayArray[n4++] = ((PdfPRow)this.rows.get(i2)).a(f2);
                }
            }
            while (n2 < n3) {
                fArrayArray[n4++] = ((PdfPRow)this.rows.get(n2)).a(f2);
                ++n2;
            }
        } else {
            int n5;
            float[] fArray = new float[this.absoluteWidths.length + 1];
            fArray[0] = f2;
            for (n5 = 0; n5 < this.absoluteWidths.length; ++n5) {
                fArray[n5 + 1] = fArray[n5] + this.absoluteWidths[n5];
            }
            for (n5 = 0; n5 < fArrayArray.length; ++n5) {
                fArrayArray[n5] = fArray;
            }
        }
        return fArrayArray;
    }

    public boolean getSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public void setSkipFirstHeader(boolean bl2) {
        this.skipFirstHeader = bl2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new RuntimeException("Invalid run direction: " + n2);
        }
        this.runDirection = n2;
    }

    public int getRunDirection() {
        return this.runDirection;
    }
}

