/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;

public class PdfPCell
extends Rectangle {
    private int horizontalAlignment = 0;
    private int verticalAlignment = 4;
    private float paddingLeft = 2.0f;
    private float paddingRight = 2.0f;
    private float paddingTop = 2.0f;
    private float paddingBottom = 2.0f;
    public float fixedLeading = 0.0f;
    public float multipliedLeading = 1.0f;
    public float extraParagraphSpace = 0.0f;
    public float indent = 0.0f;
    public float followingIndent = 0.0f;
    public float rightIndent = 0.0f;
    public Phrase phrase;
    private float fixedHeight = 0.0f;
    private boolean noWrap = false;
    private PdfPTable table;
    private float minimumHeight;
    private int colspan = 1;
    private float spaceCharRatio = 0.0f;
    public int runDirection = 0;
    private Image image;
    private PdfPCellEvent cellEvent;
    private int arabicOptions = 0;
    private boolean useDescender;

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
    }

    public PdfPCell(Image image) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
        this.fixedLeading = 0.0f;
        this.multipliedLeading = 1.0f;
        this.setPadding(0.0f);
    }

    public PdfPCell(Image image, boolean bl2) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        if (bl2) {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.image = image;
            this.fixedLeading = 0.0f;
            this.multipliedLeading = 1.0f;
            this.setPadding(this.borderWidth / 2.0f);
        } else {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
            this.fixedLeading = 0.0f;
            this.multipliedLeading = 1.0f;
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(PdfPTable pdfPTable) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.fixedLeading = 0.0f;
        this.multipliedLeading = 1.0f;
        this.setPadding(0.0f);
        this.table = pdfPTable;
    }

    public PdfPCell(PdfPCell pdfPCell) {
        super(pdfPCell.llx, pdfPCell.lly, pdfPCell.urx, pdfPCell.ury);
        this.border = pdfPCell.border;
        this.borderWidth = pdfPCell.borderWidth;
        this.color = pdfPCell.color;
        this.background = pdfPCell.background;
        this.grayFill = pdfPCell.grayFill;
        this.horizontalAlignment = pdfPCell.horizontalAlignment;
        this.verticalAlignment = pdfPCell.verticalAlignment;
        this.paddingLeft = pdfPCell.paddingLeft;
        this.paddingRight = pdfPCell.paddingRight;
        this.paddingTop = pdfPCell.paddingTop;
        this.paddingBottom = pdfPCell.paddingBottom;
        this.fixedLeading = pdfPCell.fixedLeading;
        this.multipliedLeading = pdfPCell.multipliedLeading;
        this.extraParagraphSpace = pdfPCell.extraParagraphSpace;
        this.indent = pdfPCell.indent;
        this.followingIndent = pdfPCell.followingIndent;
        this.rightIndent = pdfPCell.rightIndent;
        this.phrase = pdfPCell.phrase;
        this.fixedHeight = pdfPCell.fixedHeight;
        this.minimumHeight = pdfPCell.minimumHeight;
        this.noWrap = pdfPCell.noWrap;
        this.colspan = pdfPCell.colspan;
        this.spaceCharRatio = pdfPCell.spaceCharRatio;
        this.runDirection = pdfPCell.runDirection;
        if (pdfPCell.table != null) {
            this.table = new PdfPTable(pdfPCell.table);
        }
        this.image = Image.getInstance(pdfPCell.image);
        this.cellEvent = pdfPCell.cellEvent;
        this.arabicOptions = pdfPCell.arabicOptions;
        this.useDescender = pdfPCell.useDescender;
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setPhrase(Phrase phrase) {
        this.phrase = phrase;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n2) {
        this.verticalAlignment = n2;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float f2) {
        this.paddingLeft = f2;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float f2) {
        this.paddingRight = f2;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float f2) {
        this.paddingTop = f2;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float f2) {
        this.paddingBottom = f2;
    }

    public void setPadding(float f2) {
        this.paddingBottom = f2;
        this.paddingTop = f2;
        this.paddingLeft = f2;
        this.paddingRight = f2;
    }

    public void setLeading(float f2, float f3) {
        this.fixedLeading = f2;
        this.multipliedLeading = f3;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setIndent(float f2) {
        this.indent = f2;
    }

    public float getIndent() {
        return this.indent;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(float f2) {
        this.fixedHeight = f2;
        this.minimumHeight = 0.0f;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean bl2) {
        this.noWrap = bl2;
    }

    public PdfPTable a() {
        return this.table;
    }

    public void a(PdfPTable pdfPTable) {
        this.table = pdfPTable;
    }

    public float getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(float f2) {
        this.minimumHeight = f2;
        this.fixedHeight = 0.0f;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int n2) {
        this.colspan = n2;
    }

    public void setFollowingIndent(float f2) {
        this.followingIndent = f2;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f2) {
        this.rightIndent = f2;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new RuntimeException("Invalid run direction: " + n2);
        }
        this.runDirection = n2;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public PdfPCellEvent getCellEvent() {
        return this.cellEvent;
    }

    public void setCellEvent(PdfPCellEvent pdfPCellEvent) {
        this.cellEvent = pdfPCellEvent;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n2) {
        this.arabicOptions = n2;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseDescender(boolean bl2) {
        this.useDescender = bl2;
    }
}

