/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PdfGraphics2D
extends Graphics2D {
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private BasicStroke strokeOne = new BasicStroke(1.0f);
    private static AffineTransform IDENTITY = new AffineTransform();
    private Font font;
    private BaseFont baseFont;
    private float fontSize;
    private AffineTransform transform;
    private Paint paint;
    private Color background;
    private float width;
    private float height;
    private Area clip;
    private RenderingHints rhints = new RenderingHints(null);
    private Stroke stroke;
    private Stroke originalStroke;
    private PdfContentByte cb;
    private HashMap baseFonts;
    private boolean disposeCalled = false;
    private FontMapper fontMapper;
    private PdfFontMetrics fontMetrics;
    private ArrayList kids;
    private boolean kid = false;
    private Graphics dg2 = new BufferedImage(2, 2, 1).getGraphics();
    private boolean onlyShapes = false;
    private Stroke oldStroke;
    private Paint paintFill;
    private Paint paintStroke;
    private MediaTracker mediaTracker;
    public boolean underline;
    public PdfGState[] fillGState = new PdfGState[256];
    public PdfGState[] strokeGState = new PdfGState[256];
    public int currentFillGState = 255;
    public int currentStrokeGState = 255;
    public static int AFM_DIVISOR = 1000;

    private PdfGraphics2D() {
    }

    public PdfGraphics2D(PdfContentByte pdfContentByte, float f2, float f3, FontMapper fontMapper) {
        this.transform = new AffineTransform();
        this.baseFonts = new HashMap();
        this.fontMapper = fontMapper;
        this.kids = new ArrayList();
        if (this.fontMapper == null) {
            this.fontMapper = new DefaultFontMapper();
        }
        this.paint = Color.black;
        this.background = Color.white;
        this.setFont(new Font("sanserif", 0, 12));
        this.cb = pdfContentByte;
        pdfContentByte.saveState();
        this.width = f2;
        this.height = f3;
        this.clip = new Area(new Rectangle2D.Float(0.0f, 0.0f, f2, f3));
        this.clip(this.clip);
        this.stroke = this.oldStroke = this.strokeOne;
        this.originalStroke = this.oldStroke;
        this.setStrokeDiff(this.stroke, null);
        pdfContentByte.saveState();
    }

    public PdfGraphics2D(PdfContentByte pdfContentByte, float f2, float f3) {
        this.onlyShapes = true;
        this.transform = new AffineTransform();
        this.kids = new ArrayList();
        this.paint = Color.black;
        this.background = Color.white;
        this.setFont(new Font("sanserif", 0, 12));
        this.cb = pdfContentByte;
        pdfContentByte.saveState();
        this.width = f2;
        this.height = f3;
        this.clip = new Area(new Rectangle2D.Float(0.0f, 0.0f, f2, f3));
        this.clip(this.clip);
        this.stroke = this.oldStroke = this.strokeOne;
        this.originalStroke = this.oldStroke;
        this.setStrokeDiff(this.stroke, null);
        pdfContentByte.saveState();
    }

    public void draw(Shape shape) {
        this.followPath(shape, 2);
    }

    public boolean drawImage(java.awt.Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.drawImage(image, null, affineTransform, null, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        BufferedImage bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        bufferedImage2 = bufferedImageOp.filter(bufferedImage, bufferedImage2);
        this.drawImage((java.awt.Image)bufferedImage2, n2, n3, null);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            int n2 = renderedImage.getWidth();
            int n3 = renderedImage.getHeight();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
            boolean bl2 = colorModel.isAlphaPremultiplied();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = renderedImage.getPropertyNames();
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashtable.put(stringArray[i2], renderedImage.getProperty(stringArray[i2]));
                }
            }
            BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, hashtable);
            renderedImage.copyData(writableRaster);
            bufferedImage = bufferedImage2;
        }
        this.drawImage(bufferedImage, affineTransform, null);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public static double asPoints(double d2, int n2) {
        return d2 * (double)n2 / (double)AFM_DIVISOR;
    }

    public void doAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        this.underline = false;
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAttributes().keySet();
        Iterator<AttributedCharacterIterator.Attribute> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            TextAttribute textAttribute = (TextAttribute)iterator.next();
            if (textAttribute.equals(TextAttribute.FONT)) {
                object = (Font)attributedCharacterIterator.getAttributes().get(textAttribute);
                this.setFont((Font)object);
                continue;
            }
            if (textAttribute.equals(TextAttribute.UNDERLINE)) {
                if (attributedCharacterIterator.getAttributes().get(textAttribute) != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (textAttribute.equals(TextAttribute.SUPERSCRIPT)) continue;
            if (textAttribute.equals(TextAttribute.SIZE)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                Font font = null;
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    font = this.getFont().deriveFont(this.getFont().getStyle(), n2);
                } else if (object instanceof Float) {
                    float f2 = ((Float)object).floatValue();
                    font = this.getFont().deriveFont(this.getFont().getStyle(), f2);
                } else {
                    return;
                }
                this.setFont(font);
                continue;
            }
            object = "only FONT/SIZE/UNDERLINE/SUPERSCRIPT supported";
            throw new RuntimeException((String)object);
        }
    }

    public void drawString(String string, float f2, float f3) {
        this.setFillPaint();
        if (this.onlyShapes) {
            TextLayout textLayout = new TextLayout(string, this.font, new FontRenderContext(new AffineTransform(), false, true));
            textLayout.draw(this, f2, f3);
        } else {
            AffineTransform affineTransform = this.getTransform();
            AffineTransform affineTransform2 = this.getTransform();
            affineTransform2.translate(f2, f3);
            affineTransform2.concatenate(this.font.getTransform());
            this.setTransform(affineTransform2);
            AffineTransform affineTransform3 = this.normalizeMatrix();
            AffineTransform affineTransform4 = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform3.concatenate(affineTransform4);
            double[] dArray = new double[6];
            affineTransform3.getMatrix(dArray);
            this.cb.beginText();
            this.cb.setFontAndSize(this.baseFont, this.fontSize);
            this.cb.setTextMatrix((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
            this.cb.showText(string);
            this.cb.endText();
            this.setTransform(affineTransform);
            if (this.underline) {
                int n2 = -100;
                int n3 = 50;
                FontMetrics fontMetrics = this.getFontMetrics();
                double d2 = fontMetrics.stringWidth(string);
                double d3 = PdfGraphics2D.asPoints(n3, (int)this.fontSize);
                this.setStroke(new BasicStroke((float)d3));
                f3 = (float)((double)f3 + PdfGraphics2D.asPoints(-n3, (int)this.fontSize));
                Line2D.Double double_ = new Line2D.Double(f2, f3, d2 + (double)f2, f3);
                this.draw(double_);
            }
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex());
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            if (attributedCharacterIterator.getIndex() == attributedCharacterIterator.getRunStart()) {
                if (stringBuffer.length() > 0) {
                    this.drawString(stringBuffer.toString(), f2, f3);
                    FontMetrics fontMetrics = this.getFontMetrics();
                    f2 = (float)((double)f2 + fontMetrics.getStringBounds(stringBuffer.toString(), this).getWidth());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                this.doAttributes(attributedCharacterIterator);
            }
            stringBuffer.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), f2, f3);
        this.underline = false;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        Shape shape = glyphVector.getOutline(f2, f3);
        this.fill(shape);
    }

    public void fill(Shape shape) {
        this.followPath(shape, 1);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        if (bl2) {
            shape = this.stroke.createStrokedShape(shape);
        }
        shape = this.transform.createTransformedShape(shape);
        Area area = new Area(shape);
        if (this.clip != null) {
            area.intersect(this.clip);
        }
        return area.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)this.dg2).getDeviceConfiguration();
    }

    public void setComposite(Composite composite) {
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        float f2 = (float)Math.sqrt(Math.abs(this.transform.getDeterminant()));
        float[] fArray = basicStroke.getDashArray();
        if (fArray != null) {
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] * f2;
            }
        }
        return new BasicStroke(basicStroke.getLineWidth() * f2, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, basicStroke.getDashPhase() * f2);
    }

    private void setStrokeDiff(Stroke stroke, Stroke stroke2) {
        if (stroke == stroke2) {
            return;
        }
        if (!(stroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        boolean bl2 = stroke2 instanceof BasicStroke;
        BasicStroke basicStroke2 = null;
        if (bl2) {
            basicStroke2 = (BasicStroke)stroke2;
        }
        if (!bl2 || basicStroke.getLineWidth() != basicStroke2.getLineWidth()) {
            this.cb.setLineWidth(basicStroke.getLineWidth());
        }
        if (!bl2 || basicStroke.getEndCap() != basicStroke2.getEndCap()) {
            switch (basicStroke.getEndCap()) {
                case 0: {
                    this.cb.setLineCap(0);
                    break;
                }
                case 2: {
                    this.cb.setLineCap(2);
                    break;
                }
                default: {
                    this.cb.setLineCap(1);
                }
            }
        }
        if (!bl2 || basicStroke.getLineJoin() != basicStroke2.getLineJoin()) {
            switch (basicStroke.getLineJoin()) {
                case 0: {
                    this.cb.setLineJoin(0);
                    break;
                }
                case 2: {
                    this.cb.setLineJoin(2);
                    break;
                }
                default: {
                    this.cb.setLineJoin(1);
                }
            }
        }
        if (!bl2 || basicStroke.getMiterLimit() != basicStroke2.getMiterLimit()) {
            this.cb.setMiterLimit(basicStroke.getMiterLimit());
        }
        boolean bl3 = bl2 ? (basicStroke.getDashArray() != null ? (basicStroke.getDashPhase() != basicStroke2.getDashPhase() ? true : !Arrays.equals(basicStroke.getDashArray(), basicStroke2.getDashArray())) : basicStroke2.getDashArray() != null) : true;
        if (bl3) {
            float[] fArray = basicStroke.getDashArray();
            if (fArray == null) {
                this.cb.setLiteral("[]0 d\n");
            } else {
                this.cb.setLiteral('[');
                int n2 = fArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.cb.setLiteral(fArray[i2]);
                    this.cb.setLiteral(' ');
                }
                this.cb.setLiteral(']');
                this.cb.setLiteral(basicStroke.getDashPhase());
                this.cb.setLiteral(" d\n");
            }
        }
    }

    public void setStroke(Stroke stroke) {
        this.originalStroke = stroke;
        this.stroke = this.transformStroke(stroke);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.rhints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.rhints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.rhints.clear();
        this.rhints.putAll((Map<?, ?>)map);
    }

    public void addRenderingHints(Map map) {
        this.rhints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return this.rhints;
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
    }

    public void rotate(double d2) {
        this.transform.rotate(d2);
    }

    public void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
    }

    public void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = new AffineTransform(affineTransform);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.originalStroke;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics create() {
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D();
        pdfGraphics2D.onlyShapes = this.onlyShapes;
        pdfGraphics2D.transform = new AffineTransform(this.transform);
        pdfGraphics2D.baseFonts = this.baseFonts;
        pdfGraphics2D.fontMapper = this.fontMapper;
        pdfGraphics2D.kids = this.kids;
        pdfGraphics2D.paint = this.paint;
        pdfGraphics2D.fillGState = this.fillGState;
        pdfGraphics2D.strokeGState = this.strokeGState;
        pdfGraphics2D.background = this.background;
        pdfGraphics2D.mediaTracker = this.mediaTracker;
        pdfGraphics2D.setFont(this.font);
        pdfGraphics2D.cb = this.cb.getDuplicate();
        pdfGraphics2D.cb.saveState();
        pdfGraphics2D.width = this.width;
        pdfGraphics2D.height = this.height;
        pdfGraphics2D.followPath(new Area(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height)), 3);
        if (this.clip != null) {
            pdfGraphics2D.clip = new Area(this.clip);
        }
        pdfGraphics2D.stroke = this.stroke;
        pdfGraphics2D.originalStroke = this.originalStroke;
        pdfGraphics2D.strokeOne = (BasicStroke)pdfGraphics2D.transformStroke(pdfGraphics2D.strokeOne);
        pdfGraphics2D.oldStroke = pdfGraphics2D.strokeOne;
        pdfGraphics2D.setStrokeDiff(pdfGraphics2D.oldStroke, null);
        pdfGraphics2D.cb.saveState();
        if (pdfGraphics2D.clip != null) {
            pdfGraphics2D.followPath(pdfGraphics2D.clip, 3);
        }
        pdfGraphics2D.kid = true;
        ArrayList arrayList = this.kids;
        synchronized (arrayList) {
            this.kids.add(pdfGraphics2D);
        }
        return pdfGraphics2D;
    }

    public PdfContentByte getContent() {
        return this.cb;
    }

    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return Color.black;
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.onlyShapes) {
            this.font = font;
            return;
        }
        if (font == this.font) {
            return;
        }
        this.fontMetrics = null;
        this.font = font;
        this.fontSize = font.getSize2D();
        this.baseFont = this.getCachedBaseFont(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFont getCachedBaseFont(Font font) {
        HashMap hashMap = this.baseFonts;
        synchronized (hashMap) {
            BaseFont baseFont = (BaseFont)this.baseFonts.get(font.getFontName());
            if (baseFont == null) {
                baseFont = this.fontMapper.awtToPdf(font);
                this.baseFonts.put(font.getFontName(), baseFont);
            }
            return baseFont;
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.onlyShapes) {
            return this.dg2.getFontMetrics(font);
        }
        if (font == this.font) {
            if (this.fontMetrics == null) {
                this.fontMetrics = new PdfFontMetrics(this, font, this.getCachedBaseFont(font), null);
            }
            return this.fontMetrics;
        }
        return new PdfFontMetrics(this, font, this.getCachedBaseFont(font), null);
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n2, n3, n4, n5);
        this.clip(double_);
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n2, n3, n4, n5);
        this.setClip(double_);
    }

    public void clip(Shape shape) {
        if (shape != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        if (this.clip == null) {
            this.clip = new Area(shape);
        } else {
            this.clip.intersect(new Area(shape));
        }
        this.followPath(shape, 3);
    }

    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setClip(Shape shape) {
        this.cb.restoreState();
        this.cb.saveState();
        if (shape != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        if (shape == null) {
            this.clip = null;
        } else {
            this.clip = new Area(shape);
            this.followPath(shape, 3);
        }
        this.paintStroke = null;
        this.paintFill = null;
        this.currentStrokeGState = 255;
        this.currentFillGState = 255;
        this.oldStroke = this.strokeOne;
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        Line2D.Double double_ = new Line2D.Double(n2, n3, n4, n5);
        this.draw(double_);
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        this.draw(new Rectangle(n2, n3, n4, n5));
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle(n2, n3, n4, n5));
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.paint;
        this.setPaint(this.background);
        this.fillRect(n2, n3, n4, n5);
        this.setPaint(paint);
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7);
        this.draw(double_);
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7);
        this.fill(double_);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n2, n3, n4, n5);
        this.draw(float_);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n2, n3, n4, n5);
        this.fill(float_);
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        Arc2D.Double double_ = new Arc2D.Double(n2, n3, n4, n5, n6, n7, 0);
        this.draw(double_);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        Arc2D.Double double_ = new Arc2D.Double(n2, n3, n4, n5, n6, n7, 2);
        this.fill(double_);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        Line2D.Double double_ = new Line2D.Double(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            ((Line2D)double_).setLine(((Line2D)double_).getX2(), ((Line2D)double_).getY2(), nArray[i2], nArray2[i2]);
            this.draw(double_);
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < n2; ++i2) {
            polygon.addPoint(nArray[i2], nArray2[i2]);
        }
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < n2; ++i2) {
            polygon.addPoint(nArray[i2], nArray2[i2]);
        }
        this.fill(polygon);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        this.waitForImage(image);
        return this.drawImage(image, n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.waitForImage(image);
        double d2 = (double)n4 / (double)image.getWidth(imageObserver);
        double d3 = (double)n5 / (double)image.getHeight(imageObserver);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n3);
        affineTransform.scale(d2, d3);
        return this.drawImage(image, null, affineTransform, color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        this.waitForImage(image);
        double d2 = (double)n4 - (double)n2;
        double d3 = (double)n5 - (double)n3;
        double d4 = (double)n8 - (double)n6;
        double d5 = (double)n9 - (double)n7;
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            return true;
        }
        double d6 = d2 / d4;
        double d7 = d3 / d5;
        double d8 = (double)n6 * d6;
        double d9 = (double)n7 * d7;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)n2 - d8, (double)n3 - d9);
        affineTransform.scale(d6, d7);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(imageObserver), image.getHeight(imageObserver), 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.fillRect(n6, n7, (int)d4, (int)d5);
        this.drawImage(image, bufferedImage, affineTransform, null, imageObserver);
        return true;
    }

    public void dispose() {
        if (this.kid) {
            return;
        }
        if (!this.disposeCalled) {
            this.disposeCalled = true;
            this.cb.restoreState();
            this.cb.restoreState();
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)this.kids.get(i2);
                pdfGraphics2D.cb.restoreState();
                pdfGraphics2D.cb.restoreState();
                this.cb.add(pdfGraphics2D.cb);
            }
        }
    }

    private void followPath(Shape shape, int n2) {
        if (shape == null) {
            return;
        }
        if (n2 == 2 && !(this.stroke instanceof BasicStroke)) {
            shape = this.stroke.createStrokedShape(shape);
            this.followPath(shape, 1);
            return;
        }
        if (n2 == 2) {
            this.setStrokeDiff(this.stroke, this.oldStroke);
            this.oldStroke = this.stroke;
            this.setStrokePaint();
        } else if (n2 == 1) {
            this.setFillPaint();
        }
        PathIterator pathIterator = n2 == 3 ? shape.getPathIterator(IDENTITY) : shape.getPathIterator(this.transform);
        float[] fArray = new float[6];
        int n3 = 0;
        while (!pathIterator.isDone()) {
            ++n3;
            int n4 = pathIterator.currentSegment(fArray);
            this.normalizeY(fArray);
            switch (n4) {
                case 4: {
                    this.cb.closePath();
                    break;
                }
                case 3: {
                    this.cb.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 1: {
                    this.cb.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 0: {
                    this.cb.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.cb.curveTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
        switch (n2) {
            case 1: {
                if (n3 <= 0) break;
                if (pathIterator.getWindingRule() == 0) {
                    this.cb.eoFill();
                    break;
                }
                this.cb.fill();
                break;
            }
            case 2: {
                if (n3 <= 0) break;
                this.cb.stroke();
                break;
            }
            default: {
                if (n3 == 0) {
                    this.cb.rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (pathIterator.getWindingRule() == 0) {
                    this.cb.eoClip();
                } else {
                    this.cb.clip();
                }
                this.cb.newPath();
            }
        }
    }

    private float normalizeY(float f2) {
        return this.height - f2;
    }

    private void normalizeY(float[] fArray) {
        fArray[1] = this.normalizeY(fArray[1]);
        fArray[3] = this.normalizeY(fArray[3]);
        fArray[5] = this.normalizeY(fArray[5]);
    }

    private AffineTransform normalizeMatrix() {
        double[] dArray = new double[6];
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        affineTransform.getMatrix(dArray);
        dArray[3] = -1.0;
        dArray[5] = this.height;
        affineTransform = new AffineTransform(dArray);
        affineTransform.concatenate(this.transform);
        return affineTransform;
    }

    private boolean drawImage(java.awt.Image image, java.awt.Image image2, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        if (affineTransform == null) {
            return true;
        }
        affineTransform.translate(0.0, image.getHeight(imageObserver));
        affineTransform.scale(image.getWidth(imageObserver), image.getHeight(imageObserver));
        AffineTransform affineTransform2 = this.normalizeMatrix();
        AffineTransform affineTransform3 = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform2.concatenate(affineTransform);
        affineTransform2.concatenate(affineTransform3);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        try {
            Image image3 = Image.getInstance(image, color);
            if (image2 != null) {
                Image image4 = Image.getInstance(image2, null, true);
                image4.makeMask();
                image4.setInvertMask(true);
                image3.setImageMask(image4);
            }
            this.cb.addImage(image3, (float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private boolean checkNewPaint(Paint paint) {
        if (this.paint == paint) {
            return false;
        }
        return !(this.paint instanceof Color) || !this.paint.equals(paint);
    }

    private void setFillPaint() {
        if (this.checkNewPaint(this.paintFill)) {
            this.paintFill = this.paint;
            this.setPaint(false, 0.0, 0.0, true);
        }
    }

    private void setStrokePaint() {
        if (this.checkNewPaint(this.paintStroke)) {
            this.paintStroke = this.paint;
            this.setPaint(false, 0.0, 0.0, false);
        }
    }

    private void setPaint(boolean bl2, double d2, double d3, boolean bl3) {
        block25: {
            if (this.paint instanceof Color) {
                Color color = (Color)this.paint;
                int n2 = color.getAlpha();
                if (bl3) {
                    if (n2 != this.currentFillGState) {
                        this.currentFillGState = n2;
                        PdfGState pdfGState = this.fillGState[n2];
                        if (pdfGState == null) {
                            pdfGState = new PdfGState();
                            pdfGState.setFillOpacity((float)n2 / 255.0f);
                            this.fillGState[n2] = pdfGState;
                        }
                        this.cb.setGState(pdfGState);
                    }
                    this.cb.setColorFill(color);
                } else {
                    if (n2 != this.currentStrokeGState) {
                        this.currentStrokeGState = n2;
                        PdfGState pdfGState = this.strokeGState[n2];
                        if (pdfGState == null) {
                            pdfGState = new PdfGState();
                            pdfGState.setStrokeOpacity((float)n2 / 255.0f);
                            this.strokeGState[n2] = pdfGState;
                        }
                        this.cb.setGState(pdfGState);
                    }
                    this.cb.setColorStroke(color);
                }
            } else if (this.paint instanceof GradientPaint) {
                GradientPaint gradientPaint = (GradientPaint)this.paint;
                Point2D point2D = gradientPaint.getPoint1();
                this.transform.transform(point2D, point2D);
                Point2D point2D2 = gradientPaint.getPoint2();
                this.transform.transform(point2D2, point2D2);
                Color color = gradientPaint.getColor1();
                Color color2 = gradientPaint.getColor2();
                PdfShading pdfShading = PdfShading.simpleAxial(this.cb.getPdfWriter(), (float)point2D.getX(), this.normalizeY((float)point2D.getY()), (float)point2D2.getX(), this.normalizeY((float)point2D2.getY()), color, color2);
                PdfShadingPattern pdfShadingPattern = new PdfShadingPattern(pdfShading);
                if (bl3) {
                    this.cb.setShadingFill(pdfShadingPattern);
                } else {
                    this.cb.setShadingStroke(pdfShadingPattern);
                }
            } else if (this.paint instanceof TexturePaint) {
                try {
                    TexturePaint texturePaint = (TexturePaint)this.paint;
                    BufferedImage bufferedImage = texturePaint.getImage();
                    Rectangle2D rectangle2D = texturePaint.getAnchorRect();
                    Image image = Image.getInstance(bufferedImage, null);
                    PdfPatternPainter pdfPatternPainter = this.cb.createPattern(image.width(), image.height());
                    AffineTransform affineTransform = this.normalizeMatrix();
                    affineTransform.scale(rectangle2D.getWidth() / (double)image.width(), -rectangle2D.getHeight() / (double)image.height());
                    double[] dArray = new double[6];
                    affineTransform.getMatrix(dArray);
                    pdfPatternPainter.setPatternMatrix((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
                    image.setAbsolutePosition(0.0f, 0.0f);
                    pdfPatternPainter.addImage(image);
                    if (bl3) {
                        this.cb.setPatternFill(pdfPatternPainter);
                        break block25;
                    }
                    this.cb.setPatternStroke(pdfPatternPainter);
                }
                catch (Exception exception) {
                    if (bl3) {
                        this.cb.setColorFill(Color.gray);
                        break block25;
                    }
                    this.cb.setColorStroke(Color.gray);
                }
            } else {
                try {
                    Object object;
                    BufferedImage bufferedImage = null;
                    int n3 = 6;
                    if (this.paint.getTransparency() == 1) {
                        n3 = 5;
                    }
                    bufferedImage = new BufferedImage((int)this.width, (int)this.height, n3);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.transform(this.transform);
                    AffineTransform affineTransform = this.transform.createInverse();
                    Shape shape = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
                    shape = affineTransform.createTransformedShape(shape);
                    graphics2D.setPaint(this.paint);
                    graphics2D.fill(shape);
                    if (bl2) {
                        object = new AffineTransform();
                        ((AffineTransform)object).scale(1.0, -1.0);
                        ((AffineTransform)object).translate(-d2, -d3);
                        graphics2D.drawImage(bufferedImage, (AffineTransform)object, null);
                    }
                    object = Image.getInstance(bufferedImage, null);
                    PdfPatternPainter pdfPatternPainter = this.cb.createPattern(this.width, this.height);
                    ((Image)object).setAbsolutePosition(0.0f, 0.0f);
                    pdfPatternPainter.addImage((Image)object);
                    if (bl3) {
                        this.cb.setPatternFill(pdfPatternPainter);
                    } else {
                        this.cb.setPatternStroke(pdfPatternPainter);
                    }
                }
                catch (Exception exception) {
                    if (bl3) {
                        this.cb.setColorFill(Color.gray);
                    }
                    this.cb.setColorStroke(Color.gray);
                }
            }
        }
    }

    private synchronized void waitForImage(java.awt.Image image) {
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(new fakeComponent(null));
        }
        this.mediaTracker.addImage(image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mediaTracker.removeImage(image);
    }

    public static class 1 {
    }

    private static class fakeComponent
    extends Component {
        private fakeComponent() {
        }

        public fakeComponent(1 var1_1) {
            this();
        }
    }

    public class PdfFontMetrics
    extends FontMetrics {
        private BaseFont bf;
        private float fontSize;
        private double ascent;
        private double descent;
        private double leading;
        private double maxAdvance;
        private int[] widths;
        private double scaleX;
        private double scaleY;
        private final PdfGraphics2D this$0;

        private PdfFontMetrics(PdfGraphics2D pdfGraphics2D, Font font, BaseFont baseFont) {
            super(font);
            this.this$0 = pdfGraphics2D;
            this.ascent = -1.0;
            this.descent = -1.0;
            this.leading = -1.0;
            this.maxAdvance = -1.0;
            this.bf = baseFont;
            this.fontSize = font.getSize2D();
            AffineTransform affineTransform = font.getTransform();
            this.scaleX = affineTransform.getScaleX();
            this.scaleY = affineTransform.getScaleY();
        }

        public int getAscent() {
            if (this.ascent < 0.0) {
                this.ascent = (double)this.bf.getFontDescriptor(9, this.fontSize) * this.scaleY;
            }
            return (int)(0.9999 + this.ascent * 1.1);
        }

        public int getDescent() {
            if (this.descent < 0.0) {
                this.descent = (double)(-this.bf.getFontDescriptor(10, this.fontSize)) * this.scaleY;
            }
            return (int)(0.9999 + this.descent);
        }

        public int getLeading() {
            if (this.leading < 0.0) {
                this.leading = (double)this.bf.getFontDescriptor(11, this.fontSize) * this.scaleY;
            }
            return (int)(0.9999 + this.leading);
        }

        public int getMaxAdvance() {
            if (this.maxAdvance < 0.0) {
                this.maxAdvance = (double)this.bf.getFontDescriptor(12, this.fontSize) * this.scaleX;
            }
            return (int)(0.9999 + this.maxAdvance);
        }

        public int[] getWidths() {
            if (this.widths == null) {
                this.widths = new int[256];
                for (char c2 = '\u0000'; c2 < '\u0100'; c2 = (char)(c2 + '\u0001')) {
                    this.widths[c2] = this.charWidth(c2);
                }
            }
            return this.widths;
        }

        public int charWidth(char c2) {
            return (int)((double)this.bf.getWidthPoint(c2, this.fontSize) * this.scaleX);
        }

        public int stringWidth(String string) {
            return (int)((double)this.bf.getWidthPoint(string, this.fontSize) * this.scaleX);
        }

        public Rectangle2D getStringBounds(String string, Graphics graphics) {
            char[] cArray = string.toCharArray();
            return this.getStringBounds(cArray, 0, cArray.length, graphics);
        }

        public Rectangle2D getStringBounds(String string, int n2, int n3, Graphics graphics) {
            String string2 = string.substring(n2, n3);
            return this.getStringBounds(string2, graphics);
        }

        public Rectangle2D getStringBounds(char[] cArray, int n2, int n3, Graphics graphics) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + n2);
            }
            if (n3 > cArray.length) {
                throw new IndexOutOfBoundsException("limit: " + n3);
            }
            if (n2 > n3) {
                throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
            }
            String string = new String(cArray, n2, n3 - n2);
            return new Rectangle2D.Float(0.0f, -this.getAscent(), (float)((double)this.bf.getWidthPoint(string, this.fontSize) * this.scaleX), this.getHeight());
        }

        public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n2, int n3, Graphics graphics) {
            int n4 = characterIterator.getBeginIndex();
            int n5 = characterIterator.getEndIndex();
            if (n2 < n4) {
                throw new IndexOutOfBoundsException("beginIndex: " + n2);
            }
            if (n3 > n5) {
                throw new IndexOutOfBoundsException("limit: " + n3);
            }
            if (n2 > n3) {
                throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
            }
            char[] cArray = new char[n3 - n2];
            characterIterator.setIndex(n2);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = characterIterator.current();
                characterIterator.next();
            }
            return this.getStringBounds(cArray, 0, cArray.length, graphics);
        }

        public Rectangle2D getMaxCharBounds(Graphics graphics) {
            return this.getStringBounds("M", graphics);
        }

        public PdfFontMetrics(PdfGraphics2D pdfGraphics2D, Font font, BaseFont baseFont, 1 var4_4) {
            this(pdfGraphics2D, font, baseFont);
        }
    }
}

