/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import java.security.MessageDigest;

public class PdfEncryption {
    public static final byte[] h = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    public byte[] l = new byte[256];
    public int n;
    public int k;
    public byte[] f;
    public int m;
    public byte[] j;
    public byte[] b = new byte[5];
    public MessageDigest c;
    public byte[] g = new byte[32];
    public byte[] d = new byte[32];
    public int i;
    public byte[] e;
    public static long a = System.currentTimeMillis();

    public PdfEncryption() {
        try {
            this.c = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(h, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(h, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2, boolean bl2) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.c.digest(byArray2);
        if (bl2) {
            int n2;
            byte[] byArray5 = new byte[16];
            for (n2 = 0; n2 < 50; ++n2) {
                byArray4 = this.c.digest(byArray4);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < byArray5.length; ++i2) {
                    byArray5[i2] = (byte)(byArray4[i2] ^ n2);
                }
                this.prepareRC4Key(byArray5);
                this.encryptRC4(byArray3);
            }
        } else {
            this.prepareRC4Key(byArray4, 0, 5);
            this.encryptRC4(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl2) {
        this.e = byArray;
        this.g = byArray3;
        this.i = n2;
        this.j = new byte[bl2 ? 16 : 5];
        this.c.reset();
        this.c.update(byArray2);
        this.c.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        this.c.update(byArray4, 0, 4);
        if (byArray != null) {
            this.c.update(byArray);
        }
        byte[] byArray5 = this.c.digest();
        if (this.j.length == 16) {
            for (int i2 = 0; i2 < 50; ++i2) {
                byArray5 = this.c.digest(byArray5);
            }
        }
        System.arraycopy(byArray5, 0, this.j, 0, this.j.length);
    }

    private void setupUserKey() {
        if (this.j.length == 16) {
            int n2;
            this.c.update(h);
            byte[] byArray = this.c.digest(this.e);
            System.arraycopy(byArray, 0, this.d, 0, 16);
            for (n2 = 16; n2 < 32; ++n2) {
                this.d[n2] = 0;
            }
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < this.j.length; ++i2) {
                    byArray[i2] = (byte)(this.j[i2] ^ n2);
                }
                this.prepareRC4Key(byArray, 0, this.j.length);
                this.encryptRC4(this.d, 0, 16);
            }
        } else {
            this.prepareRC4Key(this.j);
            this.encryptRC4(h, this.d);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n2, boolean bl2) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.c.digest(PdfEncryption.createDocumentId());
        }
        n2 |= bl2 ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.g = this.computeOwnerKey(byArray3, byArray4, bl2);
        this.e = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.e, byArray3, this.g, n2 &= 0xFFFFFFFC, bl2);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l2 = System.currentTimeMillis();
        long l3 = Runtime.getRuntime().freeMemory();
        String string = l2 + "+" + l3 + "+" + a++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl2) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n2, bl2);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl2) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n2, bl2);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, boolean bl2) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n2, bl2);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, boolean bl2) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2, bl2);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n2, bl2);
        this.setupUserKey();
    }

    public void prepareKey() {
        this.prepareRC4Key(this.f, 0, this.m);
    }

    public void setHashKey(int n2, int n3) {
        this.c.reset();
        this.b[0] = (byte)n2;
        this.b[1] = (byte)(n2 >> 8);
        this.b[2] = (byte)(n2 >> 16);
        this.b[3] = (byte)n3;
        this.b[4] = (byte)(n3 >> 8);
        this.c.update(this.j);
        this.f = this.c.digest(this.b);
        this.m = this.j.length + 5;
        if (this.m > 16) {
            this.m = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n2;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
        pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.a(this.g)));
        pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.a(this.d)));
        pdfDictionary.put(PdfName.P, new PdfNumber(this.i));
        if (this.j.length > 5) {
            pdfDictionary.put(PdfName.V, new PdfNumber(2));
            pdfDictionary.put(PdfName.R, new PdfNumber(3));
            pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            pdfDictionary.put(PdfName.V, new PdfNumber(1));
            pdfDictionary.put(PdfName.R, new PdfNumber(2));
        }
        return pdfDictionary;
    }

    public void prepareRC4Key(byte[] byArray) {
        this.prepareRC4Key(byArray, 0, byArray.length);
    }

    public void prepareRC4Key(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            this.l[n4] = (byte)n4;
        }
        this.n = 0;
        this.k = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n6 = byArray[n5 + n2] + this.l[i2] + n6 & 0xFF;
            n4 = this.l[i2];
            this.l[i2] = this.l[n6];
            this.l[n6] = n4;
            n5 = (n5 + 1) % n3;
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = n3 + n2;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.n = this.n + 1 & 0xFF;
            this.k = this.l[this.n] + this.k & 0xFF;
            byte by2 = this.l[this.n];
            this.l[this.n] = this.l[this.k];
            this.l[this.k] = by2;
            byArray2[i2] = (byte)(byArray[i2] ^ this.l[this.l[this.n] + this.l[this.k] & 0xFF]);
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3) {
        this.encryptRC4(byArray, n2, n3, byArray);
    }

    public void encryptRC4(byte[] byArray, byte[] byArray2) {
        this.encryptRC4(byArray, 0, byArray.length, byArray2);
    }

    public void encryptRC4(byte[] byArray) {
        this.encryptRC4(byArray, 0, byArray.length, byArray);
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.e);
    }
}

