/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfBorderArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfColor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;

public class PdfAnnotation
extends PdfDictionary {
    public static final PdfName HIGHLIGHT_NONE = PdfName.N;
    public static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    public static final PdfName HIGHLIGHT_OUTLINE = PdfName.O;
    public static final PdfName HIGHLIGHT_PUSH = PdfName.P;
    public static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    public static final int FLAGS_INVISIBLE = 1;
    public static final int FLAGS_HIDDEN = 2;
    public static final int FLAGS_PRINT = 4;
    public static final int FLAGS_NOZOOM = 8;
    public static final int FLAGS_NOROTATE = 16;
    public static final int FLAGS_NOVIEW = 32;
    public static final int FLAGS_READONLY = 64;
    public static final PdfName APPEARANCE_NORMAL = PdfName.N;
    public static final PdfName APPEARANCE_ROLLOVER = PdfName.R;
    public static final PdfName APPEARANCE_DOWN = PdfName.D;
    public static final PdfName AA_ENTER = PdfName.E;
    public static final PdfName AA_EXIT = PdfName.X;
    public static final PdfName AA_DOWN = PdfName.D;
    public static final PdfName AA_UP = PdfName.U;
    public static final PdfName AA_FOCUS = PdfName.FO;
    public static final PdfName AA_BLUR = PdfName.BL;
    public static final PdfName AA_JS_KEY = PdfName.K;
    public static final PdfName AA_JS_FORMAT = PdfName.F;
    public static final PdfName AA_JS_CHANGE = PdfName.V;
    public static final PdfName AA_JS_OTHER_CHANGE = PdfName.C;
    public static final int MARKUP_HIGHLIGHT = 0;
    public static final int MARKUP_UNDERLINE = 1;
    public static final int MARKUP_STRIKEOUT = 2;
    public PdfWriter writer;
    public PdfIndirectReference reference;
    public HashMap templates;
    public boolean form = false;
    public boolean annotation = true;
    public boolean used = false;
    private int placeInPage = -1;

    public PdfAnnotation(PdfWriter pdfWriter, Rectangle rectangle) {
        this.writer = pdfWriter;
        if (rectangle != null) {
            this.put(PdfName.RECT, new PdfRectangle(rectangle));
        }
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, PdfString pdfString, PdfString pdfString2) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.TEXT);
        this.put(PdfName.T, pdfString);
        this.put(PdfName.RECT, new PdfRectangle(f2, f3, f4, f5));
        this.put(PdfName.CONTENTS, pdfString2);
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, PdfAction pdfAction) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.LINK);
        this.put(PdfName.RECT, new PdfRectangle(f2, f3, f4, f5));
        this.put(PdfName.A, pdfAction);
        this.put(PdfName.BORDER, new PdfBorderArray(0.0f, 0.0f, 0.0f));
        this.put(PdfName.C, new PdfColor(0, 0, 255));
    }

    public static PdfAnnotation createScreen(PdfWriter pdfWriter, Rectangle rectangle, String string, PdfFileSpecification pdfFileSpecification, String string2, boolean bl2) throws IOException {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.SCREEN);
        pdfAnnotation.put(PdfName.F, new PdfNumber(4));
        pdfAnnotation.put(PdfName.BORDER, new PdfBorderArray(0.0f, 0.0f, 0.0f));
        pdfAnnotation.put(PdfName.C, new PdfColor(0, 0, 255));
        pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
        pdfAnnotation.setPage();
        PdfIndirectReference pdfIndirectReference = pdfAnnotation.d();
        PdfAction pdfAction = PdfAction.rendition(string, pdfFileSpecification, string2, pdfIndirectReference);
        if (bl2) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(new PdfName("PV"), pdfAction);
            pdfAnnotation.put(PdfName.AA, pdfDictionary);
        }
        return pdfAnnotation;
    }

    public PdfIndirectReference d() {
        if (this.reference == null) {
            this.reference = this.writer.getPdfIndirectReference();
        }
        return this.reference;
    }

    public static PdfAnnotation createText(PdfWriter pdfWriter, Rectangle rectangle, String string, String string2, boolean bl2, String string3) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.TEXT);
        if (string != null) {
            pdfAnnotation.put(PdfName.T, new PdfString(string, "UnicodeBig"));
        }
        if (string2 != null) {
            pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string2, "UnicodeBig"));
        }
        if (bl2) {
            pdfAnnotation.put(PdfName.OPEN, PdfBoolean.PDFTRUE);
        }
        if (string3 != null) {
            pdfAnnotation.put(PdfName.NAME, new PdfName(string3));
        }
        return pdfAnnotation;
    }

    public static PdfAnnotation createLink(PdfWriter pdfWriter, Rectangle rectangle, PdfName pdfName) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.LINK);
        if (!pdfName.equals(HIGHLIGHT_INVERT)) {
            pdfAnnotation.put(PdfName.H, pdfName);
        }
        return pdfAnnotation;
    }

    public static PdfAnnotation createLink(PdfWriter pdfWriter, Rectangle rectangle, PdfName pdfName, PdfAction pdfAction) {
        PdfAnnotation pdfAnnotation = PdfAnnotation.createLink(pdfWriter, rectangle, pdfName);
        pdfAnnotation.putEx(PdfName.A, pdfAction);
        return pdfAnnotation;
    }

    public static PdfAnnotation createLink(PdfWriter pdfWriter, Rectangle rectangle, PdfName pdfName, String string) {
        PdfAnnotation pdfAnnotation = PdfAnnotation.createLink(pdfWriter, rectangle, pdfName);
        pdfAnnotation.put(PdfName.DEST, new PdfString(string));
        return pdfAnnotation;
    }

    public static PdfAnnotation createLink(PdfWriter pdfWriter, Rectangle rectangle, PdfName pdfName, int n2, PdfDestination pdfDestination) {
        PdfAnnotation pdfAnnotation = PdfAnnotation.createLink(pdfWriter, rectangle, pdfName);
        PdfIndirectReference pdfIndirectReference = pdfWriter.getPageReference(n2);
        pdfDestination.addPage(pdfIndirectReference);
        pdfAnnotation.put(PdfName.DEST, pdfDestination);
        return pdfAnnotation;
    }

    public static PdfAnnotation createFreeText(PdfWriter pdfWriter, Rectangle rectangle, String string, PdfContentByte pdfContentByte) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.FREETEXT);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        pdfAnnotation.setDefaultAppearanceString(pdfContentByte);
        return pdfAnnotation;
    }

    public static PdfAnnotation createLine(PdfWriter pdfWriter, Rectangle rectangle, String string, float f2, float f3, float f4, float f5) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.LINE);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        PdfArray pdfArray = new PdfArray(new PdfNumber(f2));
        pdfArray.add(new PdfNumber(f3));
        pdfArray.add(new PdfNumber(f4));
        pdfArray.add(new PdfNumber(f5));
        pdfAnnotation.put(PdfName.L, pdfArray);
        return pdfAnnotation;
    }

    public static PdfAnnotation createSquareCirlcle(PdfWriter pdfWriter, Rectangle rectangle, String string, boolean bl2) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        if (bl2) {
            pdfAnnotation.put(PdfName.SUBTYPE, PdfName.SQUARE);
        } else {
            pdfAnnotation.put(PdfName.SUBTYPE, PdfName.CIRCLE);
        }
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        return pdfAnnotation;
    }

    public static PdfAnnotation createMarkup(PdfWriter pdfWriter, Rectangle rectangle, String string, int n2, float[] fArray) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        PdfName pdfName = PdfName.HIGHLIGHT;
        switch (n2) {
            case 1: {
                pdfName = PdfName.UNDERLINE;
                break;
            }
            case 2: {
                pdfName = PdfName.STRIKEOUT;
            }
        }
        pdfAnnotation.put(PdfName.SUBTYPE, pdfName);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        PdfArray pdfArray = new PdfArray();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            pdfArray.add(new PdfNumber(fArray[i2]));
        }
        pdfAnnotation.put(PdfName.QUADPOINTS, pdfArray);
        return pdfAnnotation;
    }

    public static PdfAnnotation createStamp(PdfWriter pdfWriter, Rectangle rectangle, String string, String string2) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.STAMP);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        pdfAnnotation.put(PdfName.NAME, new PdfName(string2));
        return pdfAnnotation;
    }

    public static PdfAnnotation createInk(PdfWriter pdfWriter, Rectangle rectangle, String string, float[][] fArray) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.INK);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        PdfArray pdfArray = new PdfArray();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfArray pdfArray2 = new PdfArray();
            float[] fArray2 = fArray[i2];
            for (int i3 = 0; i3 < fArray2.length; ++i3) {
                pdfArray2.add(new PdfNumber(fArray2[i3]));
            }
            pdfArray.add(pdfArray2);
        }
        pdfAnnotation.put(PdfName.INKLIST, pdfArray);
        return pdfAnnotation;
    }

    public static PdfAnnotation createFileAttachment(PdfWriter pdfWriter, Rectangle rectangle, String string, byte[] byArray, String string2, String string3) throws IOException {
        return PdfAnnotation.createFileAttachment(pdfWriter, rectangle, string, PdfFileSpecification.fileEmbedded(pdfWriter, string2, string3, byArray));
    }

    public static PdfAnnotation createFileAttachment(PdfWriter pdfWriter, Rectangle rectangle, String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.FILEATTACHMENT);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        pdfAnnotation.put(PdfName.FS, pdfFileSpecification.getReference());
        return pdfAnnotation;
    }

    public static PdfAnnotation createPopup(PdfWriter pdfWriter, Rectangle rectangle, String string, boolean bl2) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle);
        pdfAnnotation.put(PdfName.SUBTYPE, PdfName.POPUP);
        pdfAnnotation.put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        if (bl2) {
            pdfAnnotation.put(PdfName.OPEN, PdfBoolean.PDFTRUE);
        }
        return pdfAnnotation;
    }

    public void setDefaultAppearanceString(PdfContentByte pdfContentByte) {
        byte[] byArray = pdfContentByte.a().toByteArray();
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != 10) continue;
            byArray[i2] = 32;
        }
        this.put(PdfName.DA, new PdfString(byArray));
    }

    public void setFlags(int n2) {
        if (n2 == 0) {
            this.remove(PdfName.F);
        } else {
            this.put(PdfName.F, new PdfNumber(n2));
        }
    }

    public void setBorder(PdfBorderArray pdfBorderArray) {
        this.putDel(PdfName.BORDER, pdfBorderArray);
    }

    public void setBorderStyle(PdfBorderDictionary pdfBorderDictionary) {
        this.putDel(PdfName.BS, pdfBorderDictionary);
    }

    public void setAppearance(PdfName pdfName, PdfAppearance pdfAppearance) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        pdfDictionary.put(pdfName, pdfAppearance.g());
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new HashMap();
        }
        this.templates.put(pdfAppearance, null);
    }

    public void setAppearance(PdfName pdfName, String string, PdfAppearance pdfAppearance) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        PdfDictionary pdfDictionary2 = (pdfObject = pdfDictionary.get(pdfName)) != null && pdfObject.isDictionary() ? (PdfDictionary)pdfObject : new PdfDictionary();
        pdfDictionary2.put(new PdfName(string), pdfAppearance.g());
        pdfDictionary.put(pdfName, pdfDictionary2);
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new HashMap();
        }
        this.templates.put(pdfAppearance, null);
    }

    public void setAppearanceState(String string) {
        if (string == null) {
            this.remove(PdfName.AS);
            return;
        }
        this.put(PdfName.AS, new PdfName(string));
    }

    public void setColor(Color color) {
        this.putDel(PdfName.C, new PdfColor(color));
    }

    public void setTitle(String string) {
        if (string == null) {
            this.remove(PdfName.T);
            return;
        }
        this.put(PdfName.T, new PdfString(string, "UnicodeBig"));
    }

    public void setPopup(PdfAnnotation pdfAnnotation) {
        this.put(PdfName.POPUP, pdfAnnotation.d());
        pdfAnnotation.put(PdfName.PARENT, this.d());
    }

    public void setAction(PdfAction pdfAction) {
        this.putDel(PdfName.A, pdfAction);
    }

    public void setAdditionalActions(PdfName pdfName, PdfAction pdfAction) {
        PdfObject pdfObject = this.get(PdfName.AA);
        PdfDictionary pdfDictionary = pdfObject != null && pdfObject.isDictionary() ? (PdfDictionary)pdfObject : new PdfDictionary();
        pdfDictionary.put(pdfName, pdfAction);
        this.put(PdfName.AA, pdfDictionary);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void a() {
        this.used = true;
    }

    public HashMap e() {
        return this.templates;
    }

    public boolean isForm() {
        return this.form;
    }

    public boolean isAnnotation() {
        return this.annotation;
    }

    public void setPage(int n2) {
        this.put(PdfName.P, this.writer.getPageReference(n2));
    }

    public void setPage() {
        this.put(PdfName.P, this.writer.a());
    }

    public int getPlaceInPage() {
        return this.placeInPage;
    }

    public void setPlaceInPage(int n2) {
        this.placeInPage = n2;
    }
}

