/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import java.io.IOException;
import java.io.OutputStream;

public class LZWDecoder {
    public byte[][] j;
    public byte[] d = null;
    public OutputStream e;
    public int b;
    public int g = 9;
    public int i;
    public int f;
    public int a = 0;
    public int c = 0;
    public int[] h = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] byArray, OutputStream outputStream) {
        int n2;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new RuntimeException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.d = byArray;
        this.e = outputStream;
        this.i = 0;
        this.f = 0;
        this.a = 0;
        this.c = 0;
        int n3 = 0;
        while ((n2 = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n2 == 256) {
                this.initializeStringTable();
                n2 = this.getNextCode();
                if (n2 == 257) break;
                this.writeString(this.j[n2]);
                n3 = n2;
                continue;
            }
            if (n2 < this.b) {
                byArray2 = this.j[n2];
                this.writeString(byArray2);
                this.addStringToTable(this.j[n3], byArray2[0]);
                n3 = n2;
                continue;
            }
            byArray2 = this.j[n3];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n3 = n2;
        }
    }

    public void initializeStringTable() {
        this.j = new byte[8192][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.j[i2] = new byte[1];
            this.j[i2][0] = (byte)i2;
        }
        this.b = 258;
        this.g = 9;
    }

    public void writeString(byte[] byArray) {
        try {
            this.e.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addStringToTable(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        this.j[this.b++] = byArray2;
        if (this.b == 511) {
            this.g = 10;
        } else if (this.b == 1023) {
            this.g = 11;
        } else if (this.b == 2047) {
            this.g = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.j[this.b++] = byArray;
        if (this.b == 511) {
            this.g = 10;
        } else if (this.b == 1023) {
            this.g = 11;
        } else if (this.b == 2047) {
            this.g = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.a = this.a << 8 | this.d[this.i++] & 0xFF;
            this.c += 8;
            if (this.c < this.g) {
                this.a = this.a << 8 | this.d[this.i++] & 0xFF;
                this.c += 8;
            }
            int n2 = this.a >> this.c - this.g & this.h[this.g - 9];
            this.c -= this.g;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

