/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentFont
extends BaseFont {
    public String h;
    public PRIndirectReference n;
    public PdfDictionary f;
    public IntHashtable k = new IntHashtable();
    public float p = 800.0f;
    public float j = 700.0f;
    public float e = -200.0f;
    public float o = 0.0f;
    public float q = -50.0f;
    public float g = -200.0f;
    public float b = 100.0f;
    public float i = 900.0f;
    public BaseFont r;
    public String[] s = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    public String[] m = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    public static final int[] l = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 36, 37, 38, 8217, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 8216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 162, 163, 8260, 165, 402, 167, 164, 39, 8220, 171, 8249, 8250, 64257, 64258, 0, 8211, 8224, 8225, 183, 0, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 0, 191, 0, 96, 180, 710, 732, 175, 728, 729, 168, 0, 730, 184, 0, 733, 731, 711, 8212, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 170, 0, 0, 0, 0, 321, 216, 338, 186, 0, 0, 0, 0, 0, 230, 0, 0, 0, 305, 0, 0, 322, 248, 339, 223, 0, 0, 0, 0};

    public DocumentFont(PRIndirectReference pRIndirectReference) {
        this.encoding = "";
        this.fontSpecific = false;
        this.n = pRIndirectReference;
        this.a = 4;
        this.f = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        this.h = PdfName.decodeName(((PdfName)PdfReader.getPdfObject(this.f.get(PdfName.BASEFONT))).toString());
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(this.f.get(PdfName.SUBTYPE));
        if (PdfName.TYPE1.equals(pdfName) || PdfName.TRUETYPE.equals(pdfName)) {
            this.doType1TT();
        } else {
            for (int i2 = 0; i2 < this.s.length; ++i2) {
                if (!this.h.startsWith(this.s[i2])) continue;
                this.h = this.s[i2];
                try {
                    this.r = BaseFont.createFont(this.h, this.m[i2], false);
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                return;
            }
        }
    }

    public void doType1TT() {
        int n2;
        Object object;
        PdfObject pdfObject;
        PdfObject pdfObject2;
        PdfObject pdfObject3 = PdfReader.getPdfObject(this.f.get(PdfName.ENCODING));
        if (pdfObject3 == null) {
            this.a(null);
        } else if (pdfObject3.isName()) {
            this.a((PdfName)pdfObject3);
        } else {
            pdfObject2 = (PdfDictionary)pdfObject3;
            if ((pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.BASEENCODING))) == null) {
                this.a(null);
            } else {
                this.a((PdfName)pdfObject3);
            }
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.DIFFERENCES));
            if (pdfObject != null) {
                object = ((PdfArray)pdfObject).getArrayList();
                n2 = 0;
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    PdfObject pdfObject4 = (PdfObject)((ArrayList)object).get(i2);
                    if (pdfObject4.isNumber()) {
                        n2 = ((PdfNumber)pdfObject4).intValue();
                        continue;
                    }
                    int[] nArray = GlyphList.nameToUnicode(PdfName.decodeName(((PdfName)pdfObject4).toString()));
                    if (nArray != null && nArray.length > 0) {
                        this.k.put(nArray[0], n2);
                    }
                    ++n2;
                }
            }
        }
        pdfObject2 = (PdfArray)PdfReader.getPdfObject(this.f.get(PdfName.WIDTHS));
        pdfObject = (PdfNumber)PdfReader.getPdfObject(this.f.get(PdfName.FIRSTCHAR));
        object = (PdfNumber)PdfReader.getPdfObject(this.f.get(PdfName.LASTCHAR));
        if (BuiltinFonts14.containsKey(this.h)) {
            BaseFont baseFont;
            try {
                baseFont = BaseFont.createFont(this.h, "Cp1252", false);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            int[] nArray = this.k.toOrderedKeys();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = this.k.get(nArray[i3]);
                this.widths[n3] = baseFont.a(n3, GlyphList.unicodeToName(nArray[i3]));
            }
            this.p = baseFont.getFontDescriptor(1, 1000.0f);
            this.j = baseFont.getFontDescriptor(2, 1000.0f);
            this.e = baseFont.getFontDescriptor(3, 1000.0f);
            this.o = baseFont.getFontDescriptor(4, 1000.0f);
            this.q = baseFont.getFontDescriptor(5, 1000.0f);
            this.g = baseFont.getFontDescriptor(6, 1000.0f);
            this.b = baseFont.getFontDescriptor(7, 1000.0f);
            this.i = baseFont.getFontDescriptor(8, 1000.0f);
        }
        if (pdfObject != null && object != null && pdfObject2 != null) {
            n2 = ((PdfNumber)pdfObject).intValue();
            ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                this.widths[n2 + i4] = ((PdfNumber)arrayList.get(i4)).intValue();
            }
        }
        this.a();
    }

    public void a() {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.f.get(PdfName.FONTDESCRIPTOR));
        if (pdfDictionary == null) {
            return;
        }
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ASCENT));
        if (pdfNumber != null) {
            this.p = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CAPHEIGHT))) != null) {
            this.j = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESCENT))) != null) {
            this.e = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ITALICANGLE))) != null) {
            this.o = pdfNumber.floatValue();
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTBBOX))) != null) {
            float f2;
            ArrayList arrayList = pdfArray.getArrayList();
            this.q = ((PdfNumber)arrayList.get(0)).floatValue();
            this.g = ((PdfNumber)arrayList.get(1)).floatValue();
            this.b = ((PdfNumber)arrayList.get(2)).floatValue();
            this.i = ((PdfNumber)arrayList.get(3)).floatValue();
            if (this.q > this.b) {
                f2 = this.q;
                this.q = this.b;
                this.b = f2;
            }
            if (this.g > this.i) {
                f2 = this.g;
                this.g = this.i;
                this.i = f2;
            }
        }
    }

    public void a(PdfName pdfName) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName) || PdfName.WIN_ANSI_ENCODING.equals(pdfName)) {
            byte[] byArray = new byte[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                byArray[i2] = (byte)i2;
            }
            String string = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName)) {
                string = "MacRoman";
            }
            String string2 = PdfEncodings.convertToString(byArray, string);
            char[] cArray = string2.toCharArray();
            for (int i3 = 0; i3 < 256; ++i3) {
                this.k.put(cArray[i3], i3);
            }
        } else {
            for (int i4 = 0; i4 < 256; ++i4) {
                this.k.put(l[i4], i4);
            }
        }
    }

    public String[][] getFamilyFontName() {
        return null;
    }

    public float getFontDescriptor(int n2, float f2) {
        if (this.r != null) {
            return this.r.getFontDescriptor(n2, f2);
        }
        switch (n2) {
            case 1: 
            case 9: {
                return this.p * f2 / 1000.0f;
            }
            case 2: {
                return this.j * f2 / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.e * f2 / 1000.0f;
            }
            case 4: {
                return this.o;
            }
            case 5: {
                return this.q * f2 / 1000.0f;
            }
            case 6: {
                return this.g * f2 / 1000.0f;
            }
            case 7: {
                return this.b * f2 / 1000.0f;
            }
            case 8: {
                return this.i * f2 / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.b - this.q) * f2 / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return null;
    }

    public int getKerning(char c2, char c3) {
        return 0;
    }

    public String getPostscriptFontName() {
        return this.h;
    }

    public int a(int n2, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public void a(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
    }

    public int getWidth(String string) {
        if (this.r != null) {
            return this.r.getWidth(string);
        }
        return super.getWidth(string);
    }

    public byte[] b(String string) {
        if (this.r != null) {
            return PdfEncodings.convertToBytes(string, "UnicodeBigUnmarked");
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            byArray[i2] = (byte)this.k.get(cArray[i2]);
        }
        return byArray;
    }

    public PdfIndirectReference b() {
        return this.n;
    }

    public boolean charExists(char c2) {
        if (this.r != null) {
            return this.r.charExists(c2);
        }
        return super.charExists(c2);
    }
}

