/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final int FONT_TYPE_DOCUMENT = 4;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    public static final String RESOURCE_PATH = "com/lowagie/text/pdf/fonts/";
    public static final char CID_NEWLINE = Short.MAX_VALUE;
    public int a;
    public static final String notdef = ".notdef";
    public int[] widths = new int[256];
    public String[] differences = new String[256];
    public char[] unicodeDifferences = new char[256];
    public String encoding;
    public boolean embedded;
    public boolean fontSpecific = true;
    public static HashMap fontCache = new HashMap();
    public static final HashMap BuiltinFonts14 = new HashMap();
    public boolean forceWidthsOutput = false;
    public boolean directTextToByte = false;
    public boolean subset = true;
    public boolean fastWinansi = false;
    public static Class c;
    public static Class d;

    public static BaseFont createFont(String string, String string2, boolean bl2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl2, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseFont createFont(String string, String string2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl4;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl5 = BuiltinFonts14.containsKey(string);
        boolean bl6 = bl4 = bl5 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl5 || bl4) {
            bl2 = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl2 = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl2;
        if (bl3) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl5 || string.toLowerCase().endsWith(".afm")) {
            baseFont2 = new Type1Font(string, string2, bl2, byArray, byArray2);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl2, byArray);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl2, byArray);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl4) {
            baseFont2 = new CJKFont(string, string2, bl2);
        } else {
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl3) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    return baseFont;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    public static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    public static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    public void createEncoding() {
        if (this.fontSpecific) {
            for (int i2 = 0; i2 < 256; ++i2) {
                this.widths[i2] = this.a(i2, null);
            }
        } else {
            byte[] byArray = new byte[1];
            for (int i3 = 0; i3 < 256; ++i3) {
                byArray[0] = (byte)i3;
                String string = PdfEncodings.convertToString(byArray, this.encoding);
                int n2 = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string2 = GlyphList.unicodeToName(n2);
                if (string2 == null) {
                    string2 = notdef;
                }
                this.differences[i3] = string2;
                this.unicodeDifferences[i3] = n2;
                this.widths[i3] = this.a(n2, string2);
            }
        }
    }

    public abstract int a(int var1, String var2);

    public abstract int getKerning(char var1, char var2);

    public int getWidth(char c2) {
        if (this.fastWinansi) {
            if (c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff') {
                return this.widths[c2];
            }
            return this.widths[PdfEncodings.b.get(c2)];
        }
        return this.getWidth(new String(new char[]{c2}));
    }

    public int getWidth(String string) {
        int n2 = 0;
        if (this.fastWinansi) {
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff') {
                    n2 += this.widths[c2];
                    continue;
                }
                n2 += this.widths[PdfEncodings.b.get(c2)];
            }
            return n2;
        }
        byte[] byArray = this.b(string);
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            n2 += this.widths[0xFF & byArray[i3]];
        }
        return n2;
    }

    public float getWidthPointKerned(String string, float f2) {
        float f3 = (float)this.getWidth(string) * 0.001f * f2;
        if (!this.hasKernPairs()) {
            return f3;
        }
        int n2 = string.length() - 1;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.getKerning(cArray[i2], cArray[i2 + 1]);
        }
        return f3 + (float)n3 * 0.001f * f2;
    }

    public float getWidthPoint(String string, float f2) {
        return (float)this.getWidth(string) * 0.001f * f2;
    }

    public float getWidthPoint(char c2, float f2) {
        return (float)this.getWidth(c2) * 0.001f * f2;
    }

    public byte[] b(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    public abstract void a(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.a;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    public char c(int n2) {
        return this.unicodeDifferences[n2];
    }

    public abstract String getPostscriptFontName();

    public abstract String[][] getFullFontName();

    public static String[][] getFullFontName(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getFullFontName();
    }

    public static Object[] getAllFontNames(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return new Object[]{baseFont.getPostscriptFontName(), baseFont.getFamilyFontName(), baseFont.getFullFontName()};
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).i();
    }

    public static String[] enumerateTTCNames(byte[] byArray) throws DocumentException, IOException {
        return new EnumerateTTC(byArray).i();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl2) {
        this.forceWidthsOutput = bl2;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl2) {
        this.directTextToByte = bl2;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl2) {
        this.subset = bl2;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            ClassLoader classLoader2;
            Method method = (c == null ? (c = BaseFont.a("java.lang.Thread")) : c).getMethod("getContextClassLoader", new Class[0]);
            if (method != null && (classLoader2 = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0])) != null) {
                inputStream = classLoader2.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = (d == null ? (d = BaseFont.a("com.lowagie.text.pdf.BaseFont")) : d).getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public char getUnicodeEquivalent(char c2) {
        return c2;
    }

    public char getCidCode(char c2) {
        return c2;
    }

    public abstract boolean hasKernPairs();

    public boolean charExists(char c2) {
        byte[] byArray = this.b(new String(new char[]{c2}));
        return byArray.length > 0;
    }

    public boolean setCharAdvance(char c2, int n2) {
        byte[] byArray = this.b(new String(new char[]{c2}));
        if (byArray.length == 0) {
            return false;
        }
        this.widths[0xFF & byArray[0]] = n2;
        return true;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    public class StreamFont
    extends PdfStream {
        private final BaseFont this$0;

        public StreamFont(BaseFont baseFont, byte[] byArray, int[] nArray) throws DocumentException {
            this.this$0 = baseFont;
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.put(new PdfName("Length" + (i2 + 1)), new PdfNumber(nArray[i2]));
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public StreamFont(BaseFont baseFont, byte[] byArray, String string) throws DocumentException {
            this.this$0 = baseFont;
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

