/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode39
extends Barcode {
    public static byte[][] b = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};
    public static String c = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*";
    public static String a = "%U$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z%A%B%C%D%E  /A/B/C/D/E/F/G/H/I/J/K/L - ./O 0 1 2 3 4 5 6 7 8 9/Z%F%G%H%I%J%V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z%K%L%M%N%O%W+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z%P%Q%R%S%T";

    public Barcode39() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = true;
            this.extended = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCode39(String string) {
        string = "*" + string + "*";
        byte[] byArray = new byte[string.length() * 10 - 1];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = c.indexOf(string.charAt(i2));
            if (n2 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(i2) + "' is illegal in code 39.");
            }
            System.arraycopy(b[n2], 0, byArray, i2 * 10, 9);
        }
        return byArray;
    }

    public static String getCode39Ex(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f') {
                throw new IllegalArgumentException("The character '" + c2 + "' is illegal in code 39 extended.");
            }
            char c3 = a.charAt(c2 * 2);
            char c4 = a.charAt(c2 * 2 + 1);
            if (c3 != ' ') {
                string2 = string2 + c3;
            }
            string2 = string2 + c4;
        }
        return string2;
    }

    public static char a(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = c.indexOf(string.charAt(i2));
            if (n3 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(i2) + "' is illegal in code 39.");
            }
            n2 += n3;
        }
        return c.charAt(n2 % 43);
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + Barcode39.a(string);
            }
            if (this.startStopText) {
                string = "*" + string + "*";
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.code;
        if (this.extended) {
            string = Barcode39.getCode39Ex(this.code);
        }
        int n2 = string.length() + 2;
        if (this.generateChecksum) {
            ++n2;
        }
        float f4 = (float)n2 * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n2 - 1) * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f2 = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + Barcode39.a(string);
            }
            if (this.startStopText) {
                string = "*" + string + "*";
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.code;
        if (this.extended) {
            string2 = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            string2 = string2 + Barcode39.a(string2);
        }
        int n2 = string2.length() + 2;
        float f3 = (float)n2 * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n2 - 1) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = Barcode39.getBarsCode39(string2);
        boolean bl2 = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8;
            float f9 = f8 = byArray[i2] == 0 ? this.x : this.x * this.n;
            if (bl2) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl2 = !bl2;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.code;
        if (this.extended) {
            string = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            string = string + Barcode39.a(string);
        }
        int n5 = string.length() + 2;
        int n6 = (int)this.n;
        int n7 = n5 * (6 + 3 * n6) + (n5 - 1);
        byte[] byArray = Barcode39.getBarsCode39(string);
        boolean bl2 = true;
        int n8 = 0;
        int n9 = (int)this.barHeight;
        int[] nArray = new int[n7 * n9];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n10 = byArray[n2] == 0 ? 1 : n6;
            int n11 = n4;
            if (bl2) {
                n11 = n3;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < n10; ++i2) {
                nArray[n8++] = n11;
            }
        }
        for (n2 = n7; n2 < nArray.length; n2 += n7) {
            System.arraycopy(nArray, 0, nArray, n2, n7);
        }
        Image image = canvas.createImage(new MemoryImageSource(n7, n9, nArray, 0, n7));
        return image;
    }
}

