/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode128
extends Barcode {
    public static byte[][] b = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    public static byte[] a = new byte[]{2, 3, 3, 1, 1, 1, 2};
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1_INDEX = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';
    public static final char FNC1 = '\u00ca';
    public static final char DEL = '\u00c3';
    public static final char FNC3 = '\u00c4';
    public static final char FNC2 = '\u00c5';
    public static final char SHIFT = '\u00c6';
    public static final char CODE_C = '\u00c7';
    public static final char CODE_A = '\u00c8';
    public static final char FNC4 = '\u00c8';
    public static final char STARTA = '\u00cb';
    public static final char STARTB = '\u00cc';
    public static final char STARTC = '\u00cd';

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static boolean b(String string, int n2, int n3) {
        if (n2 + n3 > string.length()) {
            return false;
        }
        while (n3-- > 0) {
            char c2;
            if ((c2 = string.charAt(n2++)) >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static String a(String string, int n2, int n3) {
        String string2 = "";
        while (n3 > 0) {
            n3 -= 2;
            int n4 = string.charAt(n2++) - 48;
            int n5 = string.charAt(n2++) - 48;
            string2 = string2 + (char)(n4 * 10 + n5);
        }
        return string2;
    }

    public static String getRawText(String string, boolean bl2) {
        int n2;
        String string2 = "";
        int n3 = string.length();
        if (n3 == 0) {
            string2 = string2 + 'h';
            if (bl2) {
                string2 = string2 + 'f';
            }
            return string2;
        }
        char c2 = '\u0000';
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string.charAt(n2);
            if (c2 <= '\u007f') continue;
            throw new RuntimeException("There are illegal characters for barcode 128 in '" + string + "'.");
        }
        c2 = string.charAt(0);
        n2 = 104;
        int n4 = 0;
        if (Barcode128.b(string, n4, 2)) {
            n2 = 105;
            string2 = string2 + (char)n2;
            if (bl2) {
                string2 = string2 + 'f';
            }
            string2 = string2 + Barcode128.a(string, n4, 2);
            n4 += 2;
        } else if (c2 < ' ') {
            n2 = 103;
            string2 = string2 + (char)n2;
            if (bl2) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c2 + 64);
            ++n4;
        } else {
            string2 = string2 + (char)n2;
            if (bl2) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c2 - 32);
            ++n4;
        }
        while (n4 < n3) {
            switch (n2) {
                case 103: {
                    if (Barcode128.b(string, n4, 4)) {
                        n2 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.a(string, n4, 4);
                        n4 += 4;
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) > '_') {
                        n2 = 104;
                        string2 = string2 + 'd';
                        string2 = string2 + (char)(c2 - 32);
                        break;
                    }
                    if (c2 < ' ') {
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.b(string, n4, 4)) {
                        n2 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.a(string, n4, 4);
                        n4 += 4;
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) < ' ') {
                        n2 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.b(string, n4, 2)) {
                        string2 = string2 + Barcode128.a(string, n4, 2);
                        n4 += 2;
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) < ' ') {
                        n2 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    n2 = 104;
                    string2 = string2 + 'd';
                    string2 = string2 + (char)(c2 - 32);
                }
            }
        }
        return string2;
    }

    public static byte[] getBarsCode128Raw(String string) {
        int n2;
        int n3 = string.indexOf(65535);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        int n4 = string.charAt(0);
        for (int i2 = 1; i2 < string.length(); ++i2) {
            n4 += i2 * string.charAt(i2);
        }
        string = string + (char)(n4 %= 103);
        byte[] byArray = new byte[(string.length() + 1) * 6 + 7];
        for (n2 = 0; n2 < string.length(); ++n2) {
            System.arraycopy(b[string.charAt(n2)], 0, byArray, n2 * 6, 6);
        }
        System.arraycopy(a, 0, byArray, n2 * 6, 7);
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        int n2;
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.codeType == 11) {
                n2 = this.code.indexOf(65535);
                string = n2 < 0 ? "" : this.code.substring(n2 + 1);
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string.length();
        float f4 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        int n2;
        String string = this.code;
        if (this.codeType == 11) {
            int n3 = this.code.indexOf(65535);
            string = n3 < 0 ? "" : this.code.substring(n3 + 1);
        }
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string2.length();
        float f3 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = Barcode128.getBarsCode128Raw(string2);
        boolean bl2 = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8 = (float)byArray[i2] * this.x;
            if (bl2) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl2 = !bl2;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3;
        int n4 = color.getRGB();
        int n5 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.codeType == 11 ? ((n3 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n3) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n3 = string.length();
        int n6 = (n3 + 2) * 11 + 2;
        byte[] byArray = Barcode128.getBarsCode128Raw(string);
        boolean bl2 = true;
        int n7 = 0;
        int n8 = (int)this.barHeight;
        int[] nArray = new int[n6 * n8];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n9 = byArray[n2];
            int n10 = n5;
            if (bl2) {
                n10 = n4;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < n9; ++i2) {
                nArray[n7++] = n10;
            }
        }
        for (n2 = n6; n2 < nArray.length; n2 += n6) {
            System.arraycopy(nArray, 0, nArray, n2, n6);
        }
        Image image = canvas.createImage(new MemoryImageSource(n6, n8, nArray, 0, n6));
        return image;
    }
}

