/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class Section
extends ArrayList
implements TextElementArray {
    public Paragraph title;
    public int numberDepth;
    public float indentationLeft;
    public float indentationRight;
    public float sectionIndent;
    public int subsections = 0;
    public ArrayList numbers = null;
    public boolean bookmarkOpen = true;

    public Section() {
        this.title = new Paragraph();
        this.numberDepth = 1;
    }

    public Section(Paragraph paragraph, int n2) {
        this.numberDepth = n2;
        this.title = paragraph;
    }

    private void setNumbers(int n2, ArrayList arrayList) {
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(n2));
        this.numbers.addAll(arrayList);
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 13;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(int n2, Object object) {
        try {
            Element element = (Element)object;
            if (element.type() != 12 && element.type() != 14 && element.type() != 10 && element.type() != 11 && element.type() != 17 && element.type() != 29 && element.type() != 22 && element.type() != 23 && element.type() != 35 && element.type() != 32 && element.type() != 34) {
                throw new ClassCastException(String.valueOf(element.type()));
            }
            super.add(n2, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean add(Object object) {
        try {
            Element element = (Element)object;
            if (element.type() == 12 || element.type() == 14 || element.type() == 10 || element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 35 || element.type() == 23 || element.type() == 32 || element.type() == 34) {
                return super.add(object);
            }
            if (element.type() == 13) {
                Section section = (Section)object;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(section);
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public Section addSection(float f2, Paragraph paragraph, int n2) {
        Section section = new Section(paragraph, n2);
        section.setIndentation(f2);
        this.add(section);
        return section;
    }

    public Section addSection(float f2, Paragraph paragraph) {
        Section section = new Section(paragraph, 1);
        section.setIndentation(f2);
        this.add(section);
        return section;
    }

    public Section addSection(Paragraph paragraph, int n2) {
        Section section = new Section(paragraph, n2);
        this.add(section);
        return section;
    }

    public Section addSection(Paragraph paragraph) {
        Section section = new Section(paragraph, 1);
        this.add(section);
        return section;
    }

    public Section addSection(float f2, String string, int n2) {
        Section section = new Section(new Paragraph(string), n2);
        section.setIndentation(f2);
        this.add(section);
        return section;
    }

    public Section addSection(String string, int n2) {
        Section section = new Section(new Paragraph(string), n2);
        this.add(section);
        return section;
    }

    public Section addSection(float f2, String string) {
        Section section = new Section(new Paragraph(string), 1);
        section.setIndentation(f2);
        this.add(section);
        return section;
    }

    public Section addSection(String string) {
        Section section = new Section(new Paragraph(string), 1);
        this.add(section);
        return section;
    }

    public Section addSection(Properties properties) {
        Section section = new Section(new Paragraph(""), 1);
        String string = (String)properties.remove("number");
        if (string != null) {
            this.subsections = Integer.parseInt(string) - 1;
        }
        section.set(properties);
        this.add(section);
        return section;
    }

    public void set(Properties properties) {
        String string = (String)properties.remove("numberdepth");
        if (string != null) {
            this.setNumberDepth(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("indent")) != null) {
            this.setIndentation(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
    }

    public void setTitle(Paragraph paragraph) {
        this.title = paragraph;
    }

    public void setNumberDepth(int n2) {
        this.numberDepth = n2;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public void setIndentation(float f2) {
        this.sectionIndent = f2;
    }

    public boolean isChapter() {
        return this.type() == 16;
    }

    public boolean isSection() {
        return this.type() == 13;
    }

    public int numberDepth() {
        return this.numberDepth;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public float indentation() {
        return this.sectionIndent;
    }

    public int depth() {
        return this.numbers.size();
    }

    public Paragraph title() {
        if (this.title == null) {
            return null;
        }
        int n2 = Math.min(this.numbers.size(), this.numberDepth);
        if (n2 < 1) {
            return this.title;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.insert(0, ".");
            stringBuffer.insert(0, (Integer)this.numbers.get(i2));
        }
        Paragraph paragraph = new Paragraph(this.title);
        paragraph.setMarkupAttributes(this.title.getMarkupAttributes());
        paragraph.add(0, new Chunk(stringBuffer.toString(), this.title.font()));
        return paragraph;
    }

    public static boolean isTitle(String string) {
        return "title".equals(string);
    }

    public static boolean isTag(String string) {
        return "section".equals(string);
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public void setBookmarkOpen(boolean bl2) {
        this.bookmarkOpen = bl2;
    }
}

