/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.Properties;

public class ListItem
extends Paragraph
implements TextElementArray,
MarkupAttributes {
    private Chunk symbol;

    public ListItem() {
    }

    public ListItem(float f2) {
        super(f2);
    }

    public ListItem(Chunk chunk) {
        super(chunk);
    }

    public ListItem(String string) {
        super(string);
    }

    public ListItem(String string, Font font) {
        super(string, font);
    }

    public ListItem(float f2, Chunk chunk) {
        super(f2, chunk);
    }

    public ListItem(float f2, String string) {
        super(f2, string);
    }

    public ListItem(float f2, String string, Font font) {
        super(f2, string, font);
    }

    public ListItem(Phrase phrase) {
        super(phrase);
    }

    public ListItem(Properties properties) {
        super("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            this.add(new Chunk(string));
        }
        if ((string = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        } else {
            string = (String)properties.remove("line-height");
            if (string != null) {
                this.setLeading(MarkupParser.parseLength(string));
            }
        }
        string = (String)properties.remove("indentationleft");
        if (string != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public int type() {
        return 15;
    }

    public void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
        if (this.symbol.font().isStandardFont()) {
            this.symbol.setFont(this.font);
        }
    }

    public Chunk listSymbol() {
        return this.symbol;
    }

    public static boolean isTag(String string) {
        return "listitem".equals(string);
    }
}

