/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.windows.WindowsBorders;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public final class WindowsToolBarUI
extends MetalToolBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsToolBarUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    public void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    public void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(this){
            private final WindowsToolBarUI this$0;
            {
                this.this$0 = windowsToolBarUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("jgoodies.windows.borderStyle")) {
                    WindowsToolBarUI.a(this.this$0);
                }
            }
        };
    }

    private void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "jgoodies.windows.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (HeaderStyle.from(this.toolBar) == HeaderStyle.BOTH) {
            string = "headerBorder";
        } else {
            return;
        }
        LookAndFeel.installBorder(this.toolBar, "ToolBar." + string);
    }

    public BasicToolBarUI.DockingListener createDockingListener(JToolBar jToolBar) {
        return new BasicToolBarUI.DockingListener(this, jToolBar);
    }

    public Border createRolloverBorder() {
        return WindowsBorders.g();
    }

    public void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                super.setBorderToRollover(container.getComponent(i2));
            }
        }
    }

    public static void a(WindowsToolBarUI windowsToolBarUI) {
        windowsToolBarUI.installSpecialBorder();
    }
}

