/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public final class WindowsMenuUI
extends com.sun.java.swing.plaf.windows.WindowsMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer n2 = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = n2 != null ? n2 : 2;
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        if (this.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
        }
        Dimension dimension = super.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (n4 % 2 == 1) {
            --n4;
        }
        return new Dimension(n3, n4);
    }

    public void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        if (this.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        } else {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
    }

    private boolean isSubMenu(JMenuItem jMenuItem) {
        return !((JMenu)jMenuItem).isTopLevelMenu();
    }
}

