/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public final class PlasticComboBoxButton
extends JButton {
    private static final int LEFT_INSET = 2;
    private static final int RIGHT_INSET = 3;
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    public boolean iconOnly = false;
    private boolean borderPaintsFocus;

    public PlasticComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl2, CellRendererPane cellRendererPane, JList jList) {
        super("");
        this.setModel(new DefaultButtonModel(this){
            private final PlasticComboBoxButton this$0;
            {
                this.this$0 = plasticComboBoxButton;
            }

            public void setArmed(boolean bl2) {
                super.setArmed(this.isPressed() || bl2);
            }
        });
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl2;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(jComboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(jComboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 3));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public Icon getComboIcon() {
        return this.comboIcon;
    }

    public void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public boolean isIconOnly() {
        return this.iconOnly;
    }

    public void setIconOnly(boolean bl2) {
        this.iconOnly = bl2;
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (bl2) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    private boolean is3D() {
        if (PlasticUtils.a(this.comboBox)) {
            return true;
        }
        if (PlasticUtils.b(this.comboBox)) {
            return false;
        }
        return PlasticUtils.a("ComboBox.");
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        super.paintComponent(graphics);
        boolean bl2 = PlasticUtils.a((Component)this.comboBox);
        Insets insets = this.getInsets();
        int n7 = this.getWidth() - (insets.left + insets.right);
        int n8 = this.getHeight() - (insets.top + insets.bottom);
        if (n8 <= 0 || n7 <= 0) {
            return;
        }
        int n9 = insets.left;
        int n10 = insets.top;
        int n11 = n9 + (n7 - 1);
        int n12 = 0;
        int n13 = n6 = bl2 ? n11 : n9;
        if (this.comboIcon != null) {
            n12 = this.comboIcon.getIconWidth();
            n5 = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                n6 = (this.getWidth() - n12) / 2;
                n4 = (this.getHeight() - n5) / 2;
            } else {
                n6 = bl2 ? n9 + (n7 - 1) - n12 : n9;
                n4 = (this.getHeight() - n5) / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n6, n4);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            n4 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, n4 != 0, false);
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.select"));
                }
                component.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            }
            n3 = n7 - (insets.right + n12);
            n2 = component instanceof JPanel;
            int n14 = bl2 ? n9 : n9 + n12;
            int n15 = this.getHeight() - 2 - 3 - 1;
            if (!this.is3D()) {
                this.rendererPane.paintComponent(graphics, component, this, n14, n10 + 2, n3, n15, n2 != 0);
            } else if (!(component instanceof JComponent)) {
                this.rendererPane.paintComponent(graphics, component, this, n14, n10 + 2, n3, n15, n2 != 0);
            } else if (!component.isOpaque()) {
                this.rendererPane.paintComponent(graphics, component, this, n14, n10 + 2, n3, n15, n2 != 0);
            } else {
                JComponent jComponent = (JComponent)component;
                boolean bl3 = jComponent.isOpaque();
                jComponent.setOpaque(false);
                this.rendererPane.paintComponent(graphics, component, this, n14, n10 + 2, n3, n15, n2 != 0);
                jComponent.setOpaque(bl3);
            }
        }
        if (this.comboIcon != null) {
            n5 = this.comboBox.hasFocus() ? 1 : 0;
            if (!this.borderPaintsFocus && n5 != 0) {
                graphics.setColor(PlasticLookAndFeel.getFocusColor());
                n4 = 2;
                int n16 = 2;
                n3 = this.getWidth() - 2 - 3;
                n2 = this.getHeight() - 2 - 3;
                graphics.drawRect(n4, n16, n3 - 1, n2 - 1);
            }
        }
    }
}

