/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class ExtBasicMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ExtBasicMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer n2 = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = n2 != null ? n2 : 2;
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        if (this.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
        }
        return super.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
    }

    public void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        if (this.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        } else {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        this.uninstallRolloverListener();
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
    }

    public void installListeners() {
        super.installListeners();
        this.mouseListener = this.createRolloverListener();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    public MouseListener createRolloverListener() {
        return new MouseAdapter(this){
            private final ExtBasicMenuUI this$0;
            {
                this.this$0 = extBasicMenuUI;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.getModel().setRollover(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.getModel().setRollover(false);
            }
        };
    }

    private boolean isSubMenu(JMenuItem jMenuItem) {
        return !((JMenu)jMenuItem).isTopLevelMenu();
    }
}

