/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public final class LookUtils {
    private static final String JAVA_VERSION = LookUtils.getSystemProperty("java.version");
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_JAVA_1_4 = LookUtils.startsWith(JAVA_VERSION, "1.4");
    public static final boolean a = LookUtils.startsWith(JAVA_VERSION, "1.4.0");
    public static final boolean IS_JAVA_1_4_2_OR_LATER = !LookUtils.startsWith(JAVA_VERSION, "1.4.0") && !LookUtils.startsWith(JAVA_VERSION, "1.4.1");
    public static final boolean IS_JAVA_5 = LookUtils.startsWith(JAVA_VERSION, "1.5");
    public static final boolean IS_OS_FREEBSD = LookUtils.startsWithIgnoreCase(OS_NAME, "FreeBSD");
    public static final boolean IS_OS_LINUX = LookUtils.startsWithIgnoreCase(OS_NAME, "Linux");
    public static final boolean IS_OS_OS2 = LookUtils.startsWith(OS_NAME, "OS/2");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS = LookUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_MODERN = LookUtils.startsWith(OS_NAME, "Windows") && !LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_XP = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "5.1");
    public static final boolean IS_OS_SOLARIS = LookUtils.startsWith(OS_NAME, "Solaris");
    public static final boolean IS_LAF_WINDOWS_XP_ENABLED = LookUtils.isWindowsXPLafEnabled();
    public static final boolean IS_LOW_RESOLUTION = LookUtils.isLowResolution();
    private static boolean loggingEnabled = true;

    private LookUtils() {
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            LookUtils.log("Can't read the System property " + string + ".");
            return null;
        }
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            LookUtils.log("Can't read the System property " + string + ".");
            return string2;
        }
    }

    public static Boolean getBooleanSystemProperty(String string, String string2) {
        String string3 = LookUtils.getSystemProperty(string, "");
        Boolean bl2 = string3.equalsIgnoreCase("false") ? Boolean.FALSE : (string3.equalsIgnoreCase("true") ? Boolean.TRUE : null);
        if (bl2 != null) {
            LookUtils.log(string2 + " have been " + (bl2 != false ? "en" : "dis") + "abled in the system properties.");
        }
        return bl2;
    }

    private static boolean isWindowsXPLafEnabled() {
        return IS_OS_WINDOWS_XP && IS_JAVA_1_4_2_OR_LATER && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && LookUtils.getSystemProperty("swing.noxp") == null;
    }

    public static boolean isTrueColor(Component component) {
        return component.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static void installNarrowMargin(AbstractButton abstractButton, String string) {
        Object object = abstractButton.getClientProperty("jgoodies.isNarrow");
        boolean bl2 = Boolean.TRUE.equals(object);
        String string2 = string + (bl2 ? "narrowMargin" : "margin");
        Insets insets = abstractButton.getMargin();
        if (insets == null || insets instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string2));
        }
    }

    public static Insets createButtonMargin(boolean bl2) {
        int n2 = bl2 || Options.getUseNarrowButtons() ? 4 : 14;
        return IS_LOW_RESOLUTION ? new InsetsUIResource(2, n2, 1, n2) : new InsetsUIResource(3, n2, 3, n2);
    }

    public static Color getSlightlyBrighter(Color color) {
        return LookUtils.getSlightlyBrighter(color, 1.1f);
    }

    public static Color getSlightlyBrighter(Color color, float f2) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f3 = fArray[0];
        float f4 = fArray[1];
        float f5 = fArray[2];
        float f6 = Math.min(f5 * f2, 1.0f);
        return Color.getHSBColor(f3, f4, f6);
    }

    public static void setLookAndTheme(LookAndFeel lookAndFeel, Object object) throws UnsupportedLookAndFeelException {
        if (lookAndFeel instanceof PlasticLookAndFeel && object != null && object instanceof PlasticTheme) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)object);
        }
        UIManager.setLookAndFeel(lookAndFeel);
    }

    public static Object getDefaultTheme(LookAndFeel lookAndFeel) {
        return lookAndFeel instanceof PlasticLookAndFeel ? PlasticLookAndFeel.createMyDefaultTheme() : null;
    }

    public static List getInstalledThemes(LookAndFeel lookAndFeel) {
        return lookAndFeel instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getInstalledThemes() : Collections.EMPTY_LIST;
    }

    public static void setLoggingEnabled(boolean bl2) {
        loggingEnabled = bl2;
    }

    public static void log() {
        if (loggingEnabled) {
            System.out.println();
        }
    }

    public static void log(String string) {
        if (loggingEnabled) {
            System.out.println("JGoodies Looks: " + string);
        }
    }

    private static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    }

    private static boolean startsWith(String string, String string2) {
        return string != null && string.startsWith(string2);
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string != null && string.toUpperCase().startsWith(string2.toUpperCase());
    }
}

